/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.integrationtests;

import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Properties;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.kie.api.KieBase;
import org.kie.api.io.Resource;
import org.kie.api.io.ResourceType;
import org.kie.internal.builder.KnowledgeBuilder;
import org.kie.internal.builder.KnowledgeBuilderConfiguration;
import org.kie.internal.builder.KnowledgeBuilderFactory;
import org.kie.internal.io.ResourceFactory;

public class ParallelCompilationTest {
    private static final int PARALLEL_THREADS = 5;
    private static final String DRL_FILE = "parallel_compilation.drl";
    private ExecutorService executor;

    @Before
    public void setUp() throws Exception {
        this.executor = Executors.newFixedThreadPool(5);
    }

    @After
    public void tearDown() throws Exception {
        this.executor.shutdownNow();
    }

    @Test(timeout=10000L)
    public void testConcurrentRuleAdditions() throws Exception {
        this.parallelExecute(BuildExecutor.getSolvers());
    }

    private void parallelExecute(Collection<Callable<KieBase>> solvers) throws Exception {
        ExecutorCompletionService<KieBase> ecs = new ExecutorCompletionService<KieBase>(this.executor);
        for (Callable<KieBase> s : solvers) {
            ecs.submit(s);
        }
        for (int i = 0; i < 5; ++i) {
            KieBase kieBase = (KieBase)ecs.take().get();
        }
    }

    public static class User {
        private int age;
        private boolean risky;
        private Gender gender;
        private String name;

        public User(int age, Gender gender, String name) {
            this.age = age;
            this.gender = gender;
            this.name = name;
        }

        public int getAge() {
            return this.age;
        }

        public void setAge(int age) {
            this.age = age;
        }

        public Gender getGender() {
            return this.gender;
        }

        public void setGender(Gender gender) {
            this.gender = gender;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public boolean isRisky() {
            return this.risky;
        }

        public void setRisky(boolean risky) {
            this.risky = risky;
        }

        public static enum Gender {
            MALE,
            FEMALE,
            OTHER;

        }
    }

    public static class BuildExecutor
    implements Callable<KieBase> {
        @Override
        public KieBase call() throws Exception {
            InputStreamReader source = new InputStreamReader(ParallelCompilationTest.class.getResourceAsStream(ParallelCompilationTest.DRL_FILE));
            Properties props = new Properties();
            props.setProperty("drools.dialect.java.compiler.lnglevel", "1.6");
            KnowledgeBuilderConfiguration configuration = KnowledgeBuilderFactory.newKnowledgeBuilderConfiguration((Properties)props, (ClassLoader[])new ClassLoader[]{ParallelCompilationTest.class.getClass().getClassLoader()});
            KnowledgeBuilder builder = KnowledgeBuilderFactory.newKnowledgeBuilder((KnowledgeBuilderConfiguration)configuration);
            Thread.sleep(Math.round(Math.random() * 250.0));
            Resource newReaderResource = ResourceFactory.newReaderResource((Reader)source);
            builder.add(newReaderResource, ResourceType.DRL);
            KieBase result = builder.newKieBase();
            return result;
        }

        public static Collection<Callable<KieBase>> getSolvers() {
            ArrayList<Callable<KieBase>> solvers = new ArrayList<Callable<KieBase>>();
            for (int i = 0; i < 5; ++i) {
                solvers.add(new BuildExecutor());
            }
            return solvers;
        }
    }
}

