/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.integrationtests;

import org.drools.core.impl.InternalKnowledgeBase;
import org.drools.core.impl.KnowledgeBaseFactory;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kie.api.io.ResourceType;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.rule.FactHandle;
import org.kie.api.runtime.rule.QueryResults;
import org.kie.internal.builder.KnowledgeBuilder;
import org.kie.internal.builder.KnowledgeBuilderFactory;
import org.kie.internal.io.ResourceFactory;

public class Query3Test {
    private InternalKnowledgeBase knowledgeBase;

    @Before
    public void setUp() throws Exception {
        String text = "";
        text = text + "package org.drools.integrationtests\n";
        text = text + "import " + Bar.class.getCanonicalName() + "\n";
        text = text + "import " + Foo.class.getCanonicalName() + "\n";
        text = text + "import " + Foo2.class.getCanonicalName() + "\n";
        text = text + "query \"testDifferent\"\n";
        text = text + "    foo : Foo();\n";
        text = text + "    bar : Bar(id == foo.id)\n";
        text = text + "end\n";
        text = text + "query \"testSame\"\n";
        text = text + "    foo : Foo();\n";
        text = text + "    foo2 : Foo(id == foo.id);\n";
        text = text + "end\n";
        text = text + "query \"testExtends\"\n";
        text = text + "    foo : Foo();\n";
        text = text + "    foo2 : Foo2(id == foo.id);\n";
        text = text + "end\n";
        KnowledgeBuilder knowledgeBuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        knowledgeBuilder.add(ResourceFactory.newByteArrayResource((byte[])text.getBytes()), ResourceType.DRL);
        Assert.assertFalse((boolean)knowledgeBuilder.hasErrors());
        this.knowledgeBase = KnowledgeBaseFactory.newKnowledgeBase();
        this.knowledgeBase.addPackages(knowledgeBuilder.getKnowledgePackages());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doIt(Object o1, Object o2, String query, int expected, boolean doUpdate, boolean doRetract) {
        KieSession knowledgeSession = this.knowledgeBase.newKieSession();
        try {
            knowledgeSession.insert(o1);
            FactHandle handle2 = knowledgeSession.insert(o2);
            if (doUpdate) {
                knowledgeSession.update(handle2, o2);
            } else if (doRetract) {
                knowledgeSession.retract(handle2);
                handle2 = knowledgeSession.insert(o2);
            }
            QueryResults queryResults = knowledgeSession.getQueryResults(query, new Object[0]);
            Assert.assertEquals((long)expected, (long)queryResults.size());
        }
        finally {
            knowledgeSession.dispose();
        }
    }

    @Test
    public void testDifferent() {
        Foo foo = new Foo();
        foo.setId("x");
        Bar bar = new Bar();
        bar.setId("x");
        this.doIt(foo, bar, "testDifferent", 1, false, false);
    }

    @Test
    public void testDifferentWithUpdate() {
        Foo foo = new Foo();
        foo.setId("x");
        Bar bar = new Bar();
        bar.setId("x");
        this.doIt(foo, bar, "testDifferent", 1, true, false);
    }

    @Test
    public void testSame() {
        Foo foo = new Foo();
        foo.setId("x");
        Foo foo2 = new Foo();
        foo2.setId("x");
        this.doIt(foo, foo2, "testSame", 4, false, false);
    }

    @Test
    public void testSameWithUpdate() {
        Foo foo = new Foo();
        foo.setId("x");
        Foo foo2 = new Foo();
        foo2.setId("x");
        this.doIt(foo, foo2, "testSame", 4, true, false);
    }

    @Test
    public void testExtends() {
        Foo foo = new Foo();
        foo.setId("x");
        Foo2 foo2 = new Foo2();
        foo2.setId("x");
        this.doIt(foo, foo2, "testExtends", 2, false, false);
    }

    @Test
    public void testExtendsWithUpdate() {
        Foo foo = new Foo();
        foo.setId("x");
        Foo2 foo2 = new Foo2();
        foo2.setId("x");
        this.doIt(foo, foo2, "testExtends", 2, true, false);
    }

    @Test
    public void testExtendsWithRetract() {
        Foo foo = new Foo();
        foo.setId("x");
        Foo2 foo2 = new Foo2();
        foo2.setId("x");
        this.doIt(foo, foo2, "testExtends", 2, false, true);
    }

    public static class Foo2
    extends Foo {
    }

    public static class Foo {
        private String id;

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }
    }

    public static class Bar {
        private String id;

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }
    }
}

