/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.integrationtests;

import java.util.ArrayList;
import org.drools.core.impl.InternalKnowledgeBase;
import org.drools.core.impl.KnowledgeBaseFactory;
import org.junit.Assert;
import org.junit.Test;
import org.kie.api.KieBase;
import org.kie.api.io.ResourceType;
import org.kie.api.runtime.KieSession;
import org.kie.internal.builder.CompositeKnowledgeBuilder;
import org.kie.internal.builder.KnowledgeBuilder;
import org.kie.internal.builder.KnowledgeBuilderError;
import org.kie.internal.builder.KnowledgeBuilderFactory;
import org.kie.internal.io.ResourceFactory;

public class RuleExtensionTest {
    @Test
    public void testRuleExtendsNonexistingRule() {
        String str = "package org.drools.test;\n\nglobal java.util.List list;\n\nrule \"Base\"\nwhen\n  String( this == \"go\" )\nthen\nend\n\nrule \"ExtYes\" extends \"Bas\"\nwhen\nthen\n  list.add( 1 );\nend\n";
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])str.getBytes()), ResourceType.DRL);
        Assert.assertTrue((boolean)kbuilder.hasErrors());
        ((KnowledgeBuilderError)kbuilder.getErrors().iterator().next()).toString().contains("Base");
    }

    @Test
    public void testRuleExtendsBetweenDRLs() {
        String str = "package org.drools.test;\n\nglobal java.util.List list;\n\nrule \"Base\"\nwhen\n  String( this == \"go\" )\nthen\nend\n";
        String str2 = "package org.drools.test;\n\nrule \"ExtYes\" extends \"Base\"\nwhen\nthen\n  list.add( 1 );\nend\n";
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])str.getBytes()), ResourceType.DRL);
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])str2.getBytes()), ResourceType.DRL);
        Assert.assertFalse((boolean)kbuilder.hasErrors());
        InternalKnowledgeBase kb = KnowledgeBaseFactory.newKnowledgeBase();
        kb.addPackages(kbuilder.getKnowledgePackages());
        KieSession knowledgeSession = kb.newKieSession();
        ArrayList list = new ArrayList();
        knowledgeSession.setGlobal("list", list);
        knowledgeSession.fireAllRules();
        Assert.assertEquals((long)0L, (long)list.size());
        knowledgeSession.insert((Object)"go");
        knowledgeSession.fireAllRules();
        Assert.assertEquals((long)1L, (long)list.size());
    }

    @Test
    public void testRuleExtendsOnIncrementalKB() {
        String str = "package org.drools.test;\n\nglobal java.util.List list;\n\nrule \"Base\"\nwhen\n  String( this == \"go\" )\nthen\nend\n";
        String str2 = "package org.drools.test;\nglobal java.util.List list;\n\nrule \"ExtYes\" extends \"Base\"\nwhen\nthen\n  list.add( 1 );\nend\n";
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])str.getBytes()), ResourceType.DRL);
        Assert.assertFalse((boolean)kbuilder.hasErrors());
        InternalKnowledgeBase kb = KnowledgeBaseFactory.newKnowledgeBase();
        kb.addPackages(kbuilder.getKnowledgePackages());
        KnowledgeBuilder kbuilder2 = KnowledgeBuilderFactory.newKnowledgeBuilder((KieBase)kb);
        kbuilder2.add(ResourceFactory.newByteArrayResource((byte[])str2.getBytes()), ResourceType.DRL);
        Assert.assertFalse((boolean)kbuilder2.hasErrors());
        KieSession knowledgeSession = kb.newKieSession();
        ArrayList list = new ArrayList();
        knowledgeSession.setGlobal("list", list);
        knowledgeSession.fireAllRules();
        Assert.assertEquals((long)0L, (long)list.size());
        knowledgeSession.insert((Object)"go");
        knowledgeSession.fireAllRules();
        Assert.assertEquals((long)1L, (long)list.size());
    }

    @Test
    public void testRuleExtendsMissingOnIncrementalKB() {
        String str = "package org.drools.test;\n\nglobal java.util.List list;\n\nrule \"Base\"\nwhen\n  String( this == \"go\" )\nthen\nend\n";
        String str2 = "package org.drools.test;\nglobal java.util.List list;\n\nrule \"ExtYes\" extends \"Bse\"\nwhen\nthen\n  list.add( 1 );\nend\n";
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])str.getBytes()), ResourceType.DRL);
        Assert.assertFalse((boolean)kbuilder.hasErrors());
        InternalKnowledgeBase kb = KnowledgeBaseFactory.newKnowledgeBase();
        kb.addPackages(kbuilder.getKnowledgePackages());
        KnowledgeBuilder kbuilder2 = KnowledgeBuilderFactory.newKnowledgeBuilder((KieBase)kb);
        kbuilder2.add(ResourceFactory.newByteArrayResource((byte[])str2.getBytes()), ResourceType.DRL);
        Assert.assertTrue((boolean)kbuilder2.hasErrors());
    }

    @Test
    public void testRuleExtendsWithCompositeKBuilder() {
        String str = "package org.drools.test;\n\nglobal java.util.List list;\n\nrule \"Base\"\nwhen\n  String( this == \"go\" )\nthen\nend\n";
        String str2 = "package org.drools.test;\nglobal java.util.List list;\n\nrule \"ExtYes\" extends \"Base\"\nwhen\nthen\n  list.add( 1 );\nend\n";
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        CompositeKnowledgeBuilder ckb = kbuilder.batch();
        ckb.add(ResourceFactory.newByteArrayResource((byte[])str.getBytes()), ResourceType.DRL).add(ResourceFactory.newByteArrayResource((byte[])str2.getBytes()), ResourceType.DRL).build();
        Assert.assertFalse((boolean)kbuilder.hasErrors());
        InternalKnowledgeBase kb = KnowledgeBaseFactory.newKnowledgeBase();
        kb.addPackages(kbuilder.getKnowledgePackages());
        KieSession knowledgeSession = kb.newKieSession();
        ArrayList list = new ArrayList();
        knowledgeSession.setGlobal("list", list);
        knowledgeSession.fireAllRules();
        Assert.assertEquals((long)0L, (long)list.size());
        knowledgeSession.insert((Object)"go");
        knowledgeSession.fireAllRules();
        Assert.assertEquals((long)1L, (long)list.size());
    }

    @Test
    public void testRuleExtendsNonExistingWithCompositeKBuilder() {
        String str = "package org.drools.test;\n\nglobal java.util.List list;\n\nrule \"Base\"\nwhen\n  String( this == \"go\" )\nthen\nend\n";
        String str2 = "package org.drools.test;\nglobal java.util.List list;\n\nrule \"ExtYes\" extends \"ase\"\nwhen\nthen\n  list.add( 1 );\nend\n";
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        CompositeKnowledgeBuilder ckb = kbuilder.batch();
        ckb.add(ResourceFactory.newByteArrayResource((byte[])str.getBytes()), ResourceType.DRL).add(ResourceFactory.newByteArrayResource((byte[])str2.getBytes()), ResourceType.DRL).build();
        Assert.assertTrue((boolean)kbuilder.hasErrors());
    }

    @Test
    public void testRuleExtendsNonExistingWithCompositeKBuilderOutOfOrder() {
        String str = "package org.drools.test;\n\nglobal java.util.List list;\n\nrule \"Base\"\nwhen\n  String( this == \"go\" )\nthen\nend\n";
        String str2 = "package org.drools.test;\nglobal java.util.List list;\n\nrule \"ExtYes\" extends \"ase\"\nwhen\nthen\n  list.add( 1 );\nend\n";
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        CompositeKnowledgeBuilder ckb = kbuilder.batch();
        ckb.add(ResourceFactory.newByteArrayResource((byte[])str2.getBytes()), ResourceType.DRL).add(ResourceFactory.newByteArrayResource((byte[])str.getBytes()), ResourceType.DRL).build();
        Assert.assertTrue((boolean)kbuilder.hasErrors());
        System.out.println(kbuilder.getErrors());
        Assert.assertFalse((boolean)kbuilder.getErrors().toString().contains("Circular"));
        Assert.assertTrue((boolean)kbuilder.getErrors().toString().contains("Base"));
    }

    @Test
    public void testRuleExtendsWithCompositeKBuilderFreeOrder() {
        String str = "package org.drools.test;\n\nglobal java.util.List list;\n\nrule \"Base\"\nwhen\n  String( this == \"go\" )\nthen\nend\n";
        String str2 = "package org.drools.test;\nglobal java.util.List list;\n\nrule \"ExtYes\" extends \"Base\"\nwhen\nthen\n  list.add( 1 );\nend\n";
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        CompositeKnowledgeBuilder ckb = kbuilder.batch();
        ckb.add(ResourceFactory.newByteArrayResource((byte[])str2.getBytes()), ResourceType.DRL).add(ResourceFactory.newByteArrayResource((byte[])str.getBytes()), ResourceType.DRL).build();
        Assert.assertFalse((boolean)kbuilder.hasErrors());
        InternalKnowledgeBase kb = KnowledgeBaseFactory.newKnowledgeBase();
        kb.addPackages(kbuilder.getKnowledgePackages());
        KieSession knowledgeSession = kb.newKieSession();
        ArrayList list = new ArrayList();
        knowledgeSession.setGlobal("list", list);
        knowledgeSession.fireAllRules();
        Assert.assertEquals((long)0L, (long)list.size());
        knowledgeSession.insert((Object)"go");
        knowledgeSession.fireAllRules();
        Assert.assertEquals((long)1L, (long)list.size());
    }

    @Test
    public void testRuleExtendsExtendsWithCompositeKBuilderFreeOrder() {
        String str1 = "package org.drools.test;\n\nrule \"Base\"\nwhen\n  $i : Integer( this < 5 )\nthen\nend\n";
        String str2 = "package org.drools.test;\n\nrule \"ExtYes\" extends \"Base\"\nwhen\n  $j : Integer( this > 5 )\nthen\nend\n";
        String str3 = "package org.drools.test;\nglobal java.util.List list;\n\nrule \"FinalRule\" extends \"ExtYes\"\nwhen\nthen\n  list.add( $i + $j );\nend\n";
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        CompositeKnowledgeBuilder ckb = kbuilder.batch();
        ckb.add(ResourceFactory.newByteArrayResource((byte[])str3.getBytes()), ResourceType.DRL).add(ResourceFactory.newByteArrayResource((byte[])str1.getBytes()), ResourceType.DRL).add(ResourceFactory.newByteArrayResource((byte[])str2.getBytes()), ResourceType.DRL).build();
        Assert.assertFalse((boolean)kbuilder.hasErrors());
        InternalKnowledgeBase kb = KnowledgeBaseFactory.newKnowledgeBase();
        kb.addPackages(kbuilder.getKnowledgePackages());
        KieSession knowledgeSession = kb.newKieSession();
        ArrayList list = new ArrayList();
        knowledgeSession.setGlobal("list", list);
        knowledgeSession.fireAllRules();
        Assert.assertEquals((long)0L, (long)list.size());
        knowledgeSession.insert((Object)4);
        knowledgeSession.insert((Object)6);
        knowledgeSession.fireAllRules();
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertEquals((long)10L, (long)((Integer)list.get(0)).intValue());
    }

    @Test
    public void testRuleCircularExtension() {
        String str1 = "package org.drools.test;\n\nrule \"Base\" extends \"FinalRule\"\nwhen\n  $i : Integer( this < 5 )\nthen\nend\n";
        String str2 = "package org.drools.test;\n\nrule \"ExtYes\" extends \"Base\"\nwhen\n  $j : Integer( this > 5 )\nthen\nend\n";
        String str3 = "package org.drools.test;\nglobal java.util.List list;\n\nrule \"Dummy\"\nwhen\nthen\nend\nrule \"FinalRule\" extends \"ExtYes\"\nwhen\nthen\n  list.add( $i + $j );\nend\n";
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        CompositeKnowledgeBuilder ckb = kbuilder.batch();
        ckb.add(ResourceFactory.newByteArrayResource((byte[])str3.getBytes()), ResourceType.DRL).add(ResourceFactory.newByteArrayResource((byte[])str1.getBytes()), ResourceType.DRL).add(ResourceFactory.newByteArrayResource((byte[])str2.getBytes()), ResourceType.DRL).build();
        Assert.assertTrue((boolean)kbuilder.hasErrors());
        Assert.assertEquals((long)1L, (long)kbuilder.getErrors().size());
        Assert.assertTrue((boolean)((KnowledgeBuilderError)kbuilder.getErrors().iterator().next()).toString().contains("Circular"));
    }
}

