/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.integrationtests;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kie.api.KieBase;
import org.kie.api.KieServices;
import org.kie.api.builder.KieBuilder;
import org.kie.api.builder.KieFileSystem;
import org.kie.api.builder.ReleaseId;
import org.kie.api.builder.model.KieBaseModel;
import org.kie.api.builder.model.KieModuleModel;
import org.kie.api.command.Command;
import org.kie.api.definition.type.FactType;
import org.kie.api.runtime.KieContainer;
import org.kie.api.runtime.KieSession;
import org.kie.internal.command.CommandFactory;
import org.kie.internal.io.ResourceFactory;

public class SeveralKieSessionsTest {
    private static final String PACKAGE = SeveralKieSessionsTest.class.getPackage().getName();
    private static final String PACKAGE_PATH = PACKAGE.replaceAll("\\.", "/");
    private static final String DRL_FILE_NAME = "several_kie_sessions.drl";
    private ReleaseId kieModuleId;

    @Before
    public void init() {
        this.kieModuleId = this.prepareKieModule();
    }

    @Test
    public void testFamilyWithTwoKieSessionsFromKieContainer() throws Exception {
        KieServices ks = KieServices.Factory.get();
        KieContainer kieContainer = ks.newKieContainer(this.kieModuleId);
        KieSession ksession = kieContainer.newKieSession();
        this.performTestAndDispose(ksession);
        KieContainer kieContainerOther = ks.newKieContainer(this.kieModuleId);
        KieSession ksessionOther = kieContainerOther.newKieSession();
        this.performTestAndDispose(ksessionOther);
    }

    private ReleaseId prepareKieModule() {
        KieServices ks = KieServices.Factory.get();
        ReleaseId releaseId = ks.newReleaseId("org.drools.compiler", "severalKieSessionsTest", "1.0.0");
        KieModuleModel module = ks.newKieModuleModel();
        KieBaseModel baseModel = module.newKieBaseModel("defaultKBase");
        baseModel.setDefault(true);
        baseModel.addPackage("*");
        baseModel.newKieSessionModel("defaultKSession").setDefault(true);
        KieFileSystem kfs = ks.newKieFileSystem();
        kfs.writeKModuleXML(module.toXML());
        kfs.generateAndWritePomXML(releaseId);
        kfs.write("src/main/resources/" + PACKAGE_PATH + "/" + DRL_FILE_NAME, ResourceFactory.newClassPathResource((String)DRL_FILE_NAME, this.getClass()));
        KieBuilder builder = ks.newKieBuilder(kfs).buildAll();
        Assert.assertEquals((long)0L, (long)builder.getResults().getMessages().size());
        ks.getRepository().addKieModule(builder.getKieModule());
        return releaseId;
    }

    private void performTestAndDispose(KieSession ksession) throws Exception {
        try {
            this.performTest(ksession);
        }
        finally {
            ksession.dispose();
        }
    }

    private void performTest(KieSession ksession) throws Exception {
        KieBase kbase = ksession.getKieBase();
        FactType manType = kbase.getFactType(PACKAGE, "Man");
        FactType womanType = kbase.getFactType(PACKAGE, "Woman");
        FactType parentType = kbase.getFactType(PACKAGE, "Parent");
        ArrayList<Command> commands = new ArrayList<Command>();
        ListHolder listHolder = new ListHolder();
        commands.add(CommandFactory.newInsert((Object)listHolder));
        Object parent1 = parentType.newInstance();
        parentType.set(parent1, "parent", (Object)"Eva");
        parentType.set(parent1, "child", (Object)"Abel");
        commands.add(CommandFactory.newInsert((Object)parent1));
        Object parent2 = parentType.newInstance();
        parentType.set(parent2, "parent", (Object)"Eva");
        parentType.set(parent2, "child", (Object)"Kain");
        commands.add(CommandFactory.newInsert((Object)parent2));
        Object parent3 = parentType.newInstance();
        parentType.set(parent3, "parent", (Object)"Adam");
        parentType.set(parent3, "child", (Object)"Abel");
        commands.add(CommandFactory.newInsert((Object)parent3));
        Object parent4 = parentType.newInstance();
        parentType.set(parent4, "parent", (Object)"Adam");
        parentType.set(parent4, "child", (Object)"Kain");
        commands.add(CommandFactory.newInsert((Object)parent4));
        Object parent5 = parentType.newInstance();
        parentType.set(parent5, "parent", (Object)"Abel");
        parentType.set(parent5, "child", (Object)"Josef");
        commands.add(CommandFactory.newInsert((Object)parent5));
        Object adam = manType.newInstance();
        manType.set(adam, "name", (Object)"Adam");
        commands.add(CommandFactory.newInsert((Object)adam));
        Object eva = womanType.newInstance();
        womanType.set(eva, "name", (Object)"Eva");
        womanType.set(eva, "age", (Object)101);
        commands.add(CommandFactory.newInsert((Object)eva));
        Object abel = manType.newInstance();
        manType.set(abel, "name", (Object)"Abel");
        commands.add(CommandFactory.newInsert((Object)abel));
        Object kain = manType.newInstance();
        manType.set(kain, "name", (Object)"Kain");
        commands.add(CommandFactory.newInsert((Object)kain));
        Object josef = manType.newInstance();
        manType.set(josef, "name", (Object)"Josef");
        commands.add(CommandFactory.newInsert((Object)josef));
        commands.add(CommandFactory.newFireAllRules());
        ksession.execute((Command)CommandFactory.newBatchExecution(commands));
        List<String> manList = listHolder.getManList();
        Assert.assertEquals((long)manList.size(), (long)4L);
        Assert.assertTrue((boolean)manList.contains("Adam"));
        Assert.assertTrue((boolean)manList.contains("Kain"));
        Assert.assertTrue((boolean)manList.contains("Abel"));
        Assert.assertTrue((boolean)manList.contains("Josef"));
        List<String> personList = listHolder.getPersonList();
        Assert.assertEquals((long)personList.size(), (long)5L);
        Assert.assertTrue((boolean)personList.contains("Adam"));
        Assert.assertTrue((boolean)personList.contains("Kain"));
        Assert.assertTrue((boolean)personList.contains("Abel"));
        Assert.assertTrue((boolean)personList.contains("Josef"));
        Assert.assertTrue((boolean)personList.contains("Eva"));
        List<String> parentList = listHolder.getParentList();
        Assert.assertEquals((long)parentList.size(), (long)5L);
        Assert.assertTrue((boolean)parentList.contains("Adam"));
        Assert.assertTrue((boolean)parentList.contains("Eva"));
        Assert.assertTrue((boolean)parentList.contains("Abel"));
        List<String> motherList = listHolder.getMotherList();
        Assert.assertEquals((long)motherList.size(), (long)2L);
        Assert.assertTrue((boolean)motherList.contains("Eva"));
        List<String> fatherList = listHolder.getFatherList();
        Assert.assertEquals((long)fatherList.size(), (long)3L);
        Assert.assertTrue((boolean)fatherList.contains("Adam"));
        Assert.assertTrue((boolean)fatherList.contains("Abel"));
        Assert.assertFalse((boolean)fatherList.contains("Eva"));
        Assert.assertFalse((boolean)fatherList.contains("Kain"));
        Assert.assertFalse((boolean)fatherList.contains("Josef"));
        List<String> grandparentList = listHolder.getGrandparentList();
        Assert.assertEquals((long)grandparentList.size(), (long)2L);
        Assert.assertTrue((boolean)grandparentList.contains("Eva"));
        Assert.assertTrue((boolean)grandparentList.contains("Adam"));
        Assert.assertTrue((boolean)listHolder.isGrandmaBlessedAgeTriggered());
    }

    public static class ListHolder
    implements Serializable {
        private static final long serialVersionUID = -3058814255413392428L;
        private List<String> things = new ArrayList<String>();
        private List<String> food = new ArrayList<String>();
        private List<String> exits = new ArrayList<String>();
        private List<String> manList = new ArrayList<String>();
        private List<String> personList = new ArrayList<String>();
        private List<String> parentList = new ArrayList<String>();
        private List<String> motherList = new ArrayList<String>();
        private List<String> fatherList = new ArrayList<String>();
        private List<String> grandparentList = new ArrayList<String>();
        private boolean grandmaBlessedAgeTriggered = false;

        ListHolder() {
        }

        public void setThings(List<String> things) {
            this.things = things;
        }

        public List<String> getThings() {
            return this.things;
        }

        public void setFood(List<String> food) {
            this.food = food;
        }

        public List<String> getFood() {
            return this.food;
        }

        public void setExits(List<String> exits) {
            this.exits = exits;
        }

        public List<String> getExits() {
            return this.exits;
        }

        public void setManList(List<String> manList) {
            this.manList = manList;
        }

        public List<String> getManList() {
            return this.manList;
        }

        public void setPersonList(List<String> PersonList) {
            this.personList = PersonList;
        }

        public List<String> getPersonList() {
            return this.personList;
        }

        public void setParentList(List<String> parentList) {
            this.parentList = parentList;
        }

        public List<String> getParentList() {
            return this.parentList;
        }

        public void setMotherList(List<String> motherList) {
            this.motherList = motherList;
        }

        public List<String> getMotherList() {
            return this.motherList;
        }

        public void setGrandparentList(List<String> grandparentList) {
            this.grandparentList = grandparentList;
        }

        public List<String> getGrandparentList() {
            return this.grandparentList;
        }

        public void setGrandmaBlessedAgeTriggered(boolean grandmaBlessedAgeTriggered) {
            this.grandmaBlessedAgeTriggered = grandmaBlessedAgeTriggered;
        }

        public boolean isGrandmaBlessedAgeTriggered() {
            return this.grandmaBlessedAgeTriggered;
        }

        public void setFatherList(List<String> fatherList) {
            this.fatherList = fatherList;
        }

        public List<String> getFatherList() {
            return this.fatherList;
        }
    }
}

