/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.integrationtests;

import java.util.ArrayList;
import org.drools.mvel.CommonTestMethodBase;
import org.drools.mvel.compiler.Cheesery;
import org.drools.mvel.compiler.Child;
import org.drools.mvel.compiler.MockPersistentSet;
import org.drools.mvel.compiler.ObjectWithSet;
import org.drools.mvel.integrationtests.SerializationHelper;
import org.junit.Assert;
import org.junit.Test;
import org.kie.api.KieBase;
import org.kie.api.runtime.KieSession;

public class ShadowProxyTest
extends CommonTestMethodBase {
    @Test
    public void testShadowProxyInHierarchies() throws Exception {
        KieBase kbase = SerializationHelper.serializeObject(this.loadKnowledgeBase("test_ShadowProxyInHierarchies.drl"));
        KieSession ksession = this.createKnowledgeSession(kbase);
        try {
            ksession.insert((Object)new Child("gp"));
            ksession.fireAllRules();
        }
        finally {
            ksession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testShadowProxyOnCollections() throws Exception {
        KieBase kbase = SerializationHelper.serializeObject(this.loadKnowledgeBase("test_ShadowProxyOnCollections.drl"));
        KieSession ksession = this.createKnowledgeSession(kbase);
        try {
            ArrayList results = new ArrayList();
            ksession.setGlobal("results", results);
            Cheesery cheesery = new Cheesery();
            ksession.insert((Object)cheesery);
            ksession.fireAllRules();
            Assert.assertEquals((long)1L, (long)results.size());
            Assert.assertEquals((long)1L, (long)cheesery.getCheeses().size());
            Assert.assertEquals(results.get(0), (Object)cheesery.getCheeses().get(0));
        }
        finally {
            ksession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testShadowProxyOnCollections2() throws Exception {
        KieBase kbase = SerializationHelper.serializeObject(this.loadKnowledgeBase("test_ShadowProxyOnCollections2.drl"));
        KieSession ksession = this.createKnowledgeSession(kbase);
        try {
            ArrayList results = new ArrayList();
            ksession.setGlobal("results", results);
            ArrayList<String> list = new ArrayList<String>();
            list.add("example1");
            list.add("example2");
            MockPersistentSet mockPersistentSet = new MockPersistentSet(false);
            mockPersistentSet.addAll(list);
            ObjectWithSet objectWithSet = new ObjectWithSet();
            objectWithSet.setSet(mockPersistentSet);
            ksession.insert((Object)objectWithSet);
            ksession.fireAllRules();
            Assert.assertEquals((long)1L, (long)results.size());
            Assert.assertEquals((Object)"show", (Object)objectWithSet.getMessage());
        }
        finally {
            ksession.dispose();
        }
    }
}

