/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.integrationtests;

import java.io.InputStream;
import java.util.ArrayList;
import org.drools.core.impl.InternalKnowledgeBase;
import org.drools.core.impl.KnowledgeBaseFactory;
import org.drools.mvel.CommonTestMethodBase;
import org.drools.mvel.compiler.Person;
import org.drools.mvel.compiler.RoutingMessage;
import org.junit.Assert;
import org.junit.Test;
import org.kie.api.KieBase;
import org.kie.api.io.ResourceType;
import org.kie.api.runtime.KieSession;
import org.kie.internal.builder.KnowledgeBuilder;
import org.kie.internal.builder.KnowledgeBuilderError;
import org.kie.internal.builder.KnowledgeBuilderErrors;
import org.kie.internal.builder.KnowledgeBuilderFactory;
import org.kie.internal.io.ResourceFactory;

public class StrEvaluatorTest
extends CommonTestMethodBase {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testStrStartsWith() {
        KieBase kbase = this.readKnowledgeBase();
        KieSession ksession = this.createKnowledgeSession(kbase);
        try {
            ArrayList list = new ArrayList();
            ksession.setGlobal("list", list);
            RoutingMessage m = new RoutingMessage();
            m.setRoutingValue("R1:messageBody");
            ksession.insert((Object)m);
            ksession.fireAllRules();
            Assert.assertTrue((list.size() == 4 ? 1 : 0) != 0);
            Assert.assertTrue((boolean)list.get(0).equals("Message starts with R1"));
            Assert.assertTrue((boolean)list.get(1).equals("Message length is not 17"));
            Assert.assertTrue((boolean)list.get(2).equals("Message does not start with R2"));
            Assert.assertTrue((boolean)list.get(3).equals("Message does not end with R1"));
        }
        finally {
            ksession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testStrEndsWith() {
        KieBase kbase = this.readKnowledgeBase();
        KieSession ksession = this.createKnowledgeSession(kbase);
        try {
            ArrayList list = new ArrayList();
            ksession.setGlobal("list", list);
            RoutingMessage m = new RoutingMessage();
            m.setRoutingValue("messageBody:R2");
            ksession.insert((Object)m);
            ksession.fireAllRules();
            Assert.assertTrue((list.size() == 4 ? 1 : 0) != 0);
            Assert.assertTrue((boolean)list.get(0).equals("Message ends with R2"));
            Assert.assertTrue((boolean)list.get(1).equals("Message length is not 17"));
            Assert.assertTrue((boolean)list.get(2).equals("Message does not start with R2"));
            Assert.assertTrue((boolean)list.get(3).equals("Message does not end with R1"));
        }
        finally {
            ksession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testStrLengthEquals() {
        KieBase kbase = this.readKnowledgeBase();
        KieSession ksession = this.createKnowledgeSession(kbase);
        try {
            ArrayList list = new ArrayList();
            ksession.setGlobal("list", list);
            RoutingMessage m = new RoutingMessage();
            m.setRoutingValue("R1:messageBody:R2");
            ksession.insert((Object)m);
            ksession.fireAllRules();
            Assert.assertEquals((long)6L, (long)list.size());
            Assert.assertTrue((boolean)list.contains("Message length is 17"));
        }
        finally {
            ksession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testStrNotStartsWith() {
        KieBase kbase = this.readKnowledgeBase();
        KieSession ksession = this.createKnowledgeSession(kbase);
        try {
            ArrayList list = new ArrayList();
            ksession.setGlobal("list", list);
            RoutingMessage m = new RoutingMessage();
            m.setRoutingValue("messageBody");
            ksession.insert((Object)m);
            ksession.fireAllRules();
            Assert.assertTrue((list.size() == 3 ? 1 : 0) != 0);
            Assert.assertTrue((boolean)list.get(1).equals("Message does not start with R2"));
        }
        finally {
            ksession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testStrNotEndsWith() {
        KieBase kbase = this.readKnowledgeBase();
        KieSession ksession = this.createKnowledgeSession(kbase);
        try {
            ArrayList list = new ArrayList();
            ksession.setGlobal("list", list);
            RoutingMessage m = new RoutingMessage();
            m.setRoutingValue("messageBody");
            ksession.insert((Object)m);
            ksession.fireAllRules();
            Assert.assertTrue((list.size() == 3 ? 1 : 0) != 0);
            Assert.assertTrue((boolean)list.get(0).equals("Message length is not 17"));
            Assert.assertTrue((boolean)list.get(1).equals("Message does not start with R2"));
            Assert.assertTrue((boolean)list.get(2).equals("Message does not end with R1"));
        }
        finally {
            ksession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testStrLengthNoEquals() {
        KieBase kbase = this.readKnowledgeBase();
        KieSession ksession = this.createKnowledgeSession(kbase);
        try {
            ArrayList list = new ArrayList();
            ksession.setGlobal("list", list);
            RoutingMessage m = new RoutingMessage();
            m.setRoutingValue("messageBody");
            ksession.insert((Object)m);
            ksession.fireAllRules();
            Assert.assertTrue((list.size() == 3 ? 1 : 0) != 0);
            Assert.assertTrue((boolean)list.get(0).equals("Message length is not 17"));
            Assert.assertTrue((boolean)list.get(1).equals("Message does not start with R2"));
            Assert.assertTrue((boolean)list.get(2).equals("Message does not end with R1"));
        }
        finally {
            ksession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testStrWithLogicalOr() {
        String drl = "package org.drools.mvel.integrationtests\nimport org.drools.mvel.compiler.RoutingMessage\nrule R1\n when\n RoutingMessage( routingValue == \"R2\" || routingValue str[startsWith] \"R1\" )\n then\nend\n";
        KieBase kbase = this.loadKnowledgeBaseFromString(drl);
        KieSession ksession = kbase.newKieSession();
        try {
            for (String msgValue : new String[]{"R1something", "R2something", "R2"}) {
                RoutingMessage msg = new RoutingMessage();
                msg.setRoutingValue(msgValue);
                ksession.insert((Object)msg);
            }
            Assert.assertEquals((String)"Wrong number of rules fired", (long)2L, (long)ksession.fireAllRules());
        }
        finally {
            ksession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testStrWithInlineCastAndFieldOnThis() {
        String drl = "package org.drools.mvel.integrationtests import " + Person.class.getName() + "; rule R1  when  Object( this#" + Person.class.getName() + ".name str[startsWith] \"M\" )  then end ";
        KieBase kbase = this.loadKnowledgeBaseFromString(drl);
        KieSession ksession = kbase.newKieSession();
        try {
            ksession.insert((Object)new Person("Mark"));
            Assert.assertEquals((String)"Wrong number of rules fired", (long)1L, (long)ksession.fireAllRules());
        }
        finally {
            ksession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testStrWithInlineCastOnThis() {
        String drl = "package org.drools.mvel.integrationtests rule R1  when  Object( this#String str[startsWith] \"M\" )  then end ";
        KieBase kbase = this.loadKnowledgeBaseFromString(drl);
        KieSession ksession = kbase.newKieSession();
        try {
            ksession.insert((Object)"Mark");
            Assert.assertEquals((String)"Wrong number of rules fired", (long)1L, (long)ksession.fireAllRules());
        }
        finally {
            ksession.dispose();
        }
    }

    private KieBase readKnowledgeBase() {
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newInputStreamResource((InputStream)this.getClass().getResourceAsStream("strevaluator_test.drl")), ResourceType.DRL);
        KnowledgeBuilderErrors errors = kbuilder.getErrors();
        if (errors.size() > 0) {
            for (KnowledgeBuilderError error : errors) {
                System.err.println(error);
            }
            throw new IllegalArgumentException("Could not parse knowledge." + errors.toArray());
        }
        InternalKnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addPackages(kbuilder.getKnowledgePackages());
        return kbase;
    }
}

