/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.integrationtests;

import org.junit.After;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;
import org.kie.api.io.ResourceType;
import org.kie.internal.builder.KnowledgeBuilder;
import org.kie.internal.builder.KnowledgeBuilderFactory;
import org.kie.internal.io.ResourceFactory;

public class SwitchOverStringTest {
    private static final String FUNCTION_WITH_SWITCH_OVER_STRING = "function void theTest(String input) {\n  switch(input) {\n    case \"Hello World\" :      System.out.println(\"yep\");\n      break;\n    default :\n      System.out.println(\"uh\");\n      break;\n  }\n}";

    @After
    public void cleanUp() {
        System.clearProperty("drools.dialect.java.compiler.lnglevel");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCompileSwitchOverStringWithLngLevel17() {
        double javaVersion = Double.valueOf(System.getProperty("java.specification.version"));
        Assume.assumeTrue((String)"Test only makes sense on Java 7+.", (javaVersion >= 1.7 ? 1 : 0) != 0);
        System.setProperty("drools.dialect.java.compiler.lnglevel", "1.7");
        try {
            KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
            kbuilder.add(ResourceFactory.newByteArrayResource((byte[])FUNCTION_WITH_SWITCH_OVER_STRING.getBytes()), ResourceType.DRL);
            Assert.assertFalse((String)"Compilation error(s) occurred!", (boolean)kbuilder.hasErrors());
        }
        finally {
            System.clearProperty("drools.dialect.java.compiler.lnglevel");
        }
    }

    @Test
    public void testShouldFailToCompileSwitchOverStringWithLngLevel16() {
        System.setProperty("drools.dialect.java.compiler.lnglevel", "1.6");
        try {
            KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
            kbuilder.add(ResourceFactory.newByteArrayResource((byte[])FUNCTION_WITH_SWITCH_OVER_STRING.getBytes()), ResourceType.DRL);
            Assert.assertTrue((String)"Compilation error(s) expected!", (boolean)kbuilder.hasErrors());
        }
        finally {
            System.clearProperty("drools.dialect.java.compiler.lnglevel");
        }
    }
}

