/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.integrationtests.concurrency;

import java.util.concurrent.Callable;
import org.drools.mvel.integrationtests.concurrency.AbstractConcurrentInsertionsTest;
import org.junit.Test;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.rule.FactHandle;

public class BasicConcurrentInsertionsTest
extends AbstractConcurrentInsertionsTest {
    @Test(timeout=10000L)
    public void testConcurrentInsertionsFewObjectsManyThreads() throws InterruptedException {
        String drl = "import " + Bean.class.getCanonicalName() + ";\n\nrule \"R\"\nwhen\n    $a : Bean( seed != 1 )\nthen\nend";
        this.testConcurrentInsertions(drl, 1, 1000, false, false);
    }

    @Test(timeout=10000L)
    public void testConcurrentInsertionsManyObjectsFewThreads() throws InterruptedException {
        String drl = "import " + Bean.class.getCanonicalName() + ";\n\nrule \"R\"\nwhen\n    $a : Bean( seed != 1 )\nthen\nend";
        this.testConcurrentInsertions(drl, 1000, 4, false, false);
    }

    @Test(timeout=10000L)
    public void testConcurrentInsertionsNewSessionEachThreadUpdateFacts() throws InterruptedException {
        String drl = "import " + Bean.class.getCanonicalName() + ";\n query existsBeanSeed5More() \n     Bean( seed > 5 ) \n end \n\nrule \"R\"\nwhen\n    $a: Bean( seed != 1 )\n    existsBeanSeed5More() \nthen\nend \nrule \"R2\"\nwhen\n    $a: Bean( seed != 1 )\nthen\nend\n";
        this.testConcurrentInsertions(drl, 10, 1000, true, true);
    }

    @Test(timeout=10000L)
    public void testConcurrentInsertionsNewSessionEachThread() throws InterruptedException {
        String drl = "import " + Bean.class.getCanonicalName() + ";\n query existsBeanSeed5More() \n     Bean( seed > 5 ) \n end \n\nrule \"R\"\nwhen\n    $a: Bean( seed != 1 )\n    $b: Bean( seed != 2 )\n    existsBeanSeed5More() \nthen\nend \nrule \"R2\"\nwhen\n    $a: Bean( seed != 1 )\n    $b: Bean( seed != 2 )\nthen\nend\nrule \"R3\"\nwhen\n    $a: Bean( seed != 3 )\n    $b: Bean( seed != 4 )\n    $c: Bean( seed != 5 )\n    $d: Bean( seed != 6 )\n    $e: Bean( seed != 7 )\nthen\nend";
        this.testConcurrentInsertions(drl, 10, 1000, true, false);
    }

    @Override
    protected Callable<Boolean> getTask(int objectCount, KieSession ksession, boolean disposeSession, boolean updateFacts) {
        return () -> {
            try {
                for (int j = 0; j < 10; ++j) {
                    int i;
                    FactHandle[] facts = new FactHandle[objectCount];
                    for (i = 0; i < objectCount; ++i) {
                        facts[i] = ksession.insert((Object)new Bean(i));
                    }
                    if (updateFacts) {
                        for (i = 0; i < objectCount; ++i) {
                            ksession.update(facts[i], (Object)new Bean(-i));
                        }
                    }
                    for (FactHandle fact : facts) {
                        ksession.delete(fact);
                    }
                    ksession.fireAllRules();
                }
                Boolean j = true;
                return j;
            }
            catch (Exception e) {
                e.printStackTrace();
                Boolean bl = false;
                return bl;
            }
            finally {
                if (disposeSession) {
                    ksession.dispose();
                }
            }
        };
    }

    public static class Bean {
        private final int seed;
        private final String threadName;

        public Bean(int seed) {
            this.seed = seed;
            this.threadName = Thread.currentThread().getName();
        }

        public int getSeed() {
            return this.seed;
        }

        public boolean equals(Object other) {
            if (!(other instanceof Bean)) {
                return false;
            }
            return this.seed == ((Bean)other).seed && this.threadName.equals(((Bean)other).threadName);
        }

        public int hashCode() {
            return 29 * this.seed + 31 * this.threadName.hashCode();
        }

        public String toString() {
            return "Bean #" + this.seed + " created by " + this.threadName;
        }
    }
}

