/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.integrationtests.concurrency;

import java.util.Arrays;
import java.util.List;
import org.drools.mvel.integrationtests.concurrency.AbstractConcurrentTest;
import org.drools.mvel.integrationtests.facts.CategoryTypeEnum;
import org.drools.mvel.integrationtests.facts.Product;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class EnumEvaluationConcurrentSessionsTest
extends AbstractConcurrentTest {
    private static final Integer NUMBER_OF_THREADS = 10;
    private static final Integer NUMBER_OF_REPETITIONS = 1;

    @Parameterized.Parameters(name="Enforced jitting={0}, Serialize KieBase={1}, Share KieBase={2}")
    public static List<Boolean[]> getTestParameters() {
        return Arrays.asList({false, false, false}, {false, true, false}, {true, false, false}, {true, true, false}, {false, false, true}, {false, true, true}, {true, false, true}, {true, true, true});
    }

    public EnumEvaluationConcurrentSessionsTest(boolean enforcedJitting, boolean serializeKieBase, boolean sharedKieBase) {
        super(enforcedJitting, serializeKieBase, sharedKieBase, false);
    }

    @Test(timeout=20000L)
    public void testEnum2() throws InterruptedException {
        String drl1 = "import " + Product.class.getCanonicalName() + ";\nimport " + CategoryTypeEnum.class.getCanonicalName() + ";\nrule R1 when\n  $s : String( this == \"odd\" )\n  $p : Product( id != \"test\", categoryAsEnum == CategoryTypeEnum.ODD, firings not contains \"R1\" )\nthen\n  $p.getFirings().add(\"R1\");\n  $p.appendDescription($s);\n  update($p);\nend\n";
        String drl2 = "import " + Product.class.getCanonicalName() + ";\nimport " + CategoryTypeEnum.class.getCanonicalName() + ";\nrule R2 when\n  $s : String( this == \"pair\" )\n  $p : Product( id != \"test\", categoryAsEnum == CategoryTypeEnum.PAIR, firings not contains \"R2\" )\nthen\n  $p.getFirings().add(\"R2\");\n  $p.appendDescription($s);\n  update($p);end\n";
        this.parallelTest(NUMBER_OF_REPETITIONS, NUMBER_OF_THREADS, (kieSession, counter) -> {
            int i;
            Product[] products = new Product[10];
            boolean pair = counter % 2 == 0;
            String pairString = pair ? "pair" : "odd";
            for (i = 0; i < 10; ++i) {
                products[i] = new Product("" + i, pairString);
            }
            kieSession.insert((Object)pairString);
            for (i = 0; i < 10; ++i) {
                kieSession.insert((Object)products[i]);
            }
            kieSession.fireAllRules();
            for (i = 0; i < 10; ++i) {
                if (products[i].getCategory().equals(pairString) && !products[i].getCategory().equals(products[i].getDescription())) {
                    return false;
                }
                if (products[i].getCategory().equals(pairString) || products[i].getDescription().isEmpty()) continue;
                return false;
            }
            return true;
        }, null, null, drl1, drl2);
    }
}

