/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.integrationtests.concurrency;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.drools.mvel.integrationtests.concurrency.AbstractConcurrentTest;
import org.drools.mvel.integrationtests.facts.AnEnum;
import org.drools.mvel.integrationtests.facts.ChildFact1;
import org.drools.mvel.integrationtests.facts.ChildFact2;
import org.drools.mvel.integrationtests.facts.ChildFact3WithEnum;
import org.drools.mvel.integrationtests.facts.ChildFact4WithFirings;
import org.drools.mvel.integrationtests.facts.RootFact;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class JoinsConcurrentSessionsTest
extends AbstractConcurrentTest {
    private static final Integer NUMBER_OF_THREADS = 10;
    private static final Integer NUMBER_OF_REPETITIONS = 1;

    @Parameterized.Parameters(name="Enforced jitting={0}, Serialize KieBase={1}, Share KieBase={2}")
    public static List<Boolean[]> getTestParameters() {
        return Arrays.asList({false, false, false}, {false, true, false}, {true, false, false}, {true, true, false}, {false, false, true}, {false, true, true}, {true, false, true}, {true, true, true});
    }

    public JoinsConcurrentSessionsTest(boolean enforcedJitting, boolean serializeKieBase, boolean sharedKieBase) {
        super(enforcedJitting, serializeKieBase, sharedKieBase, false);
    }

    @Test(timeout=20000L)
    public void test5() throws InterruptedException {
        String drlTemplate = " import org.drools.mvel.integrationtests.facts.*;\n rule \"${ruleName}\"\n dialect \"java\"\n when\n     $rootFact : RootFact( )\n     $childFact1 : ChildFact1( parentId == $rootFact.id )\n     $childFact2 : ChildFact2( parentId == $childFact1.id )\n     $childFact3 : ChildFact3WithEnum( \n         parentId == $childFact2.id, \n         enumValue == ${enumValue}, \n         $enumValue : enumValue )\n     $childFact4 : ChildFact4WithFirings( \n         parentId == $childFact1.id, \n         $evaluationName : evaluationName, \n         firings not contains \"${ruleName}\" )\n then\n     $childFact4.setEvaluationName(String.valueOf($enumValue));\n     $childFact4.getFirings().add(\"${ruleName}\");\n     update($childFact4);\n end\n";
        String drl1 = " import org.drools.mvel.integrationtests.facts.*;\n rule \"${ruleName}\"\n dialect \"java\"\n when\n     $rootFact : RootFact( )\n     $childFact1 : ChildFact1( parentId == $rootFact.id )\n     $childFact2 : ChildFact2( parentId == $childFact1.id )\n     $childFact3 : ChildFact3WithEnum( \n         parentId == $childFact2.id, \n         enumValue == ${enumValue}, \n         $enumValue : enumValue )\n     $childFact4 : ChildFact4WithFirings( \n         parentId == $childFact1.id, \n         $evaluationName : evaluationName, \n         firings not contains \"${ruleName}\" )\n then\n     $childFact4.setEvaluationName(String.valueOf($enumValue));\n     $childFact4.getFirings().add(\"${ruleName}\");\n     update($childFact4);\n end\n".replace("${ruleName}", "R1").replace("${enumValue}", "AnEnum.FIRST");
        String drl2 = " import org.drools.mvel.integrationtests.facts.*;\n rule \"${ruleName}\"\n dialect \"java\"\n when\n     $rootFact : RootFact( )\n     $childFact1 : ChildFact1( parentId == $rootFact.id )\n     $childFact2 : ChildFact2( parentId == $childFact1.id )\n     $childFact3 : ChildFact3WithEnum( \n         parentId == $childFact2.id, \n         enumValue == ${enumValue}, \n         $enumValue : enumValue )\n     $childFact4 : ChildFact4WithFirings( \n         parentId == $childFact1.id, \n         $evaluationName : evaluationName, \n         firings not contains \"${ruleName}\" )\n then\n     $childFact4.setEvaluationName(String.valueOf($enumValue));\n     $childFact4.getFirings().add(\"${ruleName}\");\n     update($childFact4);\n end\n".replace("${ruleName}", "R2").replace("${enumValue}", "AnEnum.SECOND");
        this.parallelTest(NUMBER_OF_REPETITIONS, NUMBER_OF_THREADS, (kieSession, counter) -> {
            List<Object> facts = this.getFacts();
            for (Object fact : facts) {
                kieSession.insert(fact);
            }
            kieSession.fireAllRules();
            for (Object fact : facts) {
                if (!(fact instanceof ChildFact4WithFirings)) continue;
                ChildFact4WithFirings childFact4 = (ChildFact4WithFirings)fact;
                if (childFact4.getFirings().size() != 1) {
                    return false;
                }
                if (childFact4.getFirings().get(0).equals("R1") && !childFact4.getEvaluationName().equals(String.valueOf((Object)AnEnum.FIRST))) {
                    return false;
                }
                if (!childFact4.getFirings().get(0).equals("R2") || childFact4.getEvaluationName().equals(String.valueOf((Object)AnEnum.SECOND))) continue;
                return false;
            }
            return true;
        }, null, null, drl1, drl2);
    }

    private List<Object> getFacts() {
        int initialId = 1;
        RootFact rootFact = new RootFact(initialId);
        ChildFact1 childFact1First = new ChildFact1(initialId + 1, rootFact.getId());
        ChildFact2 childFact2First = new ChildFact2(initialId + 3, childFact1First.getId());
        ChildFact3WithEnum childFact3First = new ChildFact3WithEnum(initialId + 4, childFact2First.getId(), AnEnum.FIRST);
        ChildFact4WithFirings childFact4First = new ChildFact4WithFirings(initialId + 2, childFact1First.getId());
        initialId = 6;
        ChildFact1 childFact1Second = new ChildFact1(initialId, rootFact.getId());
        ChildFact2 childFact2Second = new ChildFact2(initialId + 2, childFact1Second.getId());
        ChildFact3WithEnum childFact3Second = new ChildFact3WithEnum(initialId + 3, childFact2Second.getId(), AnEnum.SECOND);
        ChildFact4WithFirings childFact4Second = new ChildFact4WithFirings(initialId + 1, childFact1Second.getId());
        ArrayList<Object> facts = new ArrayList<Object>();
        facts.add(rootFact);
        facts.add(childFact1First);
        facts.add(childFact4First);
        facts.add(childFact2First);
        facts.add(childFact3First);
        facts.add(childFact1Second);
        facts.add(childFact4Second);
        facts.add(childFact2Second);
        facts.add(childFact3Second);
        return facts;
    }
}

