/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.integrationtests.concurrency;

import java.util.Arrays;
import java.util.List;
import org.drools.mvel.integrationtests.concurrency.AbstractConcurrentTest;
import org.drools.mvel.integrationtests.facts.Product;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class SubnetworkConcurrentSessionsTest
extends AbstractConcurrentTest {
    private static final Integer NUMBER_OF_THREADS = 10;
    private static final Integer NUMBER_OF_REPETITIONS = 1;

    @Parameterized.Parameters(name="Enforced jitting={0}, Serialize KieBase={1}, Share KieBase={2}")
    public static List<Boolean[]> getTestParameters() {
        return Arrays.asList({false, false, false}, {false, true, false}, {true, false, false}, {true, true, false}, {false, false, true}, {false, true, true}, {true, false, true}, {true, true, true});
    }

    public SubnetworkConcurrentSessionsTest(boolean enforcedJitting, boolean serializeKieBase, boolean sharedKieBase) {
        super(enforcedJitting, serializeKieBase, sharedKieBase, false);
    }

    @Test(timeout=40000L)
    public void test1() throws InterruptedException {
        String drl = "rule R when String() then end";
        this.parallelTest(NUMBER_OF_REPETITIONS, NUMBER_OF_THREADS, (kieSession, counter) -> {
            kieSession.insert((Object)"test");
            return kieSession.fireAllRules() == 1;
        }, null, null, "rule R when String() then end");
    }

    @Test(timeout=40000L)
    public void test2NoSubnetwork() throws InterruptedException {
        this.test2(this.getRule("R1", "this == \"odd\"", false, false, "Number( intValue > 0 )"), this.getRule("R2", "this == \"pair\"", false, false, "Number( intValue < 10000 )"));
    }

    @Test(timeout=40000L)
    public void test2WithSubnetwork() throws InterruptedException {
        this.test2(this.getRule("R1", "this == \"odd\"", false, true, "Number( intValue > 0 )"), this.getRule("R2", "this == \"pair\"", false, true, "Number( intValue < 10000 )"));
    }

    private void test2(String ... drls) throws InterruptedException {
        this.parallelTest(NUMBER_OF_REPETITIONS, NUMBER_OF_THREADS, (kieSession, counter) -> {
            int i;
            Product[] products = new Product[10];
            for (i = 0; i < 10; ++i) {
                products[i] = new Product("" + i, i % 2 == 0 ? "pair" : "odd");
            }
            kieSession.insert((Object)"odd");
            kieSession.insert((Object)"pair");
            for (i = 0; i < 10; ++i) {
                kieSession.insert((Object)products[i]);
            }
            kieSession.fireAllRules();
            for (i = 0; i < 10; ++i) {
                if (products[i].getCategory().equals(products[i].getDescription())) continue;
                return false;
            }
            return true;
        }, null, null, drls);
    }

    @Test(timeout=40000L)
    public void test3NoSubnetwork() throws InterruptedException {
        this.test3(this.getRule("R1", "this == \"odd\"", false, false, "Number( intValue > 0 )"), this.getRule("R2", "this == \"pair\"", false, false, "Number( intValue < 10000 )"));
    }

    @Test(timeout=40000L)
    public void test3WithSubnetwork() throws InterruptedException {
        this.test3(this.getRule("R1", "this == \"odd\"", false, true, "Number( intValue > 0 )"), this.getRule("R2", "this == \"pair\"", false, true, "Number( intValue < 10000 )"));
    }

    @Test(timeout=40000L)
    public void test3WithSharedSubnetwork() throws InterruptedException {
        String ruleTemplate = "import " + Product.class.getCanonicalName() + ";\nrule ${ruleName} when\n  $s : String()\n  $p : Product( category == $s )\n  $n : Number(intValue > 0) from accumulate (\n    $s_1 : String( this == $s ) and\n    $p_1 : Product( category == $s_1 )\n    ;count($p_1))\n  Product(this == $p, category == \"${category}\", firings not contains \"${ruleName}\")\nthen\n  $p.getFirings().add(\"${ruleName}\");\n  $p.appendDescription($s);\n  update($p);\nend\n";
        String drl1 = ruleTemplate.replace("${ruleName}", "R1").replace("${category}", "odd");
        String drl2 = ruleTemplate.replace("${ruleName}", "R2").replace("${category}", "pair");
        this.test3(drl1, drl2);
    }

    private void test3(String ... drls) throws InterruptedException {
        this.parallelTest(NUMBER_OF_REPETITIONS, NUMBER_OF_THREADS, (kieSession, counter) -> {
            int i;
            Product[] products = new Product[10];
            for (i = 0; i < 10; ++i) {
                products[i] = new Product("" + i, i % 2 == 0 ? "pair" : "odd");
            }
            for (i = 0; i < 10; ++i) {
                kieSession.insert((Object)products[i]);
            }
            kieSession.fireAllRules();
            boolean pair = counter % 2 == 0;
            kieSession.insert((Object)(pair ? "pair" : "odd"));
            kieSession.fireAllRules();
            for (int i2 = 0; i2 < 10; ++i2) {
                if (pair) {
                    if (products[i2].getCategory().equals("pair") && !products[i2].getDescription().equals("pair")) {
                        return false;
                    }
                    if (products[i2].getCategory().equals("odd") && !products[i2].getDescription().equals("")) {
                        return false;
                    }
                }
                if (pair) continue;
                if (products[i2].getCategory().equals("pair") && !products[i2].getDescription().equals("")) {
                    return false;
                }
                if (!products[i2].getCategory().equals("odd") || products[i2].getDescription().equals("odd")) continue;
                return false;
            }
            return true;
        }, null, null, drls);
    }

    @Test(timeout=10000L)
    public void test4NoSharing() throws InterruptedException {
        this.test4(this.getRule("R1", "", false, true, "Number( intValue > 5 )"), this.getRule("R2", "", false, true, "Number( intValue < 5 )"));
    }

    @Test(timeout=10000L)
    public void test4WithSharing() throws InterruptedException {
        this.test4(this.getRule("R1", "", true, true, "Number( intValue > 5 )"), this.getRule("R2", "", true, true, "Number( intValue < 5 )"));
    }

    private void test4(String ... drls) throws InterruptedException {
        this.parallelTest(NUMBER_OF_REPETITIONS, NUMBER_OF_THREADS, (kieSession, counter) -> {
            int i;
            Product[] products = new Product[10];
            for (i = 0; i < 10; ++i) {
                products[i] = new Product("" + i, i % 3 == 0 ? "few" : "many");
            }
            kieSession.insert((Object)"few");
            kieSession.insert((Object)"many");
            for (i = 0; i < 10; ++i) {
                kieSession.insert((Object)products[i]);
            }
            kieSession.fireAllRules();
            for (i = 0; i < 10; ++i) {
                if (products[i].getCategory().equals(products[i].getDescription())) continue;
                return false;
            }
            return true;
        }, null, null, drls);
    }

    private String getRule(String ruleName, String stringFactCondition, boolean withSharing, boolean withSubnetwork, String accumulateResultFilter) {
        String sharingCondition = withSharing ? "" : ", firings not contains \"" + ruleName + "\"";
        String accumulateWithSubnetwork = withSubnetwork ? "  $n : " + accumulateResultFilter + " from accumulate (\n    $s_1 : String( this == $s ) and\n    $p_1 : Product( category == $s_1 )\n    ;count($p_1))\n" : "";
        return "import " + Product.class.getCanonicalName() + ";\nrule " + ruleName + " no-loop when\n  $s : String(" + stringFactCondition + ")\n  $p : Product( category == $s " + sharingCondition + ")\n" + accumulateWithSubnetwork + "then\n  $p.getFirings().add(\"" + ruleName + "\");\n  $p.appendDescription($s);\n  update($p);\nend\n";
    }
}

