/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.integrationtests.session;

import java.util.ArrayList;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.drools.mvel.CommonTestMethodBase;
import org.drools.mvel.compiler.Cheese;
import org.drools.mvel.compiler.Person;
import org.drools.mvel.integrationtests.SerializationHelper;
import org.drools.mvel.integrationtests.facts.ClassA;
import org.drools.mvel.integrationtests.facts.ClassB;
import org.drools.mvel.integrationtests.facts.InterfaceA;
import org.drools.mvel.integrationtests.facts.InterfaceB;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kie.api.KieBase;
import org.kie.api.KieServices;
import org.kie.api.builder.KieBuilder;
import org.kie.api.builder.KieFileSystem;
import org.kie.api.builder.Message;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.rule.FactHandle;
import org.kie.api.runtime.rule.QueryResults;
import org.kie.api.runtime.rule.QueryResultsRow;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeleteTest
extends CommonTestMethodBase {
    private static Logger logger = LoggerFactory.getLogger(DeleteTest.class);
    private static final String DELETE_TEST_DRL = "org/drools/mvel/integrationtests/session/delete_test.drl";
    private KieSession ksession;

    @Before
    public void setUp() {
        KieFileSystem kfs = KieServices.Factory.get().newKieFileSystem();
        kfs.write(KieServices.Factory.get().getResources().newClassPathResource(DELETE_TEST_DRL, DeleteTest.class));
        KieBuilder kbuilder = KieServices.Factory.get().newKieBuilder(kfs);
        kbuilder.buildAll();
        List res = kbuilder.getResults().getMessages(new Message.Level[]{Message.Level.ERROR});
        Assertions.assertThat((List)res).isEmpty();
        KieBase kbase = KieServices.Factory.get().newKieContainer(kbuilder.getKieModule().getReleaseId()).getKieBase();
        this.ksession = kbase.newKieSession();
    }

    @After
    public void tearDown() {
        this.ksession.dispose();
    }

    @Test
    public void deleteFactTest() {
        this.ksession.insert((Object)new org.drools.core.test.model.Person("Petr", 25));
        FactHandle george = this.ksession.insert((Object)new org.drools.core.test.model.Person("George", 19));
        QueryResults results = this.ksession.getQueryResults("informationAboutPersons", new Object[0]);
        Assertions.assertThat((Iterable)results).isNotEmpty();
        Assertions.assertThat((Object)((QueryResultsRow)results.iterator().next()).get("$countOfPerson")).isEqualTo((Object)2L);
        this.ksession.delete(george);
        results = this.ksession.getQueryResults("informationAboutPersons", new Object[0]);
        Assertions.assertThat((Iterable)results).isNotEmpty();
        Assertions.assertThat((Object)((QueryResultsRow)results.iterator().next()).get("$countOfPerson")).isEqualTo((Object)1L);
    }

    @Test
    public void deleteFactTwiceTest() {
        FactHandle george = this.ksession.insert((Object)new org.drools.core.test.model.Person("George", 19));
        QueryResults results = this.ksession.getQueryResults("countPerson", new Object[0]);
        Assertions.assertThat((Iterable)results).isNotEmpty();
        Assertions.assertThat((Object)((QueryResultsRow)results.iterator().next()).get("$personCount")).isEqualTo((Object)1L);
        this.ksession.delete(george);
        results = this.ksession.getQueryResults("countPerson", new Object[0]);
        Assertions.assertThat((Iterable)results).isNotEmpty();
        Assertions.assertThat((Object)((QueryResultsRow)results.iterator().next()).get("$personCount")).isEqualTo((Object)0L);
        this.ksession.delete(george);
        Assertions.assertThat((Iterable)results).isNotEmpty();
        Assertions.assertThat((Object)((QueryResultsRow)results.iterator().next()).get("$personCount")).isEqualTo((Object)0L);
    }

    @Test(expected=IllegalArgumentException.class)
    public void deleteNullFactTest() {
        this.ksession.delete(null);
    }

    @Test
    public void deleteUpdatedFactTest() {
        FactHandle person = this.ksession.insert((Object)new org.drools.core.test.model.Person("George", 18));
        this.ksession.update(person, (Object)new org.drools.core.test.model.Person("John", 21));
        QueryResults results = this.ksession.getQueryResults("countPerson", new Object[0]);
        Assertions.assertThat((Iterable)results).isNotEmpty();
        Assertions.assertThat((Object)((QueryResultsRow)results.iterator().next()).get("$personCount")).isEqualTo((Object)1L);
        this.ksession.delete(person);
        results = this.ksession.getQueryResults("countPerson", new Object[0]);
        Assertions.assertThat((Iterable)results).isNotEmpty();
        Assertions.assertThat((Object)((QueryResultsRow)results.iterator().next()).get("$personCount")).isEqualTo((Object)0L);
    }

    @Test
    public void deleteUpdatedFactDifferentClassTest() {
        FactHandle fact = this.ksession.insert((Object)new org.drools.core.test.model.Person("George", 18));
        Assertions.assertThat((Iterable)this.ksession.getObjects()).hasSize(1);
        Assertions.assertThat(this.ksession.getObjects().iterator().next()).isInstanceOf(org.drools.core.test.model.Person.class);
        this.ksession.update(fact, (Object)new org.drools.core.test.model.Cheese("Cheddar", 50));
        Assertions.assertThat((Iterable)this.ksession.getObjects()).hasSize(1);
        Assertions.assertThat(this.ksession.getObjects().iterator().next()).isInstanceOf(org.drools.core.test.model.Cheese.class);
        this.ksession.delete(fact);
        Assertions.assertThat((Iterable)this.ksession.getObjects()).isEmpty();
    }

    @Test
    public void testRetractLeftTuple() throws Exception {
        String str = "import " + ClassA.class.getCanonicalName() + ";\nimport " + ClassB.class.getCanonicalName() + ";\nimport " + InterfaceA.class.getCanonicalName() + ";\nimport " + InterfaceB.class.getCanonicalName() + ";\nrule R1 salience 3\nwhen\n   $b : InterfaceB( )\n   $a : ClassA( b == null )\nthen\n   $a.setB( $b );\n   update( $a );\nend\nrule R2 salience 2\nwhen\n   $b : ClassB( id == \"123\" )\n   $a : ClassA( b != null && b.id == $b.id )\nthen\n   $b.setId( \"456\" );\n   update( $b );\nend\nrule R3 salience 1\nwhen\n   InterfaceA( $b : b )\nthen\n   delete( $b );\nend\n";
        KieBase kbase = this.loadKnowledgeBaseFromString(str);
        KieSession ksession = kbase.newKieSession();
        ksession.insert((Object)new ClassA());
        ksession.insert((Object)new ClassB());
        Assert.assertEquals((long)3L, (long)ksession.fireAllRules());
    }

    @Test
    public void testAssertRetract() throws Exception {
        KieBase kbase = this.loadKnowledgeBase("assert_retract.drl");
        KieSession ksession = kbase.newKieSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        Person person = new Person("michael", "cheese");
        person.setStatus("start");
        ksession.insert((Object)person);
        ksession.fireAllRules();
        List results = (List)ksession.getGlobal("list");
        for (String result : results) {
            logger.info(result);
        }
        Assert.assertEquals((long)5L, (long)results.size());
        Assert.assertTrue((boolean)results.contains("first"));
        Assert.assertTrue((boolean)results.contains("second"));
        Assert.assertTrue((boolean)results.contains("third"));
        Assert.assertTrue((boolean)results.contains("fourth"));
        Assert.assertTrue((boolean)results.contains("fifth"));
    }

    @Test
    public void testEmptyAfterRetractInIndexedMemory() {
        String str = "";
        str = str + "package org.simple \n";
        str = str + "import org.drools.mvel.compiler.Person\n";
        str = str + "global java.util.List list \n";
        str = str + "rule xxx dialect 'mvel' \n";
        str = str + "when \n";
        str = str + "  Person( $name : name ) \n";
        str = str + "  $s : String( this == $name) \n";
        str = str + "then \n";
        str = str + "  list.add($s); \n";
        str = str + "end  \n";
        KieBase kbase = this.loadKnowledgeBaseFromString(str);
        KieSession ksession = this.createKnowledgeSession(kbase);
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        Person p = new Person("ackbar");
        ksession.insert((Object)p);
        ksession.insert((Object)"ackbar");
        ksession.fireAllRules();
        ksession.dispose();
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertEquals((Object)"ackbar", list.get(0));
    }

    @Test
    public void testModifyRetractAndModifyInsert() throws Exception {
        KieBase kbase = SerializationHelper.serializeObject(this.loadKnowledgeBase("test_ModifyRetractInsert.drl"));
        KieSession ksession = this.createKnowledgeSession(kbase);
        ArrayList list = new ArrayList();
        ksession.setGlobal("results", list);
        Person bob = new Person("Bob");
        bob.setStatus("hungry");
        ksession.insert((Object)bob);
        ksession.insert((Object)new Cheese());
        ksession.insert((Object)new Cheese());
        ksession.fireAllRules(2);
        Assert.assertEquals((String)"should have fired only once", (long)1L, (long)list.size());
    }

    @Test
    public void testModifyRetractWithFunction() throws Exception {
        KieBase kbase = SerializationHelper.serializeObject(this.loadKnowledgeBase("test_RetractModifyWithFunction.drl"));
        KieSession ksession = this.createKnowledgeSession(kbase);
        Cheese stilton = new Cheese("stilton", 7);
        Cheese muzzarella = new Cheese("muzzarella", 9);
        int sum = stilton.getPrice() + muzzarella.getPrice();
        FactHandle stiltonHandle = ksession.insert((Object)stilton);
        FactHandle muzzarellaHandle = ksession.insert((Object)muzzarella);
        ksession.fireAllRules();
        Assert.assertEquals((long)sum, (long)stilton.getPrice());
        Assert.assertEquals((long)1L, (long)ksession.getFactCount());
        Assert.assertNotNull((Object)ksession.getObject(stiltonHandle));
        Assert.assertNotNull((Object)ksession.getFactHandle((Object)stilton));
        Assert.assertNull((Object)ksession.getObject(muzzarellaHandle));
        Assert.assertNull((Object)ksession.getFactHandle((Object)muzzarella));
    }
}

