/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.integrationtests.session;

import java.util.ArrayList;
import org.drools.mvel.CommonTestMethodBase;
import org.drools.mvel.compiler.Move;
import org.drools.mvel.compiler.Person;
import org.drools.mvel.compiler.PersonFinal;
import org.drools.mvel.compiler.Pet;
import org.drools.mvel.compiler.Win;
import org.drools.mvel.integrationtests.SerializationHelper;
import org.junit.Assert;
import org.junit.Test;
import org.kie.api.KieBase;
import org.kie.api.runtime.KieSession;

public class InsertTest
extends CommonTestMethodBase {
    @Test
    public void testInsert() throws Exception {
        String drl = "";
        drl = drl + "package test\n";
        drl = drl + "import org.drools.mvel.compiler.Person\n";
        drl = drl + "import org.drools.mvel.compiler.Pet\n";
        drl = drl + "import java.util.ArrayList\n";
        drl = drl + "global java.util.List list\n";
        drl = drl + "rule test\n";
        drl = drl + "when\n";
        drl = drl + "$person:Person()\n";
        drl = drl + "$pets : ArrayList()\n";
        drl = drl + "   from collect( \n";
        drl = drl + "      Pet(\n";
        drl = drl + "         ownerName == $person.name\n";
        drl = drl + "      )\n";
        drl = drl + "   )\n";
        drl = drl + "then\n";
        drl = drl + "  list.add( $person );\n";
        drl = drl + "end\n";
        KieBase kbase = this.loadKnowledgeBaseFromString(drl);
        KieSession ksession = this.createKnowledgeSession(kbase);
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        Person p = new Person("Toni");
        ksession.insert((Object)p);
        ksession.insert((Object)new Pet("Toni"));
        ksession.fireAllRules();
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertSame((Object)p, list.get(0));
    }

    @Test
    public void testInsertionOrder() {
        KieBase kbase = this.loadKnowledgeBase("test_InsertionOrder.drl");
        KieSession ksession = this.createKnowledgeSession(kbase);
        ArrayList results = new ArrayList();
        ksession.setGlobal("results", results);
        ksession.insert((Object)new Move(1, 2));
        ksession.insert((Object)new Move(2, 3));
        Win win2 = new Win(2);
        Win win3 = new Win(3);
        ksession.fireAllRules();
        Assert.assertEquals((long)2L, (long)results.size());
        Assert.assertTrue((boolean)results.contains(win2));
        Assert.assertTrue((boolean)results.contains(win3));
        ksession.dispose();
        ksession = this.createKnowledgeSession(kbase);
        results = new ArrayList();
        ksession.setGlobal("results", results);
        ksession.insert((Object)new Move(2, 3));
        ksession.insert((Object)new Move(1, 2));
        ksession.fireAllRules();
        Assert.assertEquals((long)2L, (long)results.size());
        Assert.assertTrue((boolean)results.contains(win2));
        Assert.assertTrue((boolean)results.contains(win3));
    }

    @Test
    public void testInsertFinalClassInstance() throws Exception {
        KieBase kbase = SerializationHelper.serializeObject(this.loadKnowledgeBase("test_FinalClass.drl"));
        KieSession ksession = this.createKnowledgeSession(kbase);
        ArrayList list = new ArrayList();
        ksession.setGlobal("results", list);
        PersonFinal bob = new PersonFinal();
        bob.setName("bob");
        bob.setStatus(null);
        ksession.insert((Object)bob);
        ksession.fireAllRules();
        Assert.assertEquals((long)1L, (long)list.size());
    }
}

