/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.integrationtests.session;

import org.drools.mvel.CommonTestMethodBase;
import org.drools.mvel.compiler.Cheese;
import org.drools.mvel.integrationtests.SerializationHelper;
import org.junit.Assert;
import org.junit.Test;
import org.kie.api.KieBase;
import org.kie.api.event.rule.ObjectDeletedEvent;
import org.kie.api.event.rule.ObjectInsertedEvent;
import org.kie.api.event.rule.ObjectUpdatedEvent;
import org.kie.api.event.rule.RuleRuntimeEventListener;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.rule.FactHandle;
import org.mockito.ArgumentCaptor;
import org.mockito.Mockito;

public class RuleRuntimeEventTest
extends CommonTestMethodBase {
    @Test
    public void testEventModel() throws Exception {
        KieBase kbase = SerializationHelper.serializeObject(this.loadKnowledgeBase("test_EventModel.drl"));
        KieSession wm = this.createKnowledgeSession(kbase);
        RuleRuntimeEventListener wmel = (RuleRuntimeEventListener)Mockito.mock(RuleRuntimeEventListener.class);
        wm.addEventListener(wmel);
        Cheese stilton = new Cheese("stilton", 15);
        FactHandle stiltonHandle = wm.insert((Object)stilton);
        ArgumentCaptor oic = ArgumentCaptor.forClass(ObjectInsertedEvent.class);
        ((RuleRuntimeEventListener)Mockito.verify((Object)wmel)).objectInserted((ObjectInsertedEvent)oic.capture());
        Assert.assertSame((Object)stiltonHandle, (Object)((ObjectInsertedEvent)oic.getValue()).getFactHandle());
        wm.update(stiltonHandle, (Object)stilton);
        ArgumentCaptor ouc = ArgumentCaptor.forClass(ObjectUpdatedEvent.class);
        ((RuleRuntimeEventListener)Mockito.verify((Object)wmel)).objectUpdated((ObjectUpdatedEvent)ouc.capture());
        Assert.assertSame((Object)stiltonHandle, (Object)((ObjectUpdatedEvent)ouc.getValue()).getFactHandle());
        wm.delete(stiltonHandle);
        ArgumentCaptor orc = ArgumentCaptor.forClass(ObjectDeletedEvent.class);
        ((RuleRuntimeEventListener)Mockito.verify((Object)wmel)).objectDeleted((ObjectDeletedEvent)orc.capture());
        Assert.assertSame((Object)stiltonHandle, (Object)((ObjectDeletedEvent)orc.getValue()).getFactHandle());
    }
}

