/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import org.drools.core.RuleBaseConfiguration;
import org.drools.core.WorkingMemoryEntryPoint;
import org.drools.core.base.ClassFieldAccessorCache;
import org.drools.core.base.ClassFieldAccessorStore;
import org.drools.core.base.ClassFieldReader;
import org.drools.core.base.ValueType;
import org.drools.core.base.field.LongFieldImpl;
import org.drools.core.base.field.ObjectFieldImpl;
import org.drools.core.common.DisconnectedWorkingMemoryEntryPoint;
import org.drools.core.common.EmptyBetaConstraints;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.common.Memory;
import org.drools.core.definitions.rule.impl.RuleImpl;
import org.drools.core.impl.InternalKnowledgeBase;
import org.drools.core.impl.KnowledgeBaseFactory;
import org.drools.core.reteoo.AlphaNode;
import org.drools.core.reteoo.BetaNode;
import org.drools.core.reteoo.CompositeObjectSinkAdapter;
import org.drools.core.reteoo.LeftTuple;
import org.drools.core.reteoo.LeftTupleImpl;
import org.drools.core.reteoo.LeftTupleSource;
import org.drools.core.reteoo.ModifyPreviousTuples;
import org.drools.core.reteoo.ObjectSink;
import org.drools.core.reteoo.ObjectSource;
import org.drools.core.reteoo.ReteooBuilder;
import org.drools.core.reteoo.ReteooFactHandleFactory;
import org.drools.core.reteoo.RightTuple;
import org.drools.core.reteoo.RuleRemovalContext;
import org.drools.core.reteoo.Sink;
import org.drools.core.reteoo.builder.BuildContext;
import org.drools.core.rule.PredicateConstraint;
import org.drools.core.spi.AlphaNodeFieldConstraint;
import org.drools.core.spi.FieldValue;
import org.drools.core.spi.InternalReadAccessor;
import org.drools.core.spi.PropagationContext;
import org.drools.mvel.MVELConstraintTestUtil;
import org.drools.mvel.model.Cheese;
import org.drools.mvel.model.MockObjectSource;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class CompositeObjectSinkAdapterTest {
    private InternalKnowledgeBase kBase;
    private BuildContext buildContext;
    ClassFieldAccessorStore store = new ClassFieldAccessorStore();
    public int la;
    public int blah;

    @Before
    public void setUp() throws Exception {
        this.store.setClassFieldAccessorCache(new ClassFieldAccessorCache(Thread.currentThread().getContextClassLoader()));
        this.store.setEagerWire(true);
        this.kBase = KnowledgeBaseFactory.newKnowledgeBase();
        this.buildContext = new BuildContext(this.kBase);
        this.buildContext.setRule(new RuleImpl("test"));
    }

    @Test
    public void testBeta() {
        CompositeObjectSinkAdapter ad = new CompositeObjectSinkAdapter();
        MockBetaNode beta = new MockBetaNode(this.buildContext.getNextId(), (LeftTupleSource)new MockBetaNode(), new MockObjectSource(), this.buildContext);
        ad.addObjectSink((ObjectSink)beta);
        Assert.assertEquals((long)1L, (long)ad.getSinks().length);
        Assert.assertEquals((Object)((Object)beta), (Object)ad.getSinks()[0]);
        Assert.assertEquals((long)1L, (long)ad.getOtherSinks().size());
        Assert.assertEquals((Object)((Object)beta), (Object)ad.getOtherSinks().getFirst());
        Assert.assertNull((Object)ad.getHashableSinks());
        Assert.assertNull((Object)ad.getHashedFieldIndexes());
        Assert.assertNull((Object)ad.getHashedSinkMap());
        ad.removeObjectSink((ObjectSink)beta);
        Assert.assertNull((Object)ad.getOtherSinks());
        Assert.assertEquals((long)0L, (long)ad.getSinks().length);
    }

    @Test
    public void testAlphaWithPredicate() {
        CompositeObjectSinkAdapter ad = new CompositeObjectSinkAdapter();
        AlphaNode al = new AlphaNode(this.buildContext.getNextId(), (AlphaNodeFieldConstraint)new PredicateConstraint(null, null), null, this.buildContext);
        ad.addObjectSink((ObjectSink)al);
        Assert.assertEquals((long)1L, (long)ad.getSinks().length);
        Assert.assertEquals((long)1L, (long)ad.getOtherSinks().size());
        Assert.assertEquals((Object)al, (Object)ad.getOtherSinks().getFirst());
        ad.removeObjectSink((ObjectSink)al);
        Assert.assertEquals((long)0L, (long)ad.getSinks().length);
        Assert.assertNull((Object)ad.getOtherSinks());
    }

    @Test
    public void testSingleAlpha() {
        CompositeObjectSinkAdapter ad = new CompositeObjectSinkAdapter();
        MVELConstraintTestUtil lit = new MVELConstraintTestUtil("type == \"stilton\"", (FieldValue)new ObjectFieldImpl((Object)"stilton"), (InternalReadAccessor)new MockExtractor());
        AlphaNode al = new AlphaNode(this.buildContext.getNextId(), (AlphaNodeFieldConstraint)lit, (ObjectSource)new MockObjectSource(0), this.buildContext);
        ad.addObjectSink((ObjectSink)al);
        Assert.assertNull((Object)ad.getOtherSinks());
        Assert.assertNotNull((Object)ad.getHashedFieldIndexes());
        Assert.assertEquals((long)1L, (long)ad.getHashableSinks().size());
        Assert.assertEquals((Object)al, (Object)ad.getSinks()[0]);
        ad.removeObjectSink((ObjectSink)al);
        Assert.assertNull((Object)ad.getOtherSinks());
        Assert.assertNull((Object)ad.getHashableSinks());
    }

    @Test
    public void testDoubleAlphaWithBeta() {
        CompositeObjectSinkAdapter ad = new CompositeObjectSinkAdapter();
        MVELConstraintTestUtil lit = new MVELConstraintTestUtil("type == \"stilton\"", (FieldValue)new ObjectFieldImpl((Object)"stilton"), (InternalReadAccessor)new MockExtractor());
        AlphaNode al = new AlphaNode(this.buildContext.getNextId(), (AlphaNodeFieldConstraint)lit, (ObjectSource)new MockObjectSource(0), this.buildContext);
        ad.addObjectSink((ObjectSink)al);
        Assert.assertNull((Object)ad.getOtherSinks());
        Assert.assertNotNull((Object)ad.getHashedFieldIndexes());
        Assert.assertEquals((long)1L, (long)ad.getHashableSinks().size());
        Assert.assertEquals((Object)al, (Object)ad.getSinks()[0]);
        MVELConstraintTestUtil lit2 = new MVELConstraintTestUtil("type == \"cheddar\"", (FieldValue)new ObjectFieldImpl((Object)"cheddar"), (InternalReadAccessor)new MockExtractor());
        AlphaNode al2 = new AlphaNode(this.buildContext.getNextId(), (AlphaNodeFieldConstraint)lit2, (ObjectSource)new MockObjectSource(this.buildContext.getNextId()), this.buildContext);
        ad.addObjectSink((ObjectSink)al2);
        Assert.assertNull((Object)ad.getOtherSinks());
        Assert.assertEquals((long)2L, (long)ad.getHashableSinks().size());
        Assert.assertEquals((Object)al, (Object)ad.getSinks()[0]);
        Assert.assertEquals((Object)al2, (Object)ad.getSinks()[1]);
        MockBetaNode beta = new MockBetaNode(this.buildContext.getNextId(), (LeftTupleSource)new MockBetaNode(), new MockObjectSource(), this.buildContext);
        ad.addObjectSink((ObjectSink)beta);
        Assert.assertNotNull((Object)ad.getOtherSinks());
        Assert.assertEquals((long)2L, (long)ad.getHashableSinks().size());
        Assert.assertEquals((long)1L, (long)ad.getOtherSinks().size());
        Assert.assertEquals((Object)((Object)beta), (Object)ad.getOtherSinks().getFirst());
        ad.removeObjectSink((ObjectSink)beta);
        Assert.assertNull((Object)ad.getOtherSinks());
        Assert.assertEquals((long)2L, (long)ad.getHashableSinks().size());
    }

    @Test
    public void testTripleAlpha() {
        CompositeObjectSinkAdapter ad = new CompositeObjectSinkAdapter();
        ClassFieldReader extractor = this.store.getReader(Cheese.class, "type");
        MVELConstraintTestUtil lit = new MVELConstraintTestUtil("type == \"stilton\"", (FieldValue)new ObjectFieldImpl((Object)"stilton"), (InternalReadAccessor)new MockExtractor());
        AlphaNode al = new AlphaNode(this.buildContext.getNextId(), (AlphaNodeFieldConstraint)lit, (ObjectSource)new MockObjectSource(this.buildContext.getNextId()), this.buildContext);
        ad.addObjectSink((ObjectSink)al);
        Assert.assertNull((Object)ad.getOtherSinks());
        Assert.assertNotNull((Object)ad.getHashedFieldIndexes());
        Assert.assertEquals((long)1L, (long)ad.getHashableSinks().size());
        Assert.assertEquals((Object)al, (Object)ad.getSinks()[0]);
        MVELConstraintTestUtil lit2 = new MVELConstraintTestUtil("type == \"cheddar\"", (FieldValue)new ObjectFieldImpl((Object)"cheddar"), (InternalReadAccessor)new MockExtractor());
        AlphaNode al2 = new AlphaNode(this.buildContext.getNextId(), (AlphaNodeFieldConstraint)lit2, (ObjectSource)new MockObjectSource(this.buildContext.getNextId()), this.buildContext);
        ad.addObjectSink((ObjectSink)al2);
        Assert.assertNull((Object)ad.getHashedSinkMap());
        Assert.assertEquals((long)2L, (long)ad.getHashableSinks().size());
        MVELConstraintTestUtil lit3 = new MVELConstraintTestUtil("type == \"stinky\"", (FieldValue)new ObjectFieldImpl((Object)"stinky"), (InternalReadAccessor)new MockExtractor());
        AlphaNode al3 = new AlphaNode(this.buildContext.getNextId(), (AlphaNodeFieldConstraint)lit3, (ObjectSource)new MockObjectSource(this.buildContext.getNextId()), this.buildContext);
        ad.addObjectSink((ObjectSink)al3);
        Assert.assertNotNull((Object)ad.getHashedSinkMap());
        Assert.assertNull((Object)ad.getHashableSinks());
        ad.removeObjectSink((ObjectSink)al2);
        Assert.assertNotNull((Object)ad.getHashableSinks());
        Assert.assertEquals((long)2L, (long)ad.getHashableSinks().size());
        Assert.assertNull((Object)ad.getHashedSinkMap());
    }

    @Test
    public void testTripleAlphaCharacterConstraint() {
        CompositeObjectSinkAdapter ad = new CompositeObjectSinkAdapter();
        ClassFieldReader extractor = this.store.getReader(Cheese.class, "charType");
        MVELConstraintTestUtil lit = new MVELConstraintTestUtil("charType == 65", (FieldValue)new LongFieldImpl(65L), (InternalReadAccessor)extractor);
        AlphaNode al = new AlphaNode(this.buildContext.getNextId(), (AlphaNodeFieldConstraint)lit, (ObjectSource)new MockObjectSource(this.buildContext.getNextId()), this.buildContext);
        ad.addObjectSink((ObjectSink)al);
        Assert.assertNull((Object)ad.getOtherSinks());
        Assert.assertNotNull((Object)ad.getHashedFieldIndexes());
        Assert.assertEquals((long)1L, (long)ad.getHashableSinks().size());
        Assert.assertEquals((Object)al, (Object)ad.getSinks()[0]);
        MVELConstraintTestUtil lit2 = new MVELConstraintTestUtil("charType == 66", (FieldValue)new LongFieldImpl(66L), (InternalReadAccessor)extractor);
        AlphaNode al2 = new AlphaNode(this.buildContext.getNextId(), (AlphaNodeFieldConstraint)lit2, (ObjectSource)new MockObjectSource(this.buildContext.getNextId()), this.buildContext);
        ad.addObjectSink((ObjectSink)al2);
        Assert.assertNull((Object)ad.getHashedSinkMap());
        Assert.assertEquals((long)2L, (long)ad.getHashableSinks().size());
        MVELConstraintTestUtil lit3 = new MVELConstraintTestUtil("charType == 67", (FieldValue)new LongFieldImpl(67L), (InternalReadAccessor)extractor);
        AlphaNode al3 = new AlphaNode(this.buildContext.getNextId(), (AlphaNodeFieldConstraint)lit3, (ObjectSource)new MockObjectSource(this.buildContext.getNextId()), this.buildContext);
        ad.addObjectSink((ObjectSink)al3);
        Assert.assertNotNull((Object)ad.getHashedSinkMap());
        Assert.assertNull((Object)ad.getHashableSinks());
        Cheese cheese = new Cheese();
        cheese.setCharType('B');
        CompositeObjectSinkAdapter.HashKey hashKey = new CompositeObjectSinkAdapter.HashKey();
        hashKey.setValue(extractor.getIndex(), (Object)cheese, (InternalReadAccessor)extractor);
        ObjectSink sink = (ObjectSink)ad.getHashedSinkMap().get((Object)hashKey);
        Assert.assertSame((Object)al2, (Object)sink);
        cheese.setCharType('X');
        hashKey.setValue(extractor.getIndex(), (Object)cheese, (InternalReadAccessor)extractor);
        sink = (ObjectSink)ad.getHashedSinkMap().get((Object)hashKey);
        Assert.assertNull((Object)sink);
        ad.removeObjectSink((ObjectSink)al2);
        Assert.assertNotNull((Object)ad.getHashableSinks());
        Assert.assertEquals((long)2L, (long)ad.getHashableSinks().size());
        Assert.assertNull((Object)ad.getHashedSinkMap());
    }

    @Test
    public void testTripleAlphaObjectCharacterConstraint() {
        CompositeObjectSinkAdapter ad = new CompositeObjectSinkAdapter();
        ClassFieldReader extractor = this.store.getReader(Cheese.class, "charObjectType");
        MVELConstraintTestUtil lit = new MVELConstraintTestUtil("charObjectType == 65", (FieldValue)new LongFieldImpl(65L), (InternalReadAccessor)extractor);
        AlphaNode al = new AlphaNode(this.buildContext.getNextId(), (AlphaNodeFieldConstraint)lit, (ObjectSource)new MockObjectSource(this.buildContext.getNextId()), this.buildContext);
        ad.addObjectSink((ObjectSink)al);
        Assert.assertNull((Object)ad.getOtherSinks());
        Assert.assertNotNull((Object)ad.getHashedFieldIndexes());
        Assert.assertEquals((long)1L, (long)ad.getHashableSinks().size());
        Assert.assertEquals((Object)al, (Object)ad.getSinks()[0]);
        MVELConstraintTestUtil lit2 = new MVELConstraintTestUtil("charObjectType == 66", (FieldValue)new LongFieldImpl(66L), (InternalReadAccessor)extractor);
        AlphaNode al2 = new AlphaNode(this.buildContext.getNextId(), (AlphaNodeFieldConstraint)lit2, (ObjectSource)new MockObjectSource(this.buildContext.getNextId()), this.buildContext);
        ad.addObjectSink((ObjectSink)al2);
        Assert.assertNull((Object)ad.getHashedSinkMap());
        Assert.assertEquals((long)2L, (long)ad.getHashableSinks().size());
        MVELConstraintTestUtil lit3 = new MVELConstraintTestUtil("charObjectType == 67", (FieldValue)new LongFieldImpl(67L), (InternalReadAccessor)extractor);
        AlphaNode al3 = new AlphaNode(this.buildContext.getNextId(), (AlphaNodeFieldConstraint)lit3, (ObjectSource)new MockObjectSource(this.buildContext.getNextId()), this.buildContext);
        ad.addObjectSink((ObjectSink)al3);
        Assert.assertNotNull((Object)ad.getHashedSinkMap());
        Assert.assertNull((Object)ad.getHashableSinks());
        Cheese cheese = new Cheese();
        cheese.setCharObjectType(Character.valueOf('B'));
        CompositeObjectSinkAdapter.HashKey hashKey = new CompositeObjectSinkAdapter.HashKey();
        hashKey.setValue(extractor.getIndex(), (Object)cheese, (InternalReadAccessor)extractor);
        ObjectSink sink = (ObjectSink)ad.getHashedSinkMap().get((Object)hashKey);
        Assert.assertSame((Object)al2, (Object)sink);
        cheese.setCharObjectType(Character.valueOf('X'));
        hashKey.setValue(extractor.getIndex(), (Object)cheese, (InternalReadAccessor)extractor);
        sink = (ObjectSink)ad.getHashedSinkMap().get((Object)hashKey);
        Assert.assertNull((Object)sink);
        ad.removeObjectSink((ObjectSink)al2);
        Assert.assertNotNull((Object)ad.getHashableSinks());
        Assert.assertEquals((long)2L, (long)ad.getHashableSinks().size());
        Assert.assertNull((Object)ad.getHashedSinkMap());
    }

    @Test
    public void testPropagationWithNullValue() {
        CompositeObjectSinkAdapter ad = new CompositeObjectSinkAdapter();
        ClassFieldReader extractor = this.store.getReader(Cheese.class, "type");
        MVELConstraintTestUtil lit1 = new MVELConstraintTestUtil("type == \"stilton\"", (FieldValue)new ObjectFieldImpl((Object)"stilton"), (InternalReadAccessor)new MockExtractor());
        AlphaNode al1 = new AlphaNode(this.buildContext.getNextId(), (AlphaNodeFieldConstraint)lit1, (ObjectSource)new MockObjectSource(this.buildContext.getNextId()), this.buildContext);
        MVELConstraintTestUtil lit2 = new MVELConstraintTestUtil("type == \"brie\"", (FieldValue)new ObjectFieldImpl((Object)"brie"), (InternalReadAccessor)new MockExtractor());
        AlphaNode al2 = new AlphaNode(this.buildContext.getNextId(), (AlphaNodeFieldConstraint)lit2, (ObjectSource)new MockObjectSource(this.buildContext.getNextId()), this.buildContext);
        MVELConstraintTestUtil lit3 = new MVELConstraintTestUtil("type == \"muzzarela\"", (FieldValue)new ObjectFieldImpl((Object)"muzzarela"), (InternalReadAccessor)new MockExtractor());
        AlphaNode al3 = new AlphaNode(this.buildContext.getNextId(), (AlphaNodeFieldConstraint)lit3, (ObjectSource)new MockObjectSource(this.buildContext.getNextId()), this.buildContext);
        ad.addObjectSink((ObjectSink)al1);
        ad.addObjectSink((ObjectSink)al2);
        ad.addObjectSink((ObjectSink)al3);
        InternalFactHandle handle = new ReteooFactHandleFactory().newFactHandle((Object)new Cheese(), null, null, (WorkingMemoryEntryPoint)new DisconnectedWorkingMemoryEntryPoint("DEFAULT"));
        try {
            ad.propagateAssertObject(handle, null, null);
        }
        catch (RuntimeException e) {
            Assert.fail((String)("Not supposed to throw any exception: " + e.getMessage()));
        }
    }

    public static class MockBetaNode
    extends BetaNode {
        public MockBetaNode() {
        }

        protected boolean doRemove(RuleRemovalContext context, ReteooBuilder builder) {
            return true;
        }

        MockBetaNode(int id, LeftTupleSource leftInput, ObjectSource rightInput, BuildContext buildContext) {
            super(id, leftInput, rightInput, EmptyBetaConstraints.getInstance(), buildContext);
        }

        MockBetaNode(int id, LeftTupleSource leftInput, ObjectSource rightInput) {
            super(id, leftInput, rightInput, EmptyBetaConstraints.getInstance(), null);
        }

        public void assertObject(InternalFactHandle factHandle, PropagationContext pctx, InternalWorkingMemory workingMemory) {
        }

        public void modifyObject(InternalFactHandle factHandle, ModifyPreviousTuples modifyPreviousTuples, PropagationContext context, InternalWorkingMemory workingMemory) {
        }

        public void retractRightTuple(RightTuple rightTuple, PropagationContext context, InternalWorkingMemory workingMemory) {
        }

        public short getType() {
            return 0;
        }

        public void modifyRightTuple(RightTuple rightTuple, PropagationContext context, InternalWorkingMemory workingMemory) {
        }

        public LeftTuple createLeftTuple(InternalFactHandle factHandle, boolean leftTupleMemoryEnabled) {
            return new LeftTupleImpl(factHandle, (Sink)this, leftTupleMemoryEnabled);
        }

        public LeftTuple createLeftTuple(LeftTuple leftTuple, Sink sink, PropagationContext pctx, boolean leftTupleMemoryEnabled) {
            return new LeftTupleImpl(leftTuple, sink, pctx, leftTupleMemoryEnabled);
        }

        public LeftTuple createLeftTuple(InternalFactHandle factHandle, LeftTuple leftTuple, Sink sink) {
            return new LeftTupleImpl(factHandle, leftTuple, sink);
        }

        public LeftTuple createLeftTuple(LeftTuple leftTuple, RightTuple rightTuple, Sink sink) {
            return new LeftTupleImpl(leftTuple, rightTuple, sink);
        }

        public LeftTuple createLeftTuple(LeftTuple leftTuple, RightTuple rightTuple, LeftTuple currentLeftChild, LeftTuple currentRightChild, Sink sink, boolean leftTupleMemoryEnabled) {
            return new LeftTupleImpl(leftTuple, rightTuple, currentLeftChild, currentRightChild, sink, leftTupleMemoryEnabled);
        }

        public Memory createMemory(RuleBaseConfiguration config, InternalWorkingMemory wm) {
            return super.createMemory(config, wm);
        }

        public LeftTuple createPeer(LeftTuple original) {
            return null;
        }
    }

    public static class MockExtractor
    implements InternalReadAccessor {
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        }

        public void writeExternal(ObjectOutput out) throws IOException {
        }

        public int getIndex() {
            return 0;
        }

        public boolean getBooleanValue(InternalWorkingMemory workingMemory, Object object) {
            return false;
        }

        public byte getByteValue(InternalWorkingMemory workingMemory, Object object) {
            return 0;
        }

        public char getCharValue(InternalWorkingMemory workingMemory, Object object) {
            return '\u0000';
        }

        public double getDoubleValue(InternalWorkingMemory workingMemory, Object object) {
            return 0.0;
        }

        public Class getExtractToClass() {
            return null;
        }

        public String getExtractToClassName() {
            return null;
        }

        public float getFloatValue(InternalWorkingMemory workingMemory, Object object) {
            return 0.0f;
        }

        public int getIntValue(InternalWorkingMemory workingMemory, Object object) {
            return 0;
        }

        public long getLongValue(InternalWorkingMemory workingMemory, Object object) {
            return 0L;
        }

        public Method getNativeReadMethod() {
            return null;
        }

        public String getNativeReadMethodName() {
            return null;
        }

        public short getShortValue(InternalWorkingMemory workingMemory, Object object) {
            return 0;
        }

        public Object getValue(InternalWorkingMemory workingMemory, Object object) {
            return null;
        }

        public boolean isNullValue(Object object, InternalWorkingMemory workingMemory) {
            return false;
        }

        public ValueType getValueType() {
            return ValueType.STRING_TYPE;
        }

        public int getHashCode(InternalWorkingMemory workingMemory, Object object) {
            return 0;
        }

        public boolean isGlobal() {
            return false;
        }

        public boolean isNullValue(InternalWorkingMemory workingMemory, Object object) {
            return false;
        }

        public boolean getBooleanValue(Object object) {
            return false;
        }

        public byte getByteValue(Object object) {
            return 0;
        }

        public char getCharValue(Object object) {
            return '\u0000';
        }

        public double getDoubleValue(Object object) {
            return 0.0;
        }

        public float getFloatValue(Object object) {
            return 0.0f;
        }

        public int getHashCode(Object object) {
            return 0;
        }

        public int getIntValue(Object object) {
            return 0;
        }

        public long getLongValue(Object object) {
            return 0L;
        }

        public short getShortValue(Object object) {
            return 0;
        }

        public Object getValue(Object object) {
            return null;
        }

        public boolean isNullValue(Object object) {
            return false;
        }

        public boolean isSelfReference() {
            return false;
        }

        public BigDecimal getBigDecimalValue(InternalWorkingMemory workingMemory, Object object) {
            return null;
        }

        public BigInteger getBigIntegerValue(InternalWorkingMemory workingMemory, Object object) {
            return null;
        }

        public BigDecimal getBigDecimalValue(Object object) {
            return null;
        }

        public BigInteger getBigIntegerValue(Object object) {
            return null;
        }
    }
}

