/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.compiler.builder.impl;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.security.NoSuchAlgorithmException;
import java.security.Permission;
import java.security.Policy;
import java.security.ProtectionDomain;
import org.drools.compiler.builder.impl.KnowledgeBuilderImpl;
import org.drools.core.test.model.DroolsTestCase;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class KnowledgeBuilderWithSecurityManagerTest
extends DroolsTestCase {
    private static SecurityManager oldSecurityManager;
    private static Policy oldPolicy;

    @BeforeClass
    public static void initSecurityManager() throws NoSuchAlgorithmException {
        oldSecurityManager = System.getSecurityManager();
        oldPolicy = Policy.getPolicy();
        Policy.setPolicy(new Policy(){

            @Override
            public boolean implies(ProtectionDomain domain, Permission permission) {
                return true;
            }
        });
        System.setSecurityManager(new SecurityManager());
    }

    @AfterClass
    public static void destroySecurityManager() {
        System.setSecurityManager(oldSecurityManager);
        Policy.setPolicy(oldPolicy);
    }

    @Test
    public void testSecurityManager() throws Exception {
        KnowledgeBuilderImpl builder = new KnowledgeBuilderImpl();
        InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream("/com/security/example.drl");
        builder.addPackageFromDrl((Reader)new InputStreamReader(is));
        Assert.assertTrue((builder.getErrors().getErrors().length == 0 ? 1 : 0) != 0);
    }
}

