/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.compiler.oopath.graph;

import java.util.ArrayList;
import java.util.Collection;
import org.drools.core.phreak.AbstractReactiveObject;
import org.drools.mvel.compiler.oopath.graph.Vertex;
import org.drools.testcoverage.common.util.KieBaseTestConfiguration;
import org.drools.testcoverage.common.util.KieBaseUtil;
import org.drools.testcoverage.common.util.TestParametersUtil;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.KieBase;
import org.kie.api.runtime.KieSession;

@RunWith(value=Parameterized.class)
public class OOPathOnGraphTest {
    private final KieBaseTestConfiguration kieBaseTestConfiguration;

    public OOPathOnGraphTest(KieBaseTestConfiguration kieBaseTestConfiguration) {
        this.kieBaseTestConfiguration = kieBaseTestConfiguration;
    }

    @Parameterized.Parameters(name="KieBase type={0}")
    public static Collection<Object[]> getParameters() {
        return TestParametersUtil.getKieBaseCloudConfigurations((boolean)false);
    }

    @Test
    public void testOOPathOnGraph() {
        String drl = "import org.drools.mvel.compiler.oopath.graph.*;\nimport " + Library.class.getCanonicalName() + ";\nimport " + Book.class.getCanonicalName() + ";\nimport " + Person.class.getCanonicalName() + ";\nglobal java.util.List list\n\nrule R when\n  Vertex( it instanceof Library, $a : /outVs/outVs/it#Person[ age > 40 ] )\nthen\n  list.add( $a.getName() );\nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession ksession = kbase.newKieSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        Vertex<Library> library = this.getGraph();
        ksession.insert(library);
        ksession.fireAllRules();
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertTrue((boolean)list.contains("Mario"));
        list.clear();
        Vertex<Person> book = library.getOutVs().get(0);
        Vertex<Person> alan = new Vertex<Person>(new Person("Alan", 53));
        book.connectTo(alan);
        ksession.fireAllRules();
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertTrue((boolean)list.contains("Alan"));
    }

    @Test
    public void testOOPathOnGraphWithReactiveContentModification() {
        String drl = "import org.drools.mvel.compiler.oopath.graph.*;\nimport " + Library.class.getCanonicalName() + ";\nimport " + Book.class.getCanonicalName() + ";\nimport " + Person.class.getCanonicalName() + ";\nglobal java.util.List list\n\nrule R when\n  Vertex( it instanceof Library, $a : /outVs/outVs/it#Person[ age > 25 ] )\nthen\n  list.add( $a.getName() );\nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession ksession = kbase.newKieSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        Vertex<Library> library = this.getGraph();
        ksession.insert(library);
        ksession.fireAllRules();
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertTrue((boolean)list.contains("Mario"));
        list.clear();
        Person raoul = (Person)((Object)library.getOutVs().get(0).getOutVs().get(0).getIt());
        Assert.assertEquals((Object)"Raoul", (Object)raoul.getName());
        raoul.setAge(raoul.getAge() + 1);
        ksession.fireAllRules();
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertTrue((boolean)list.contains("Raoul"));
    }

    @Test
    public void testOOPathOnGraphWithReactiveContentModificationInSubgraph() {
        String drl = "import org.drools.mvel.compiler.oopath.graph.*;\nimport " + Library.class.getCanonicalName() + ";\nimport " + Book.class.getCanonicalName() + ";\nimport " + Person.class.getCanonicalName() + ";\nglobal java.util.List list\n\nrule R when\n  Vertex( it instanceof Library, $v : /outVs/outVs[ /it#Person[ age > 25 ] ] )\nthen\n  list.add( ((Person)$v.getIt()).getName() );\nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession ksession = kbase.newKieSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        Vertex<Library> library = this.getGraph();
        ksession.insert(library);
        ksession.fireAllRules();
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertTrue((boolean)list.contains("Mario"));
        list.clear();
        Person raoul = (Person)((Object)library.getOutVs().get(0).getOutVs().get(0).getIt());
        Assert.assertEquals((Object)"Raoul", (Object)raoul.getName());
        raoul.setAge(raoul.getAge() + 1);
        ksession.fireAllRules();
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertTrue((boolean)list.contains("Raoul"));
    }

    @Test
    public void testOOPathOnGraphWithNonReactiveContentModification() {
        String drl = "import org.drools.mvel.compiler.oopath.graph.*;\nimport " + Library.class.getCanonicalName() + ";\nimport " + Book.class.getCanonicalName() + ";\nimport " + Person.class.getCanonicalName() + ";\nglobal java.util.List list\n\nrule R when\n  Vertex( it instanceof Library, $v : /outVs/outVs[ it#Person.age > 25 ] )\nthen\n  list.add( ((Person)$v.getIt()).getName() );\nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession ksession = kbase.newKieSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        Vertex<Library> library = this.getGraph();
        ksession.insert(library);
        ksession.fireAllRules();
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertTrue((boolean)list.contains("Mario"));
        list.clear();
        Person raoul = (Person)((Object)library.getOutVs().get(0).getOutVs().get(0).getIt());
        Assert.assertEquals((Object)"Raoul", (Object)raoul.getName());
        raoul.setAge(raoul.getAge() + 1);
        ksession.fireAllRules();
        Assert.assertEquals((long)0L, (long)list.size());
    }

    private Vertex<Library> getGraph() {
        Vertex<Library> library = new Vertex<Library>(new Library());
        Vertex<Book> java8inAction = new Vertex<Book>(new Book("Java 8 in Action"));
        library.connectTo(java8inAction);
        Vertex<Person> raoul = new Vertex<Person>(new Person("Raoul", 25));
        java8inAction.connectTo(raoul);
        Vertex<Person> mario = new Vertex<Person>(new Person("Mario", 41));
        java8inAction.connectTo(mario);
        return library;
    }

    public static class Person
    extends AbstractReactiveObject {
        private final String name;
        private int age;

        public Person(String name, int age) {
            this.name = name;
            this.age = age;
        }

        public String getName() {
            return this.name;
        }

        public int getAge() {
            return this.age;
        }

        public void setAge(int age) {
            this.age = age;
            this.notifyModification();
        }
    }

    public static class Book {
        private final String title;

        public Book(String title) {
            this.title = title;
        }

        public String getTitle() {
            return this.title;
        }
    }

    public static class Library {
    }
}

