/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.integrationtests;

import java.util.Collection;
import org.drools.testcoverage.common.util.KieBaseTestConfiguration;
import org.drools.testcoverage.common.util.KieUtil;
import org.drools.testcoverage.common.util.TestParametersUtil;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.KieServices;
import org.kie.api.builder.KieBuilder;
import org.kie.api.builder.KieFileSystem;

@RunWith(value=Parameterized.class)
public class KieDefaultPackageTest {
    private final KieBaseTestConfiguration kieBaseTestConfiguration;

    public KieDefaultPackageTest(KieBaseTestConfiguration kieBaseTestConfiguration) {
        this.kieBaseTestConfiguration = kieBaseTestConfiguration;
    }

    @Parameterized.Parameters(name="KieBase type={0}")
    public static Collection<Object[]> getParameters() {
        return TestParametersUtil.getKieBaseCloudConfigurations((boolean)true);
    }

    @Test
    public void testAllInDefaultPackage() throws Exception {
        String model_drl = "declare Smurf\nField1 : String\nend\n";
        String drl = "rule \"test\"\nwhen\nSmurf()\nthen\nend";
        KieServices ks = KieServices.Factory.get();
        KieFileSystem kfs = ks.newKieFileSystem();
        kfs.write("src/main/resources/model.drl", model_drl);
        kfs.write("src/main/resources/drl.drl", drl);
        KieBuilder builder = KieUtil.getKieBuilderFromKieFileSystem((KieBaseTestConfiguration)this.kieBaseTestConfiguration, (KieFileSystem)kfs, (boolean)false);
        Assert.assertEquals((long)0L, (long)builder.getResults().getMessages().size());
    }

    @Test
    public void testInTestPackage() throws Exception {
        String javaClass = "package org.jbpm;\npublic class Test{}\n";
        KieServices ks = KieServices.Factory.get();
        KieFileSystem kfs = ks.newKieFileSystem();
        kfs.write("src/test/java/org/jbpm/Test.java", javaClass);
        KieBuilder builder = KieUtil.getKieBuilderFromKieFileSystem((KieBaseTestConfiguration)this.kieBaseTestConfiguration, (KieFileSystem)kfs, (boolean)false);
        Assert.assertEquals((long)0L, (long)builder.getResults().getMessages().size());
    }

    @Test
    @Ignore(value="How do you access Type 'Smurf'? Test 1 - No import prefix")
    public void testModelInDefaultPackage1() throws Exception {
        String model_drl = "declare Smurf\nField1 : String\nend\n";
        String drl = "package org.smurf\nimport Smurf\nrule \"test\"\nwhen\nSmurf()\nthen\nend";
        KieServices ks = KieServices.Factory.get();
        KieFileSystem kfs = ks.newKieFileSystem();
        kfs.write("src/main/resources/model.drl", model_drl);
        kfs.write("src/main/resources/drl.drl", drl);
        KieBuilder builder = KieUtil.getKieBuilderFromKieFileSystem((KieBaseTestConfiguration)this.kieBaseTestConfiguration, (KieFileSystem)kfs, (boolean)false);
        Assert.assertEquals((long)0L, (long)builder.getResults().getMessages().size());
    }

    @Test
    public void testModelInDefaultPackage2() throws Exception {
        String model_drl = "declare Smurf\nField1 : String\nend\n";
        String drl = "package org.smurf\nimport defaultpkg.Smurf\nrule \"test\"\nwhen\nSmurf()\nthen\nend";
        KieServices ks = KieServices.Factory.get();
        KieFileSystem kfs = ks.newKieFileSystem();
        kfs.write("src/main/resources/model.drl", model_drl);
        kfs.write("src/main/resources/drl.drl", drl);
        KieBuilder builder = KieUtil.getKieBuilderFromKieFileSystem((KieBaseTestConfiguration)this.kieBaseTestConfiguration, (KieFileSystem)kfs, (boolean)false);
        Assert.assertEquals((long)0L, (long)builder.getResults().getMessages().size());
    }

    @Test
    public void testAllInExplicitPackage() throws Exception {
        String model_drl = "package org.smurf\ndeclare Smurf\nField1 : String\nend\n";
        String drl = "package org.smurf\nrule \"test\"\nwhen\nSmurf()\nthen\nend";
        KieServices ks = KieServices.Factory.get();
        KieFileSystem kfs = ks.newKieFileSystem();
        kfs.write("src/main/resources/model.drl", model_drl);
        kfs.write("src/main/resources/drl.drl", drl);
        KieBuilder builder = KieUtil.getKieBuilderFromKieFileSystem((KieBaseTestConfiguration)this.kieBaseTestConfiguration, (KieFileSystem)kfs, (boolean)false);
        Assert.assertEquals((long)0L, (long)builder.getResults().getMessages().size());
    }

    @Test
    public void testAllInDifferentExplicitPackages() throws Exception {
        String model_drl = "package org.smurf\ndeclare Smurf\nField1 : String\nend\n";
        String drl = "package org.smurf.subpackage\nimport org.smurf.Smurf\nrule \"test\"\nwhen\nSmurf()\nthen\nend";
        KieServices ks = KieServices.Factory.get();
        KieFileSystem kfs = ks.newKieFileSystem();
        kfs.write("src/main/resources/model.drl", model_drl);
        kfs.write("src/main/resources/drl.drl", drl);
        KieBuilder builder = KieUtil.getKieBuilderFromKieFileSystem((KieBaseTestConfiguration)this.kieBaseTestConfiguration, (KieFileSystem)kfs, (boolean)false);
        Assert.assertEquals((long)0L, (long)builder.getResults().getMessages().size());
    }
}

