/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.integrationtests;

import java.util.ArrayList;
import java.util.Collection;
import org.drools.core.common.InternalFactHandle;
import org.drools.mvel.compiler.Person;
import org.drools.testcoverage.common.util.KieBaseTestConfiguration;
import org.drools.testcoverage.common.util.KieBaseUtil;
import org.drools.testcoverage.common.util.TestParametersUtil;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.KieBase;
import org.kie.api.runtime.KieSession;

@RunWith(value=Parameterized.class)
public class UnlinkingTest {
    private final KieBaseTestConfiguration kieBaseTestConfiguration;

    public UnlinkingTest(KieBaseTestConfiguration kieBaseTestConfiguration) {
        this.kieBaseTestConfiguration = kieBaseTestConfiguration;
    }

    @Parameterized.Parameters(name="KieBase type={0}")
    public static Collection<Object[]> getParameters() {
        return TestParametersUtil.getKieBaseCloudConfigurations((boolean)false);
    }

    @Test
    public void multipleJoinsUsingSameOTN() throws Exception {
        KieBase kbase = KieBaseUtil.getKieBaseFromClasspathResources(this.getClass(), (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"test_LRUnlinking.drl"});
        KieSession wmOne = kbase.newKieSession();
        KieSession wmTwo = kbase.newKieSession();
        ArrayList listOne = new ArrayList();
        ArrayList listTwo = new ArrayList();
        wmOne.setGlobal("results", listOne);
        wmTwo.setGlobal("results", listTwo);
        Person name = new Person();
        Person likes = new Person();
        Person age = new Person();
        Person hair = new Person();
        Person happy = new Person();
        Person match = new Person();
        name.setName("Ana");
        likes.setLikes("Chocolate");
        age.setAge(30);
        hair.setHair("brown");
        happy.setHappy(true);
        match.setName("Leo");
        match.setLikes("Chocolate");
        match.setAge(30);
        match.setHair("brown");
        match.setHappy(true);
        wmOne.insert((Object)name);
        wmOne.insert((Object)likes);
        wmOne.insert((Object)age);
        wmOne.fireAllRules();
        Assert.assertEquals((String)"Should not have fired", (long)0L, (long)listOne.size());
        wmTwo.insert((Object)name);
        wmTwo.insert((Object)likes);
        wmTwo.insert((Object)age);
        wmTwo.fireAllRules();
        Assert.assertEquals((String)"Should not have fired", (long)0L, (long)listTwo.size());
        wmOne.insert((Object)hair);
        wmOne.insert((Object)happy);
        InternalFactHandle matchHandle = (InternalFactHandle)wmOne.insert((Object)match);
        wmOne.fireAllRules();
        Assert.assertTrue((String)"Should have fired", (listOne.size() > 0 ? 1 : 0) != 0);
        Assert.assertEquals((String)"Should have inserted the match Person", (Object)matchHandle.getObject(), listOne.get(0));
        wmTwo.fireAllRules();
        Assert.assertEquals((String)"Should not have fired", (long)0L, (long)listTwo.size());
        wmTwo.insert((Object)hair);
        wmTwo.insert((Object)happy);
        wmTwo.insert((Object)match);
        wmTwo.fireAllRules();
        Assert.assertTrue((String)"Should have fired", (listTwo.size() > 0 ? 1 : 0) != 0);
    }
}

