/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.integrationtests.concurrency;

import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.assertj.core.api.Assertions;
import org.drools.testcoverage.common.util.KieBaseTestConfiguration;
import org.drools.testcoverage.common.util.KieBaseUtil;
import org.kie.api.KieBase;
import org.kie.api.runtime.KieSession;

public abstract class AbstractConcurrentInsertionsTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void testConcurrentInsertions(String drl, int objectCount, int threadCount, boolean newSessionForEachThread, boolean updateFacts, KieBaseTestConfiguration kieBaseTestConfiguration) throws InterruptedException {
        KieBase kieBase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)kieBaseTestConfiguration, (String[])new String[]{drl});
        ExecutorService executor = Executors.newFixedThreadPool(threadCount, r -> {
            Thread t = new Thread(r);
            t.setDaemon(true);
            return t;
        });
        KieSession ksession = null;
        try {
            int i;
            Callable[] tasks = new Callable[threadCount];
            if (newSessionForEachThread) {
                for (i = 0; i < threadCount; ++i) {
                    tasks[i] = this.getTask(objectCount, kieBase, updateFacts);
                }
            } else {
                ksession = kieBase.newKieSession();
                for (i = 0; i < threadCount; ++i) {
                    tasks[i] = this.getTask(objectCount, ksession, false, updateFacts);
                }
            }
            ExecutorCompletionService ecs = new ExecutorCompletionService(executor);
            for (Callable task : tasks) {
                ecs.submit(task);
            }
            int successCounter = 0;
            for (int i2 = 0; i2 < threadCount; ++i2) {
                try {
                    if (!((Boolean)ecs.take().get()).booleanValue()) continue;
                    ++successCounter;
                    continue;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            Assertions.assertThat((int)successCounter).isEqualTo(threadCount);
            if (ksession != null) {
                ksession.dispose();
            }
        }
        finally {
            executor.shutdown();
            if (!executor.awaitTermination(5L, TimeUnit.SECONDS)) {
                executor.shutdownNow();
            }
        }
    }

    private Callable<Boolean> getTask(int objectCount, KieBase kieBase, boolean updateFacts) {
        return this.getTask(objectCount, kieBase.newKieSession(), true, updateFacts);
    }

    protected abstract Callable<Boolean> getTask(int var1, KieSession var2, boolean var3, boolean var4);
}

