/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.integrationtests;

import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicInteger;
import org.drools.testcoverage.common.util.KieBaseTestConfiguration;
import org.drools.testcoverage.common.util.KieBaseUtil;
import org.drools.testcoverage.common.util.TestParametersUtil;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.KieBase;
import org.kie.api.definition.type.Role;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.rule.Agenda;

@RunWith(value=Parameterized.class)
public class SubnetworkTest {
    private final KieBaseTestConfiguration kieBaseTestConfiguration;

    public SubnetworkTest(KieBaseTestConfiguration kieBaseTestConfiguration) {
        this.kieBaseTestConfiguration = kieBaseTestConfiguration;
    }

    @Parameterized.Parameters(name="KieBase type={0}")
    public static Collection<Object[]> getParameters() {
        return TestParametersUtil.getKieBaseCloudConfigurations((boolean)true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=10000L)
    public void testRightStagingOnSharedSubnetwork() {
        String drl = "import " + AtomicInteger.class.getCanonicalName() + ";\nrule R1y when\n    AtomicInteger() \n    Number() from accumulate ( AtomicInteger( ) and $s : String( ) ; count($s) )    Long()\nthen\nend\n\nrule R1x when\n    AtomicInteger() \n    Number() from accumulate ( AtomicInteger( ) and $s : String( ) ; count($s) )\nthen\nend\nrule R2 when\n    $i : AtomicInteger( get() < 3 )\nthen\n    $i.incrementAndGet();    update($i);end\n\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"subnetwork-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession kieSession = kbase.newKieSession();
        try {
            kieSession.insert((Object)new AtomicInteger(0));
            kieSession.insert((Object)"test");
            kieSession.fireAllRules();
        }
        finally {
            kieSession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=10000L)
    public void testUpdateOnSharedSubnetwork() {
        String drl = "import " + AtomicInteger.class.getCanonicalName() + ";\nglobal java.util.List list;\nrule R1y when\n    AtomicInteger() \n    Number() from accumulate ( AtomicInteger( ) and $s : String( ) ; count($s) )    eval(false)\nthen\nend\n\nrule R2 when\n    $i : AtomicInteger( get() < 3 )\nthen\n    $i.incrementAndGet();    insert(\"test\" + $i.get());    update($i);end\n\nrule R1x when\n    AtomicInteger() \n    $c : Number() from accumulate ( AtomicInteger( ) and $s : String( ) ; count($s) )\n    eval(true)\nthen\n    list.add($c);end\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"subnetwork-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession kieSession = kbase.newKieSession();
        try {
            ArrayList list = new ArrayList();
            kieSession.setGlobal("list", list);
            kieSession.insert((Object)new AtomicInteger(0));
            kieSession.insert((Object)"test");
            kieSession.fireAllRules();
            Assert.assertEquals((long)1L, (long)list.size());
            Assert.assertEquals((long)4L, (long)((Number)list.get(0)).intValue());
        }
        finally {
            kieSession.dispose();
        }
    }

    @Test(timeout=10000L)
    public void testSubNetworks() {
        KieBase kieBase = KieBaseUtil.getKieBaseFromClasspathResources((String)"subnetwork-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"org/drools/compiler/integrationtests/test_SubNetworks.drl"});
        KieSession session = kieBase.newKieSession();
        session.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=10000L)
    public void testSubnetworkSharingWith2Sinks() {
        String drl = "import " + X.class.getCanonicalName() + "\nimport " + Y.class.getCanonicalName() + "\nglobal java.util.List list\nrule R1 agenda-group \"G2\" when\n    Number( intValue == 0 ) from accumulate (\n        X( $id : id )\n        and $y : Y( parentId == $id )\n    ;count($y))\nthen\n    list.add(\"R1\");\nend\n\nrule R2 agenda-group \"G1\" when\n    Number( intValue < 1 ) from accumulate (\n        X( $id : id )\n        and $y : Y( parentId == $id )\n    ;count($y))\nthen\n    list.add(\"R2\");\nend\n\nrule R3 agenda-group \"G1\" no-loop when\n    $x : X( $id : id )\nthen\n    modify($x) { setId($id + 1) };\nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"subnetwork-cep-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession kieSession = kbase.newKieSession();
        try {
            ArrayList list = new ArrayList();
            kieSession.setGlobal("list", list);
            kieSession.insert((Object)new X(1));
            kieSession.insert((Object)new Y(1));
            kieSession.insert((Object)new X(3));
            kieSession.insert((Object)new Y(3));
            Agenda agenda = kieSession.getAgenda();
            agenda.getAgendaGroup("G2").setFocus();
            agenda.getAgendaGroup("G1").setFocus();
            kieSession.fireAllRules();
            Assert.assertEquals((long)2L, (long)list.size());
            Assert.assertEquals((Object)"R2", list.get(0));
            Assert.assertEquals((Object)"R1", list.get(1));
        }
        finally {
            kieSession.dispose();
        }
    }

    public static class Y {
        private final int parentId;

        public Y(int parentId) {
            this.parentId = parentId;
        }

        public int getParentId() {
            return this.parentId;
        }
    }

    public static class X {
        private int id;

        public X(int id) {
            this.id = id;
        }

        public int getId() {
            return this.id;
        }

        public void setId(int id) {
            this.id = id;
        }
    }

    @Role(value=Role.Type.EVENT)
    public static class C {
    }

    @Role(value=Role.Type.EVENT)
    public static class B {
    }

    @Role(value=Role.Type.EVENT)
    public static class A {
    }
}

