/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.compiler.conf;

import org.drools.core.BeliefSystemType;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kie.api.KieServices;
import org.kie.api.runtime.KieSessionConfiguration;
import org.kie.api.runtime.conf.BeliefSystemTypeOption;
import org.kie.api.runtime.conf.ClockTypeOption;
import org.kie.api.runtime.conf.KieSessionOption;

public class KnowledgeSessionConfigurationTest {
    private KieSessionConfiguration config;

    @Before
    public void setUp() throws Exception {
        this.config = KieServices.Factory.get().newKieSessionConfiguration();
    }

    @Test
    public void testClockTypeConfiguration() {
        this.config.setOption((KieSessionOption)ClockTypeOption.PSEUDO);
        Assert.assertEquals((Object)ClockTypeOption.PSEUDO, (Object)this.config.getOption(ClockTypeOption.class));
        Assert.assertEquals((Object)"pseudo", (Object)this.config.getProperty("drools.clockType"));
        this.config.setProperty("drools.clockType", "realtime");
        Assert.assertEquals((Object)ClockTypeOption.REALTIME, (Object)this.config.getOption(ClockTypeOption.class));
        Assert.assertEquals((Object)"realtime", (Object)this.config.getProperty("drools.clockType"));
    }

    @Test
    public void testBeliefSystemType() {
        this.config.setOption((KieSessionOption)BeliefSystemTypeOption.get((String)BeliefSystemType.JTMS.toString()));
        Assert.assertEquals((Object)BeliefSystemTypeOption.get((String)BeliefSystemType.JTMS.toString()), (Object)this.config.getOption(BeliefSystemTypeOption.class));
        Assert.assertEquals((Object)BeliefSystemType.JTMS.getId(), (Object)this.config.getProperty("drools.beliefSystem"));
        this.config.setProperty("drools.beliefSystem", BeliefSystemType.DEFEASIBLE.getId());
        Assert.assertEquals((Object)BeliefSystemTypeOption.get((String)BeliefSystemType.DEFEASIBLE.getId()), (Object)this.config.getOption(BeliefSystemTypeOption.class));
        Assert.assertEquals((Object)BeliefSystemType.DEFEASIBLE.getId(), (Object)this.config.getProperty("drools.beliefSystem"));
    }
}

