/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.compiler.lang.descr;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.util.List;
import java.util.Map;
import org.drools.compiler.lang.api.DescrFactory;
import org.drools.compiler.lang.api.PackageDescrBuilder;
import org.drools.compiler.lang.descr.AttributeDescr;
import org.drools.compiler.lang.descr.ImportDescr;
import org.drools.compiler.lang.descr.PackageDescr;
import org.drools.compiler.lang.descr.RuleDescr;
import org.drools.core.util.StringUtils;
import org.drools.mvel.compiler.Person;
import org.junit.Assert;
import org.junit.Test;

public class PackageDescrTest {
    @Test
    public void testAttributeOverriding() {
        PackageDescr desc = new PackageDescr("foo");
        AttributeDescr at1 = new AttributeDescr("foo", "bar");
        AttributeDescr at2 = new AttributeDescr("foo2", "default");
        desc.addAttribute(at1);
        desc.addAttribute(at2);
        RuleDescr rule = new RuleDescr("abc");
        rule.addAttribute(new AttributeDescr("foo", "overridden"));
        desc.addRule(rule);
        List pkgAts = desc.getAttributes();
        Assert.assertEquals((Object)"bar", (Object)((AttributeDescr)pkgAts.get(0)).getValue());
        Assert.assertEquals((Object)"default", (Object)((AttributeDescr)pkgAts.get(1)).getValue());
        desc.afterRuleAdded(rule);
        Map ruleAts = rule.getAttributes();
        Assert.assertEquals((Object)"overridden", (Object)((AttributeDescr)ruleAts.get("foo")).getValue());
        Assert.assertEquals((Object)"default", (Object)((AttributeDescr)ruleAts.get("foo2")).getValue());
    }

    @Test
    public void testSerializationImportDescr() {
        PackageDescrBuilder builder = DescrFactory.newPackage().name("foo");
        String className = Person.class.getName();
        builder.newImport().target(className).end();
        PackageDescr descr = (PackageDescr)builder.getDescr();
        ImportDescr importDescr = new ImportDescr(className);
        ImportDescr badImportDescr = new ImportDescr(null);
        Assert.assertTrue((boolean)descr.getImports().contains(importDescr));
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(baos);
            descr.writeExternal((ObjectOutput)out);
            ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(baos.toByteArray()));
            PackageDescr newDescr = new PackageDescr();
            newDescr.readExternal((ObjectInput)in);
            Assert.assertFalse((boolean)newDescr.getImports().contains(badImportDescr));
            Assert.assertTrue((boolean)newDescr.getImports().contains(importDescr));
            Assert.assertFalse((boolean)newDescr.getPreferredPkgUUID().isPresent());
        }
        catch (IOException | ClassNotFoundException e) {
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testSerializationPkgUUID() {
        PackageDescrBuilder builder = DescrFactory.newPackage().name("foo");
        String className = Person.class.getName();
        builder.newImport().target(className).end();
        PackageDescr descr = (PackageDescr)builder.getDescr();
        String pkgUUID = StringUtils.generateUUID();
        descr.setPreferredPkgUUID(pkgUUID);
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(baos);
            descr.writeExternal((ObjectOutput)out);
            ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(baos.toByteArray()));
            PackageDescr newDescr = new PackageDescr();
            newDescr.readExternal((ObjectInput)in);
            Assert.assertTrue((boolean)newDescr.getPreferredPkgUUID().isPresent());
            Assert.assertEquals((Object)pkgUUID, newDescr.getPreferredPkgUUID().get());
        }
        catch (IOException | ClassNotFoundException e) {
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testGetPreferredPkgUUID() {
        PackageDescr descr = new PackageDescr();
        Assert.assertFalse((boolean)descr.getPreferredPkgUUID().isPresent());
        String pkgUUID = StringUtils.generateUUID();
        descr.setPreferredPkgUUID(pkgUUID);
        Assert.assertTrue((boolean)descr.getPreferredPkgUUID().isPresent());
        Assert.assertEquals((Object)pkgUUID, descr.getPreferredPkgUUID().get());
    }
}

