/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.integrationtests;

import java.util.Collection;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.drools.core.ClockType;
import org.drools.core.impl.KnowledgeBaseFactory;
import org.drools.testcoverage.common.util.KieBaseTestConfiguration;
import org.drools.testcoverage.common.util.KieBaseUtil;
import org.drools.testcoverage.common.util.TestParametersUtil;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.KieBase;
import org.kie.api.definition.type.FactType;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.KieSessionConfiguration;
import org.kie.api.runtime.conf.ClockTypeOption;
import org.kie.api.runtime.conf.KieSessionOption;
import org.kie.api.time.SessionPseudoClock;

@RunWith(value=Parameterized.class)
public class FireUntilHaltAccumulateTest {
    private final KieBaseTestConfiguration kieBaseTestConfiguration;
    private KieSession statefulSession;
    private StockFactory stockFactory;
    private static String drl = "package org.drools.integrationtests\n\nimport java.util.List;\n\ndeclare Stock\n    @role( event )\n    @expires( 1s ) // setting to a large value causes the test to pass\n    name : String\n    value : Double\nend\n\nrule \"collect events\"\nwhen\n    stocks := List()\n        from accumulate( $zeroStock : Stock( value == 0.0 );\n                         collectList( $zeroStock ) )\nthen\nend";

    public FireUntilHaltAccumulateTest(KieBaseTestConfiguration kieBaseTestConfiguration) {
        this.kieBaseTestConfiguration = kieBaseTestConfiguration;
    }

    @Parameterized.Parameters(name="KieBase type={0}")
    public static Collection<Object[]> getParameters() {
        return TestParametersUtil.getKieBaseStreamConfigurations((boolean)true);
    }

    @Before
    public void setUp() {
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSessionConfiguration sessionConfig = KnowledgeBaseFactory.newKnowledgeSessionConfiguration();
        sessionConfig.setOption((KieSessionOption)ClockTypeOption.get((String)ClockType.PSEUDO_CLOCK.getId()));
        this.statefulSession = kbase.newKieSession(sessionConfig, null);
        this.stockFactory = new StockFactory(kbase);
    }

    @After
    public void cleanUp() {
        if (this.statefulSession != null) {
            this.statefulSession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFireUntilHaltWithAccumulateAndExpires() throws Exception {
        ExecutorService executor = Executors.newSingleThreadExecutor();
        Future<?> sessionFuture = executor.submit(() -> ((KieSession)this.statefulSession).fireUntilHalt());
        try {
            for (int iteration = 0; iteration < 100; ++iteration) {
                this.populateSessionWithStocks();
            }
            Thread.sleep(2000L);
        }
        finally {
            this.statefulSession.halt();
            sessionFuture.get();
            this.statefulSession.dispose();
            executor.shutdownNow();
        }
    }

    private void populateSessionWithStocks() {
        SessionPseudoClock clock = (SessionPseudoClock)this.statefulSession.getSessionClock();
        clock.advanceTime(1L, TimeUnit.SECONDS);
        this.statefulSession.insert(this.stockFactory.createStock("ST1", 0.0));
        clock.advanceTime(1L, TimeUnit.SECONDS);
        this.statefulSession.insert(this.stockFactory.createStock("ST2", 1.0));
        clock.advanceTime(1L, TimeUnit.SECONDS);
        this.statefulSession.insert(this.stockFactory.createStock("ST3", 0.0));
        clock.advanceTime(1L, TimeUnit.SECONDS);
        this.statefulSession.insert(this.stockFactory.createStock("ST4", 0.0));
        clock.advanceTime(1L, TimeUnit.SECONDS);
        this.statefulSession.insert(this.stockFactory.createStock("ST5", 0.0));
        clock.advanceTime(1L, TimeUnit.SECONDS);
        this.statefulSession.insert(this.stockFactory.createStock("ST6", 1.0));
    }

    private static class StockFactory {
        private static final String DRL_PACKAGE_NAME = "org.drools.integrationtests";
        private static final String DRL_FACT_NAME = "Stock";
        private final KieBase kbase;

        public StockFactory(KieBase kbase) {
            this.kbase = kbase;
        }

        public Object createStock(String name, Double value) {
            try {
                return this.createDRLStock(name, value);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("Unable to create Stock instance defined in DRL", e);
            }
            catch (InstantiationException e) {
                throw new RuntimeException("Unable to create Stock instance defined in DRL", e);
            }
        }

        private Object createDRLStock(String name, Double value) throws IllegalAccessException, InstantiationException {
            FactType stockType = this.kbase.getFactType(DRL_PACKAGE_NAME, DRL_FACT_NAME);
            Object stock = stockType.newInstance();
            stockType.set(stock, "name", (Object)name);
            stockType.set(stock, "value", (Object)value);
            return stock;
        }
    }
}

