/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.integrationtests;

import java.util.Collection;
import org.appformer.maven.support.AFReleaseId;
import org.drools.compiler.compiler.io.File;
import org.drools.compiler.compiler.io.memory.MemoryFileSystem;
import org.drools.compiler.kie.builder.impl.InternalKieModule;
import org.drools.compiler.kie.builder.impl.KieBuilderImpl;
import org.drools.mvel.compiler.Message;
import org.drools.testcoverage.common.util.KieBaseTestConfiguration;
import org.drools.testcoverage.common.util.KieUtil;
import org.drools.testcoverage.common.util.TestParametersUtil;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.KieBase;
import org.kie.api.KieServices;
import org.kie.api.builder.KieBuilder;
import org.kie.api.builder.KieFileSystem;
import org.kie.api.builder.KieModule;
import org.kie.api.builder.ReleaseId;
import org.kie.api.builder.model.KieModuleModel;
import org.kie.api.conf.EqualityBehaviorOption;
import org.kie.api.conf.EventProcessingOption;
import org.kie.api.definition.type.FactField;
import org.kie.api.definition.type.FactType;
import org.kie.api.io.Resource;
import org.kie.api.runtime.KieContainer;
import org.kie.api.runtime.KieSession;

@RunWith(value=Parameterized.class)
public class KieCompilationCacheTest {
    private final KieBaseTestConfiguration kieBaseTestConfiguration;

    public KieCompilationCacheTest(KieBaseTestConfiguration kieBaseTestConfiguration) {
        this.kieBaseTestConfiguration = kieBaseTestConfiguration;
    }

    @Parameterized.Parameters(name="KieBase type={0}")
    public static Collection<Object[]> getParameters() {
        return TestParametersUtil.getKieBaseCloudConfigurations((boolean)false);
    }

    @Test
    public void testCompilationCache() throws Exception {
        String drl = "package org.drools.compiler\ndeclare type X\n    foo : String\nend\nrule R1 when\n   $m : X( foo == \"Hello World\" )\nthen\nend\n";
        KieServices ks = KieServices.Factory.get();
        KieFileSystem kfs = ks.newKieFileSystem().write("src/main/resources/r1.drl", drl);
        KieBuilder kieBuilder = KieUtil.getKieBuilderFromKieFileSystem((KieBaseTestConfiguration)this.kieBaseTestConfiguration, (KieFileSystem)kfs, (boolean)false);
        ReleaseId releaseId = ks.getRepository().getDefaultReleaseId();
        InternalKieModule kieModule = (InternalKieModule)ks.getRepository().getKieModule(releaseId);
        byte[] jar = kieModule.getBytes();
        MemoryFileSystem mfs = MemoryFileSystem.readFromJar((byte[])jar);
        File file = mfs.getFile(KieBuilderImpl.getCompilationCachePath((AFReleaseId)releaseId, (String)"KBase1"));
        Assert.assertNotNull((Object)file);
        Resource jarRes = ks.getResources().newByteArrayResource(jar);
        KieModule km = ks.getRepository().addKieModule(jarRes, new Resource[0]);
        KieContainer kc = ks.newKieContainer(km.getReleaseId());
        KieBase kbase = kc.getKieBase();
        FactType type = kbase.getFactType("org.drools.compiler", "X");
        FactField foo = type.getField("foo");
        Object x = type.newInstance();
        foo.set(x, (Object)"Hello World");
        KieSession ksession = kc.newKieSession();
        ksession.insert(x);
        int count = ksession.fireAllRules();
        Assert.assertEquals((long)1L, (long)count);
    }

    @Test
    public void testHelloWorldWithPackagesAnd2KieBases() throws Exception {
        String drl1 = "package org.pkg1\nimport " + Message.class.getCanonicalName() + "\nrule R11 when\n   $m : Message( message == \"Hello World\" )\nthen\nend\nrule R12 when\n   $m : Message( message == \"Hi Universe\" )\nthen\nend\n";
        String drl2 = "package org.pkg2\nimport " + Message.class.getCanonicalName() + "\nrule R21 when\n   $m : Message( message == \"Hello World\" )\nthen\nend\nrule R22 when\n   $m : Message( message == \"Aloha Earth\" )\nthen\nend\n";
        KieServices ks = KieServices.Factory.get();
        ReleaseId releaseId = ks.newReleaseId("org.kie", "hello-world", "1.0");
        KieFileSystem kfs = ks.newKieFileSystem().generateAndWritePomXML(releaseId).write("src/main/resources/KBase1/org/pkg1/r1.drl", drl1).write("src/main/resources/KBase1/org/pkg2/r2.drl", drl2).writeKModuleXML(this.createKieProjectWithPackagesAnd2KieBases(ks).toXML());
        KieBuilder kieBuilder = KieUtil.getKieBuilderFromKieFileSystem((KieBaseTestConfiguration)this.kieBaseTestConfiguration, (KieFileSystem)kfs, (boolean)false);
        InternalKieModule kieModule = (InternalKieModule)ks.getRepository().getKieModule(releaseId);
        byte[] jar = kieModule.getBytes();
        MemoryFileSystem mfs = MemoryFileSystem.readFromJar((byte[])jar);
        File file = mfs.getFile(KieBuilderImpl.getCompilationCachePath((AFReleaseId)releaseId, (String)"KBase1"));
        Assert.assertNotNull((Object)file);
        file = mfs.getFile(KieBuilderImpl.getCompilationCachePath((AFReleaseId)releaseId, (String)"KBase2"));
        Assert.assertNotNull((Object)file);
        Resource jarRes = ks.getResources().newByteArrayResource(jar);
        KieModule km = ks.getRepository().addKieModule(jarRes, new Resource[0]);
        KieSession ksession = ks.newKieContainer(km.getReleaseId()).newKieSession("KSession1");
        ksession.insert((Object)new Message("Hello World"));
        Assert.assertEquals((long)1L, (long)ksession.fireAllRules());
        ksession = ks.newKieContainer(km.getReleaseId()).newKieSession("KSession1");
        ksession.insert((Object)new Message("Hi Universe"));
        Assert.assertEquals((long)1L, (long)ksession.fireAllRules());
        ksession = ks.newKieContainer(km.getReleaseId()).newKieSession("KSession1");
        ksession.insert((Object)new Message("Aloha Earth"));
        Assert.assertEquals((long)0L, (long)ksession.fireAllRules());
        ksession = ks.newKieContainer(km.getReleaseId()).newKieSession("KSession2");
        ksession.insert((Object)new Message("Hello World"));
        Assert.assertEquals((long)1L, (long)ksession.fireAllRules());
        ksession = ks.newKieContainer(km.getReleaseId()).newKieSession("KSession2");
        ksession.insert((Object)new Message("Hi Universe"));
        Assert.assertEquals((long)0L, (long)ksession.fireAllRules());
        ksession = ks.newKieContainer(km.getReleaseId()).newKieSession("KSession2");
        ksession.insert((Object)new Message("Aloha Earth"));
        Assert.assertEquals((long)1L, (long)ksession.fireAllRules());
    }

    @Test
    public void testCacheWigAccumulate() throws Exception {
        String drl1 = "package org.pkg1\nrule R11 when\n   Number() from accumulate(String(), \n              init(int x = 0;),              action(x++;),              reverse(x--;),              result(x))\nthen\nend\n";
        KieServices ks = KieServices.Factory.get();
        ReleaseId releaseId = ks.newReleaseId("org.kie", "cache-accumulate", "1.0");
        KieFileSystem kfs = ks.newKieFileSystem().generateAndWritePomXML(releaseId).write("src/main/resources/KBase1/org/pkg1/r1.drl", drl1).writeKModuleXML(this.createKieProjectWithPackagesAnd2KieBases(ks).toXML());
        KieBuilder kieBuilder = KieUtil.getKieBuilderFromKieFileSystem((KieBaseTestConfiguration)this.kieBaseTestConfiguration, (KieFileSystem)kfs, (boolean)false);
        InternalKieModule kieModule = (InternalKieModule)ks.getRepository().getKieModule(releaseId);
        byte[] jar = kieModule.getBytes();
        MemoryFileSystem mfs = MemoryFileSystem.readFromJar((byte[])jar);
        File file = mfs.getFile(KieBuilderImpl.getCompilationCachePath((AFReleaseId)releaseId, (String)"KBase1"));
        Assert.assertNotNull((Object)file);
        Resource jarRes = ks.getResources().newByteArrayResource(jar);
        KieModule km = ks.getRepository().addKieModule(jarRes, new Resource[0]);
        KieSession ksession = ks.newKieContainer(km.getReleaseId()).newKieSession("KSession1");
        ksession.insert((Object)new String("Hello World"));
        Assert.assertEquals((long)1L, (long)ksession.fireAllRules());
    }

    private KieModuleModel createKieProjectWithPackagesAnd2KieBases(KieServices ks) {
        KieModuleModel kproj = ks.newKieModuleModel();
        kproj.newKieBaseModel("KBase2").setEqualsBehavior(EqualityBehaviorOption.EQUALITY).setEventProcessingMode(EventProcessingOption.STREAM).addPackage("org.pkg1").newKieSessionModel("KSession1");
        kproj.newKieBaseModel("KBase1").setEqualsBehavior(EqualityBehaviorOption.EQUALITY).setEventProcessingMode(EventProcessingOption.STREAM).addPackage("org.pkg2").newKieSessionModel("KSession2");
        return kproj;
    }
}

