/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.integrationtests;

import java.util.Collection;
import org.drools.testcoverage.common.util.KieBaseTestConfiguration;
import org.drools.testcoverage.common.util.KieUtil;
import org.drools.testcoverage.common.util.TestParametersUtil;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.KieServices;
import org.kie.api.builder.KieBuilder;
import org.kie.api.builder.KieFileSystem;
import org.kie.api.builder.Results;
import org.kie.internal.builder.IncrementalResults;
import org.kie.internal.builder.InternalKieBuilder;

@RunWith(value=Parameterized.class)
public class MessageImplTest {
    private final KieBaseTestConfiguration kieBaseTestConfiguration;

    public MessageImplTest(KieBaseTestConfiguration kieBaseTestConfiguration) {
        this.kieBaseTestConfiguration = kieBaseTestConfiguration;
    }

    @Parameterized.Parameters(name="KieBase type={0}")
    public static Collection<Object[]> getParameters() {
        return TestParametersUtil.getKieBaseCloudConfigurations((boolean)true);
    }

    @Test
    public void testMessageFromInvalidDSL() throws Exception {
        String dsl = "bananna\n";
        String drl = "import org.drools.mvel.compiler.Person;\nrule R1\nwhen\nThere is a Person\nthen\nend\n";
        KieServices ks = KieServices.Factory.get();
        KieFileSystem kfs = ks.newKieFileSystem().write("src/main/resources/dsl.dsl", dsl).write("src/main/resources/drl.dslr", drl);
        KieBuilder kieBuilder = KieUtil.getKieBuilderFromKieFileSystem((KieBaseTestConfiguration)this.kieBaseTestConfiguration, (KieFileSystem)kfs, (boolean)false);
        Results results = kieBuilder.getResults();
        Assert.assertEquals((long)3L, (long)results.getMessages().size());
    }

    @Test
    public void testMessageWithIncrementalBuild() throws Exception {
        String dsl1 = "bananna\n";
        String drl1 = "import org.drools.mvel.compiler.Person;\nrule R1\nwhen\nThere is a Person\nthen\nend\n";
        String drl2 = "rule R2\nwhen\nthen\nend\n";
        KieServices ks = KieServices.Factory.get();
        KieFileSystem kfs = ks.newKieFileSystem().write("src/main/resources/dsl.dsl", dsl1).write("src/main/resources/drl.dslr", drl1);
        KieBuilder kieBuilder = KieUtil.getKieBuilderFromKieFileSystem((KieBaseTestConfiguration)this.kieBaseTestConfiguration, (KieFileSystem)kfs, (boolean)false);
        Results fullBuildResults = kieBuilder.getResults();
        Assert.assertEquals((long)3L, (long)fullBuildResults.getMessages().size());
        kfs.write("src/main/resources/r2.drl", drl2);
        IncrementalResults incrementalBuildResults = ((InternalKieBuilder)kieBuilder).createFileSet(new String[]{"src/main/resources/r2.drl"}).build();
        Assert.assertEquals((long)0L, (long)incrementalBuildResults.getAddedMessages().size());
        Assert.assertEquals((long)0L, (long)incrementalBuildResults.getRemovedMessages().size());
    }
}

