/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.integrationtests;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.drools.testcoverage.common.util.KieBaseTestConfiguration;
import org.drools.testcoverage.common.util.KieBaseUtil;
import org.drools.testcoverage.common.util.TestParametersUtil;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.KieBase;
import org.kie.api.event.rule.AfterMatchFiredEvent;
import org.kie.api.event.rule.AgendaEventListener;
import org.kie.api.event.rule.DefaultAgendaEventListener;
import org.kie.api.runtime.KieSession;

@Ignore
@RunWith(value=Parameterized.class)
public class WorkingMemoryActionsSerializationTest {
    private final KieBaseTestConfiguration kieBaseTestConfiguration;
    private static final List<String> RULES = Arrays.asList("enableRecording", "saveRecord", "processEvent", "ignoreEvent");
    private KieSession ksession;
    private KieBase kbase;
    private final Map<String, Integer> ruleCalls = new HashMap<String, Integer>();
    private final String accessor = "eventName";
    private final String drl = "package apackage\n \nimport org.drools.core.spi.KnowledgeHelper\nimport " + AnEvent.class.getCanonicalName() + "\n \ndeclare DoRecord end\n\nrule \"enableRecording\"\n  salience 100\nwhen\n  AnEvent() from entry-point \"game stream\"\nthen\n  drools.getEntryPoint(\"internal stream\").insert(new DoRecord());\nend\n\nrule \"saveRecord\"\n  salience -100\nwhen\n  $event : DoRecord() from entry-point \"internal stream\"\nthen\n  retract($event);\n  //save record\nend\n \nrule \"ignoreEvent\"\n  salience 40\nwhen\n  $discardCardEvent2 : AnEvent(" + "eventName" + " == \"discardCardIrr\") from entry-point \"game stream\"\nthen\n  retract($discardCardEvent2);\n  //This rule is intended to remove the event and ignore it\n  //ignore this message\nend\n\nrule \"processEvent\"\nwhen\n  $discardCardEvent : AnEvent(" + "eventName" + " == \"discardCard\") from entry-point \"game stream\"\nthen\n  retract($discardCardEvent);\n  //side effects go here\nend";

    public WorkingMemoryActionsSerializationTest(KieBaseTestConfiguration kieBaseTestConfiguration) {
        this.kieBaseTestConfiguration = kieBaseTestConfiguration;
    }

    @Parameterized.Parameters(name="KieBase type={0}")
    public static Collection<Object[]> getParameters() {
        return TestParametersUtil.getKieBaseCloudConfigurations((boolean)true);
    }

    @Before
    public void before() {
        this.ruleCalls.clear();
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{this.drl});
        this.ksession = kbase.newKieSession();
        this.ksession.addEventListener((AgendaEventListener)new DefaultAgendaEventListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void afterMatchFired(AfterMatchFiredEvent event) {
                String name = event.getMatch().getRule().getName();
                System.out.println(name + " fired!");
                Map map = WorkingMemoryActionsSerializationTest.this.ruleCalls;
                synchronized (map) {
                    Integer calls = (Integer)WorkingMemoryActionsSerializationTest.this.ruleCalls.get(name);
                    if (calls == null) {
                        calls = 1;
                    } else {
                        Integer n = calls;
                        Integer n2 = calls = Integer.valueOf(calls + 1);
                    }
                    WorkingMemoryActionsSerializationTest.this.ruleCalls.put(name, calls);
                }
            }
        });
        new Thread(() -> ((KieSession)this.ksession).fireUntilHalt()).start();
    }

    @After
    public void after() {
        this.ksession.halt();
        this.ksession.dispose();
    }

    @Test
    public void testMultipleFires() {
        this.playAnEvent("discardCard");
        this.checkExecutions(RULES, Arrays.asList(1, 1, 1, 0));
        System.out.println("first played");
        this.playAnEvent("discardCard");
        this.checkExecutions(RULES, Arrays.asList(2, 2, 2, 0));
        System.out.println("second played");
        this.playAnEvent("discardCardIrr");
        this.checkExecutions(RULES, Arrays.asList(3, 3, 2, 1));
        System.out.println("third played");
        this.playAnEvent("discardCardIrr");
        this.checkExecutions(RULES, Arrays.asList(4, 4, 2, 2));
        System.out.println("fourth played");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkExecutions(List<String> rules, List<Integer> expected) {
        Assert.assertEquals((String)"Wrong config passed. Rules doesn't match times", (long)rules.size(), (long)expected.size());
        Map<String, Integer> map = this.ruleCalls;
        synchronized (map) {
            for (int i = 0; i < rules.size(); ++i) {
                String ruleName = rules.get(i);
                Integer actualTimes = this.ruleCalls.get(ruleName);
                if (actualTimes == null) {
                    actualTimes = 0;
                }
                Assert.assertEquals((String)("Ruled " + ruleName + " is not called as often as expected."), (Object)expected.get(i), (Object)actualTimes);
            }
        }
    }

    private void playAnEvent(String key) {
        AnEvent discardCardIrr = new AnEvent(key);
        this.ksession.getEntryPoint("game stream").insert((Object)discardCardIrr);
        this.giveTheRuleThreadSomeTimeToFinishComputation(300L);
    }

    private void giveTheRuleThreadSomeTimeToFinishComputation(long time) {
        try {
            Thread.sleep(time);
        }
        catch (InterruptedException e) {
            Assert.fail();
        }
    }

    public static class AnEvent
    implements Serializable {
        private String eventName;

        public AnEvent() {
        }

        public AnEvent(String eventName) {
            this.eventName = eventName;
        }

        public String getEventName() {
            return this.eventName;
        }

        public void setEventName(String eventName) {
            this.eventName = eventName;
        }
    }
}

