/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.integrationtests.concurrency;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.assertj.core.api.Assertions;
import org.drools.core.impl.KnowledgeBaseFactory;
import org.drools.mvel.compiler.StockTick;
import org.drools.testcoverage.common.util.KieBaseTestConfiguration;
import org.drools.testcoverage.common.util.KieBaseUtil;
import org.drools.testcoverage.common.util.KieUtil;
import org.drools.testcoverage.common.util.TestParametersUtil;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.KieBase;
import org.kie.api.KieServices;
import org.kie.api.builder.KieModule;
import org.kie.api.conf.KieBaseOption;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.KieSessionConfiguration;
import org.kie.api.runtime.conf.ClockTypeOption;
import org.kie.api.runtime.conf.KieSessionOption;
import org.kie.api.runtime.conf.TimedRuleExecutionOption;
import org.kie.api.runtime.rule.EntryPoint;
import org.kie.api.runtime.rule.FactHandle;
import org.kie.api.runtime.rule.QueryResults;
import org.kie.internal.conf.ConstraintJittingThresholdOption;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RunWith(value=Parameterized.class)
public class MultithreadTest {
    private final KieBaseTestConfiguration kieBaseTestConfiguration;
    private static final Logger LOG = LoggerFactory.getLogger(MultithreadTest.class);

    public MultithreadTest(KieBaseTestConfiguration kieBaseTestConfiguration) {
        this.kieBaseTestConfiguration = kieBaseTestConfiguration;
    }

    @Parameterized.Parameters(name="KieBase type={0}")
    public static Collection<Object[]> getParameters() {
        return TestParametersUtil.getKieBaseCloudConfigurations((boolean)true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Test(timeout=2000000L)
    public void testSlidingTimeWindows() {
        String str = "package org.drools\nglobal java.util.List list; \nimport " + StockTick.class.getCanonicalName() + "; \ndeclare StockTick @role(event) end\nrule R\nwhen\n accumulate( $st : StockTick() over window:time(400ms)\n             from entry-point X,\n             $c : count(1) )then\n   list.add( $c ); \nend \n";
        ArrayList<Exception> errors = new ArrayList<Exception>();
        this.kieBaseTestConfiguration.setStreamMode(true);
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{str});
        KieSession ksession = kbase.newKieSession();
        EntryPoint ep = ksession.getEntryPoint("X");
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        int THREAD_NR = 2;
        ExecutorService executor = Executors.newFixedThreadPool(2, r -> {
            Thread t = new Thread(r);
            t.setDaemon(true);
            return t;
        });
        try {
            ExecutorCompletionService<Boolean> ecs = new ExecutorCompletionService<Boolean>(executor);
            ecs.submit(() -> {
                try {
                    ksession.fireUntilHalt();
                    return true;
                }
                catch (Exception e) {
                    errors.add(e);
                    e.printStackTrace();
                    return false;
                }
            });
            int RUN_TIME = 5000;
            boolean success = false;
            try {
                int i;
                for (i = 0; i < 2; ++i) {
                    ecs.submit(() -> {
                        try {
                            String s = Thread.currentThread().getName();
                            long endTS = System.currentTimeMillis() + 5000L;
                            int j = 0;
                            long lastTimeInserted = -1L;
                            while (System.currentTimeMillis() < endTS) {
                                long currentTimeInMillis = System.currentTimeMillis();
                                if (currentTimeInMillis <= lastTimeInserted) continue;
                                lastTimeInserted = currentTimeInMillis;
                                ep.insert((Object)new StockTick(j++, s, 0.0, 0L));
                            }
                            return true;
                        }
                        catch (Exception e) {
                            errors.add(e);
                            e.printStackTrace();
                            return false;
                        }
                    });
                }
                success = true;
                for (i = 0; i < 2; ++i) {
                    try {
                        success = (Boolean)ecs.take().get() != false && success;
                        continue;
                    }
                    catch (Exception e) {
                        errors.add(e);
                    }
                }
            }
            catch (Throwable throwable) {
                ksession.halt();
                try {
                    success = (Boolean)ecs.take().get() != false && success;
                }
                catch (Exception e) {
                    errors.add(e);
                }
                for (Exception e : errors) {
                    e.printStackTrace();
                }
                Assertions.assertThat(errors).isEmpty();
                Assertions.assertThat((boolean)success).isTrue();
                ksession.dispose();
                throw throwable;
            }
            ksession.halt();
            try {
                success = (Boolean)ecs.take().get() != false && success;
            }
            catch (Exception e) {
                errors.add(e);
            }
            Iterator iterator = errors.iterator();
            while (true) {
                if (!iterator.hasNext()) {
                    Assertions.assertThat(errors).isEmpty();
                    Assertions.assertThat((boolean)success).isTrue();
                    ksession.dispose();
                    return;
                }
                Exception e = (Exception)iterator.next();
                e.printStackTrace();
            }
        }
        finally {
            executor.shutdownNow();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=20000L)
    public void testClassLoaderRace() throws InterruptedException {
        String drl = "package org.drools.integrationtests;\nrule \"average temperature\"\nwhen\n $avg := Number( ) from accumulate (       $x : Integer ( );       average ($x) )\nthen\n  System.out.println( $avg );\nend\n\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"package org.drools.integrationtests;\nrule \"average temperature\"\nwhen\n $avg := Number( ) from accumulate (       $x : Integer ( );       average ($x) )\nthen\n  System.out.println( $avg );\nend\n\n"});
        KieSession session = kbase.newKieSession();
        Thread t = new Thread(() -> ((KieSession)session).fireUntilHalt());
        t.start();
        try {
            session.fireAllRules();
            for (int j = 0; j < 100; ++j) {
                session.insert((Object)j);
            }
            Thread.sleep(1000L);
        }
        finally {
            session.halt();
            session.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=20000L)
    public void testRaceOnAccumulateNodeSimple() throws InterruptedException {
        String drl = "package org.drools.integrationtests;\nimport " + Server.class.getCanonicalName() + ";\nimport " + IntEvent.class.getCanonicalName() + ";\ndeclare IntEvent\n  @role ( event )\n  @expires( 15s )\nend\n\nrule \"average temperature\"\nwhen\n  $s : Server (hostname == \"hiwaesdk\")\n $avg := Number( ) from accumulate (       IntEvent ( $temp : data ) over window:length(10) from entry-point ep01;       average ($temp)\n  )\nthen\n  $s.avgTemp = $avg.intValue();\n  System.out.println( $avg );\nend\n\n";
        this.kieBaseTestConfiguration.setStreamMode(true);
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession session = kbase.newKieSession();
        EntryPoint ep01 = session.getEntryPoint("ep01");
        Runner t = new Runner(session);
        t.start();
        try {
            Thread.sleep(1000L);
            Server hiwaesdk = new Server("hiwaesdk");
            session.insert((Object)hiwaesdk);
            long LIMIT = 20L;
            for (long i = 20L; i > 0L; --i) {
                ep01.insert((Object)new IntEvent((int)i));
                if (i % 1000L != 0L) continue;
                System.out.println(i);
            }
            Thread.sleep(1000L);
        }
        finally {
            session.halt();
            session.dispose();
        }
        if (t.getError() != null) {
            Assertions.fail((String)t.getError().getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Ignore
    public void testConcurrencyWithChronThreads() throws InterruptedException {
        String drl = "package it.intext.drools.fusion.bug;\n\nimport " + MyFact.class.getCanonicalName() + ";\n  global java.util.List list; \n\ndeclare MyFact\n\t@role( event )\n\t@expires( 1s )\nend\n\nrule \"Dummy\"\ntimer( cron: 0/1 * * * * ? )\nwhen\n  Number( $count : intValue ) from accumulate( MyFact( ) over window:time(1s); sum(1) )\nthen\n    System.out.println($count+\" myfact(s) seen in the last 1 seconds\");\n    list.add( $count ); \nend";
        this.kieBaseTestConfiguration.setStreamMode(true);
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSessionConfiguration conf = KnowledgeBaseFactory.newKnowledgeSessionConfiguration();
        conf.setOption((KieSessionOption)ClockTypeOption.REALTIME);
        KieSession ksession = kbase.newKieSession(conf, null);
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.fireAllRules();
        Runner t = new Runner(ksession);
        t.start();
        try {
            int FACTS_PER_POLL = 1000;
            int POLL_INTERVAL = 500;
            ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor();
            try {
                executor.scheduleAtFixedRate(() -> {
                    for (int j = 0; j < 1000; ++j) {
                        ksession.insert((Object)new MyFact());
                    }
                }, 0L, 500L, TimeUnit.MILLISECONDS);
                Thread.sleep(10200L);
            }
            finally {
                executor.shutdownNow();
            }
        }
        finally {
            ksession.halt();
            ksession.dispose();
        }
        t.join();
        if (t.getError() != null) {
            Assertions.fail((String)t.getError().getMessage());
        }
        System.out.println("Final size " + ksession.getObjects().size());
        ksession.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=20000L)
    public void testConcurrentQueries() {
        StringBuilder drl = new StringBuilder();
        drl.append("package org.drools.test;\nquery foo( ) \n   Object() from new Object() \nend\nrule XYZ when then end \n");
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl.toString()});
        KieSession ksession = kbase.newKieSession();
        int THREAD_NR = 5;
        ExecutorService executor = Executors.newFixedThreadPool(5, r -> {
            Thread t = new Thread(r);
            t.setDaemon(true);
            return t;
        });
        try {
            ExecutorCompletionService<Boolean> ecs = new ExecutorCompletionService<Boolean>(executor);
            for (int i = 0; i < 5; ++i) {
                ecs.submit(() -> {
                    boolean succ = false;
                    try {
                        QueryResults res = ksession.getQueryResults("foo", new Object[0]);
                        succ = res.size() == 1;
                        return succ;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        return succ;
                    }
                });
            }
            boolean success = true;
            for (int i = 0; i < 5; ++i) {
                try {
                    success = (Boolean)ecs.take().get() != false && success;
                    continue;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            Assertions.assertThat((boolean)success).isTrue();
            ksession.dispose();
        }
        finally {
            executor.shutdownNow();
        }
    }

    @Test(timeout=40000L)
    public void testConcurrentDelete() {
        String drl = "import " + SlowBean.class.getCanonicalName() + ";\nrule R when\n  $sb1: SlowBean() \n  $sb2: SlowBean( id > $sb1.id ) \nthen   System.out.println($sb2 + \" > \"+ $sb1);end\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession ksession = kbase.newKieSession();
        int BEAN_NR = 4;
        for (int step = 0; step < 2; ++step) {
            FactHandle[] fhs = new FactHandle[4];
            for (int i = 0; i < 4; ++i) {
                fhs[i] = ksession.insert((Object)new SlowBean(i + step * 4));
            }
            CyclicBarrier barrier = new CyclicBarrier(2);
            new Thread(() -> {
                ksession.fireAllRules();
                try {
                    barrier.await();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }).start();
            try {
                Thread.sleep(15L);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            for (int i = 0; i < 4; ++i) {
                if (i % 2 != 1) continue;
                ksession.delete(fhs[i]);
            }
            try {
                barrier.await();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            System.out.println("Done step " + step);
        }
    }

    @Test(timeout=20000L)
    public void testConcurrentFireAndDispose() throws InterruptedException {
        String drl = "rule R no-loop timer( int: 1s )\nwhen\n    String()\nthen\nend";
        this.kieBaseTestConfiguration.setStreamMode(true);
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"rule R no-loop timer( int: 1s )\nwhen\n    String()\nthen\nend"});
        KieSessionConfiguration ksconf = KieServices.Factory.get().newKieSessionConfiguration();
        ksconf.setOption((KieSessionOption)TimedRuleExecutionOption.YES);
        final KieSession ksession = kbase.newKieSession(ksconf, null);
        Thread t1 = new Thread(){

            @Override
            public void run() {
                LOG.info("before: sleep, dispose().");
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                LOG.info("before: dispose().");
                ksession.dispose();
                LOG.info("after: dispose().");
            }
        };
        t1.setDaemon(true);
        t1.start();
        try {
            int i = 0;
            LOG.info("before: while.");
            while (true) {
                ksession.insert((Object)("" + i++));
                ksession.fireAllRules();
            }
        }
        catch (IllegalStateException e) {
            LOG.info("after: while.");
        }
        catch (RejectedExecutionException e) {
            e.printStackTrace();
            Assertions.fail((String)"java.util.concurrent.RejectedExecutionException should not happen");
        }
        LOG.info("last line of test.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=20000L)
    public void testFireUntilHaltAndDispose() throws InterruptedException {
        String drl = "rule R no-loop timer( int: 1s )\nwhen\n    String()\nthen\nend";
        this.kieBaseTestConfiguration.setStreamMode(true);
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"rule R no-loop timer( int: 1s )\nwhen\n    String()\nthen\nend"});
        KieSessionConfiguration ksconf = KieServices.Factory.get().newKieSessionConfiguration();
        ksconf.setOption((KieSessionOption)TimedRuleExecutionOption.YES);
        KieSession ksession = kbase.newKieSession(ksconf, null);
        new Thread(() -> ((KieSession)ksession).fireUntilHalt()).start();
        try {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            ksession.insert((Object)"xxx");
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        finally {
            ksession.dispose();
            ksession.halt();
        }
    }

    @Test(timeout=40000L)
    public void testJittingShortComparison() {
        int i;
        String drl = "import " + BeanA.class.getCanonicalName() + "\n;global java.util.List list;rule R when\n  $a1: BeanA($sv1 : shortValue)\n  $b2: BeanA(shortValue != $sv1)\nthen\n  list.add(\"FIRED\");\nend";
        List<String> list = Collections.synchronizedList(new ArrayList());
        KieModule kieModule = KieUtil.getKieModuleFromDrls((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieBase kbase = KieBaseUtil.newKieBaseFromKieModuleWithAdditionalOptions((KieModule)kieModule, (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (KieBaseOption[])new KieBaseOption[]{ConstraintJittingThresholdOption.get((int)0)});
        int threadNr = 1000;
        Thread[] threads = new Thread[1000];
        for (i = 0; i < 1000; ++i) {
            threads[i] = new Thread(new SessionRunner(kbase, list));
        }
        for (i = 0; i < 1000; ++i) {
            threads[i].start();
        }
        for (i = 0; i < 1000; ++i) {
            try {
                threads[i].join();
                continue;
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
        Assertions.assertThat(list).hasSize(0);
    }

    public static class BeanA {
        public Short getShortValue() {
            return (short)769;
        }
    }

    public static class SessionRunner
    implements Runnable {
        private final KieSession ksession;

        public SessionRunner(KieBase kbase, List<String> list) {
            this.ksession = kbase.newKieSession();
            this.ksession.setGlobal("list", list);
            this.ksession.insert((Object)new BeanA());
        }

        @Override
        public void run() {
            this.ksession.fireAllRules();
        }
    }

    public class SlowBean {
        private final int id;

        public SlowBean(int id) {
            this.id = id;
        }

        public int getId() {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            return this.id;
        }

        public String toString() {
            return "" + this.id;
        }
    }

    public static class Runner
    extends Thread {
        private final KieSession ksession;
        private Throwable error;

        public Runner(KieSession ksession) {
            this.ksession = ksession;
        }

        @Override
        public void run() {
            try {
                this.ksession.fireUntilHalt();
            }
            catch (Throwable t) {
                this.error = t;
                throw new RuntimeException(t);
            }
        }

        public Throwable getError() {
            return this.error;
        }
    }

    public static class MyFact {
        Date timestamp = new Date();
        String id = UUID.randomUUID().toString();

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }
    }

    public class Server {
        public int currentTemp;
        public double avgTemp;
        public String hostname;
        public int readingCount;

        public Server(String hiwaesdk) {
            this.hostname = hiwaesdk;
        }

        public String toString() {
            return "Server{currentTemp=" + this.currentTemp + ", avgTemp=" + this.avgTemp + ", hostname='" + this.hostname + '\'' + '}';
        }
    }

    public static class IntEvent {
        private int data;

        public IntEvent(int j) {
            this.data = j;
        }

        public int getData() {
            return this.data;
        }

        public void setData(int data) {
            this.data = data;
        }
    }
}

