/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.compiler.oopath;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.assertj.core.api.Assertions;
import org.drools.mvel.compiler.oopath.model.Child;
import org.drools.mvel.compiler.oopath.model.Man;
import org.drools.mvel.compiler.oopath.model.Toy;
import org.drools.mvel.compiler.oopath.model.Woman;
import org.drools.testcoverage.common.util.KieBaseTestConfiguration;
import org.drools.testcoverage.common.util.KieBaseUtil;
import org.drools.testcoverage.common.util.TestParametersUtil;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.KieBase;
import org.kie.api.runtime.KieSession;

@RunWith(value=Parameterized.class)
public class OOPathBindTest {
    private final KieBaseTestConfiguration kieBaseTestConfiguration;

    public OOPathBindTest(KieBaseTestConfiguration kieBaseTestConfiguration) {
        this.kieBaseTestConfiguration = kieBaseTestConfiguration;
    }

    @Parameterized.Parameters(name="KieBase type={0}")
    public static Collection<Object[]> getParameters() {
        return TestParametersUtil.getKieBaseCloudConfigurations((boolean)false);
    }

    @Test
    public void testBindIntegerFireAllRules() throws InterruptedException, ExecutionException {
        this.testBindInteger(false);
    }

    @Test(timeout=1000L)
    public void testBindIntegerFireUntilHalt() throws InterruptedException, ExecutionException {
        this.testBindInteger(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBindInteger(boolean fireUntilHalt) throws InterruptedException, ExecutionException {
        String drl = "import org.drools.mvel.compiler.oopath.model.*;\nglobal java.util.List list\n\nrule R when\n  Adult( $age: /age )\nthen\n  list.add( $age );\nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"import org.drools.mvel.compiler.oopath.model.*;\nglobal java.util.List list\n\nrule R when\n  Adult( $age: /age )\nthen\n  list.add( $age );\nend\n"});
        KieSession ksession = kbase.newKieSession();
        Future<?> fireUntilHaltFuture = null;
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        try {
            if (fireUntilHalt) {
                fireUntilHaltFuture = executorService.submit(() -> ((KieSession)ksession).fireUntilHalt());
            }
            ArrayList<Integer> list = new ArrayList<Integer>();
            ksession.setGlobal("list", list);
            Man bob = new Man("Bob", 40);
            ksession.insert((Object)bob);
            if (fireUntilHalt) {
                this.waitForResultAndStopFireUntilHalt(list, ksession, fireUntilHaltFuture);
            } else {
                ksession.fireAllRules();
                Assertions.assertThat(list).hasSize(1);
            }
            Assertions.assertThat(list).contains((Object[])new Integer[]{40});
        }
        finally {
            executorService.shutdownNow();
            ksession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForResultAndStopFireUntilHalt(List<Integer> resultList, KieSession kieSession, Future fireUntilHaltFuture) throws InterruptedException, ExecutionException {
        try {
            while (resultList.size() < 1) {
                Thread.sleep(100L);
            }
        }
        finally {
            kieSession.halt();
            fireUntilHaltFuture.get();
        }
    }

    @Test
    public void testBindString() {
        String drl = "import org.drools.mvel.compiler.oopath.model.*;\nglobal java.util.List list\n\nrule R when\n  Adult( $name: /name )\nthen\n  list.add( $name );\nend\n";
        this.testScenarioBindString("import org.drools.mvel.compiler.oopath.model.*;\nglobal java.util.List list\n\nrule R when\n  Adult( $name: /name )\nthen\n  list.add( $name );\nend\n", "Bob", "Alice");
    }

    @Test
    public void testBindStringWithConstraint() {
        String drl = "import org.drools.mvel.compiler.oopath.model.*;\nglobal java.util.List list\n\nrule R when\n  Adult( $name: /name[this == \"Bob\"] )\nthen\n  list.add( $name );\nend\n";
        this.testScenarioBindString("import org.drools.mvel.compiler.oopath.model.*;\nglobal java.util.List list\n\nrule R when\n  Adult( $name: /name[this == \"Bob\"] )\nthen\n  list.add( $name );\nend\n", "Bob");
    }

    @Test
    public void testBindStringWithAlphaConstraint() {
        String drl = "import org.drools.mvel.compiler.oopath.model.*;\nglobal java.util.List list\n\nrule R when\n  Adult( $name: /name[this.length == 3, this != \"George\"] )\nthen\n  list.add( $name );\nend\n";
        this.testScenarioBindString("import org.drools.mvel.compiler.oopath.model.*;\nglobal java.util.List list\n\nrule R when\n  Adult( $name: /name[this.length == 3, this != \"George\"] )\nthen\n  list.add( $name );\nend\n", "Bob");
    }

    @Test
    public void testBindStringWithBetaConstraint() {
        String drl = "import org.drools.mvel.compiler.oopath.model.*;\nglobal java.util.List list\n\nrule R when\n  $alice: Adult(name == \"Alice\") \n  Adult( $name: /name[this.length == 3, this != $alice.name] )\nthen\n  list.add( $name );\nend\n";
        this.testScenarioBindString("import org.drools.mvel.compiler.oopath.model.*;\nglobal java.util.List list\n\nrule R when\n  $alice: Adult(name == \"Alice\") \n  Adult( $name: /name[this.length == 3, this != $alice.name] )\nthen\n  list.add( $name );\nend\n", "Bob");
    }

    private void testScenarioBindString(String drl, String ... expectedResults) {
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession ksession = kbase.newKieSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        Man bob = new Man("Bob", 40);
        Woman alice = new Woman("Alice", 38);
        ksession.insert((Object)bob);
        ksession.insert((Object)alice);
        ksession.fireAllRules();
        Assertions.assertThat(list).containsExactlyInAnyOrder((Object[])expectedResults);
    }

    @Test
    public void testBindObjectFromList() {
        String drl = "import org.drools.mvel.compiler.oopath.model.*;\nglobal java.util.List list\n\nrule R when\n  Adult( $child: /children )\nthen\n  list.add( $child.getName() );\nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"import org.drools.mvel.compiler.oopath.model.*;\nglobal java.util.List list\n\nrule R when\n  Adult( $child: /children )\nthen\n  list.add( $child.getName() );\nend\n"});
        KieSession ksession = kbase.newKieSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        Man bob = new Man("Bob", 40);
        bob.addChild(new Child("Charles", 12));
        bob.addChild(new Child("Debbie", 8));
        ksession.insert((Object)bob);
        ksession.fireAllRules();
        Assertions.assertThat(list).containsExactlyInAnyOrder((Object[])new String[]{"Charles", "Debbie"});
    }

    @Test
    public void testBindList() {
        String drl = "import org.drools.mvel.compiler.oopath.model.*;\nglobal java.util.List list\n\nrule R when\n  Man( $toys: /wife/children.toys )\nthen\n  list.add( $toys.size() );\nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"import org.drools.mvel.compiler.oopath.model.*;\nglobal java.util.List list\n\nrule R when\n  Man( $toys: /wife/children.toys )\nthen\n  list.add( $toys.size() );\nend\n"});
        KieSession ksession = kbase.newKieSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        Woman alice = new Woman("Alice", 38);
        Man bob = new Man("Bob", 40);
        bob.setWife(alice);
        Child charlie = new Child("Charles", 12);
        Child debbie = new Child("Debbie", 8);
        alice.addChild(charlie);
        alice.addChild(debbie);
        charlie.addToy(new Toy("car"));
        charlie.addToy(new Toy("ball"));
        debbie.addToy(new Toy("doll"));
        ksession.insert((Object)bob);
        ksession.fireAllRules();
        Assertions.assertThat(list).containsExactlyInAnyOrder((Object[])new Integer[]{1, 2});
    }

    @Test
    public void testBindListWithConstraint() {
        String drl = "import org.drools.mvel.compiler.oopath.model.*;\nglobal java.util.List list\n\nrule R when\n  Man( $toys: /wife/children[age > 10].toys )\nthen\n  list.add( $toys.size() );\nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"import org.drools.mvel.compiler.oopath.model.*;\nglobal java.util.List list\n\nrule R when\n  Man( $toys: /wife/children[age > 10].toys )\nthen\n  list.add( $toys.size() );\nend\n"});
        KieSession ksession = kbase.newKieSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        Woman alice = new Woman("Alice", 38);
        Man bob = new Man("Bob", 40);
        bob.setWife(alice);
        Child charlie = new Child("Charles", 12);
        Child debbie = new Child("Debbie", 8);
        alice.addChild(charlie);
        alice.addChild(debbie);
        charlie.addToy(new Toy("car"));
        charlie.addToy(new Toy("ball"));
        debbie.addToy(new Toy("doll"));
        ksession.insert((Object)bob);
        ksession.fireAllRules();
        Assertions.assertThat(list).containsExactlyInAnyOrder((Object[])new Integer[]{2});
    }
}

