/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.compiler.oopath;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.drools.mvel.compiler.oopath.model.BabyBoy;
import org.drools.mvel.compiler.oopath.model.BabyGirl;
import org.drools.mvel.compiler.oopath.model.Man;
import org.drools.mvel.compiler.oopath.model.Toy;
import org.drools.mvel.compiler.oopath.model.Woman;
import org.drools.testcoverage.common.util.KieBaseTestConfiguration;
import org.drools.testcoverage.common.util.KieBaseUtil;
import org.drools.testcoverage.common.util.KieUtil;
import org.drools.testcoverage.common.util.TestParametersUtil;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.KieBase;
import org.kie.api.builder.KieBuilder;
import org.kie.api.builder.Message;
import org.kie.api.runtime.KieSession;

@RunWith(value=Parameterized.class)
public class OOPathCastTest {
    private final KieBaseTestConfiguration kieBaseTestConfiguration;

    public OOPathCastTest(KieBaseTestConfiguration kieBaseTestConfiguration) {
        this.kieBaseTestConfiguration = kieBaseTestConfiguration;
    }

    @Parameterized.Parameters(name="KieBase type={0}")
    public static Collection<Object[]> getParameters() {
        return TestParametersUtil.getKieBaseCloudConfigurations((boolean)false);
    }

    @Test
    public void testInlineCast() {
        String drl = "import org.drools.mvel.compiler.oopath.model.*;\nglobal java.util.List list\n\nrule R when\n  Man( $toy: /wife/children#BabyGirl/toys )\nthen\n  list.add( $toy.getName() );\nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"import org.drools.mvel.compiler.oopath.model.*;\nglobal java.util.List list\n\nrule R when\n  Man( $toy: /wife/children#BabyGirl/toys )\nthen\n  list.add( $toy.getName() );\nend\n"});
        KieSession ksession = kbase.newKieSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        Woman alice = new Woman("Alice", 38);
        Man bob = new Man("Bob", 40);
        bob.setWife(alice);
        BabyBoy charlie = new BabyBoy("Charles", 12);
        BabyGirl debbie = new BabyGirl("Debbie", 8);
        alice.addChild(charlie);
        alice.addChild(debbie);
        charlie.addToy(new Toy("car"));
        charlie.addToy(new Toy("ball"));
        debbie.addToy(new Toy("doll"));
        ksession.insert((Object)bob);
        ksession.fireAllRules();
        Assertions.assertThat(list).containsExactlyInAnyOrder((Object[])new String[]{"doll"});
    }

    @Test
    public void testInvalidCast() {
        String drl = "import org.drools.mvel.compiler.oopath.model.*;\nglobal java.util.List list\n\nrule R when\n  Man( $toy: /wife/children#Man/toys )\nthen\n  list.add( $toy.getName() );\nend\n";
        KieBuilder kieBuilder = KieUtil.getKieBuilderFromDrls((KieBaseTestConfiguration)this.kieBaseTestConfiguration, (boolean)false, (String[])new String[]{"import org.drools.mvel.compiler.oopath.model.*;\nglobal java.util.List list\n\nrule R when\n  Man( $toy: /wife/children#Man/toys )\nthen\n  list.add( $toy.getName() );\nend\n"});
        List errors = kieBuilder.getResults().getMessages(new Message.Level[]{Message.Level.ERROR});
        Assert.assertFalse((String)"Should have an error", (boolean)errors.isEmpty());
    }

    @Test
    public void testInlineCastWithConstraint() {
        String drl = "import org.drools.mvel.compiler.oopath.model.*;\nglobal java.util.List list\n\nrule R when\n  Man( name == \"Bob\", $name: /wife/children#BabyGirl[ favoriteDollName.startsWith(\"A\") ].name )\nthen\n  list.add( $name );\nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"import org.drools.mvel.compiler.oopath.model.*;\nglobal java.util.List list\n\nrule R when\n  Man( name == \"Bob\", $name: /wife/children#BabyGirl[ favoriteDollName.startsWith(\"A\") ].name )\nthen\n  list.add( $name );\nend\n"});
        KieSession ksession = kbase.newKieSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        Woman alice = new Woman("Alice", 38);
        Man bob = new Man("Bob", 40);
        bob.setWife(alice);
        BabyBoy charlie = new BabyBoy("Charles", 12);
        BabyGirl debbie = new BabyGirl("Debbie", 8, "Anna");
        BabyGirl elisabeth = new BabyGirl("Elisabeth", 5, "Zoe");
        BabyGirl farrah = new BabyGirl("Farrah", 3, "Agatha");
        alice.addChild(charlie);
        alice.addChild(debbie);
        alice.addChild(elisabeth);
        alice.addChild(farrah);
        ksession.insert((Object)bob);
        ksession.fireAllRules();
        Assertions.assertThat(list).containsExactlyInAnyOrder((Object[])new String[]{"Debbie", "Farrah"});
    }
}

