/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.compiler.oopath;

import java.util.ArrayList;
import java.util.Collection;
import org.assertj.core.api.Assertions;
import org.drools.mvel.compiler.oopath.model.Child;
import org.drools.mvel.compiler.oopath.model.Man;
import org.drools.mvel.compiler.oopath.model.Toy;
import org.drools.mvel.compiler.oopath.model.Woman;
import org.drools.testcoverage.common.util.KieBaseTestConfiguration;
import org.drools.testcoverage.common.util.KieBaseUtil;
import org.drools.testcoverage.common.util.TestParametersUtil;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.KieBase;
import org.kie.api.runtime.KieSession;

@RunWith(value=Parameterized.class)
public class OOPathMultilevelTest {
    private final KieBaseTestConfiguration kieBaseTestConfiguration;

    public OOPathMultilevelTest(KieBaseTestConfiguration kieBaseTestConfiguration) {
        this.kieBaseTestConfiguration = kieBaseTestConfiguration;
    }

    @Parameterized.Parameters(name="KieBase type={0}")
    public static Collection<Object[]> getParameters() {
        return TestParametersUtil.getKieBaseCloudConfigurations((boolean)true);
    }

    @Test
    public void testClassTwoLevelPath() {
        String drl = "import org.drools.mvel.compiler.oopath.model.*;\nglobal java.util.List list\n\nrule R when\n  Man( $toy: /wife/children/toys )\nthen\n  list.add( $toy.getName() );\nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"import org.drools.mvel.compiler.oopath.model.*;\nglobal java.util.List list\n\nrule R when\n  Man( $toy: /wife/children/toys )\nthen\n  list.add( $toy.getName() );\nend\n"});
        KieSession ksession = kbase.newKieSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        Woman alice = new Woman("Alice", 38);
        Man bob = new Man("Bob", 40);
        bob.setWife(alice);
        Child charlie = new Child("Charles", 12);
        Child debbie = new Child("Debbie", 8);
        alice.addChild(charlie);
        alice.addChild(debbie);
        charlie.addToy(new Toy("car"));
        charlie.addToy(new Toy("ball"));
        debbie.addToy(new Toy("doll"));
        ksession.insert((Object)bob);
        ksession.fireAllRules();
        Assertions.assertThat(list).containsExactlyInAnyOrder((Object[])new String[]{"car", "ball", "doll"});
    }

    @Test
    public void testClassThreeLevelPath() {
        String drl = "import org.drools.mvel.compiler.oopath.model.*;\nglobal java.util.List list\n\nrule R when\n  Man( $toyName: /wife/children/toys/name )\nthen\n  list.add( $toyName );\nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"import org.drools.mvel.compiler.oopath.model.*;\nglobal java.util.List list\n\nrule R when\n  Man( $toyName: /wife/children/toys/name )\nthen\n  list.add( $toyName );\nend\n"});
        KieSession ksession = kbase.newKieSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        Woman alice = new Woman("Alice", 38);
        Man bob = new Man("Bob", 40);
        bob.setWife(alice);
        Child charlie = new Child("Charles", 12);
        alice.addChild(charlie);
        charlie.addToy(new Toy("car"));
        charlie.addToy(new Toy("ball"));
        ksession.insert((Object)bob);
        ksession.fireAllRules();
        Assertions.assertThat(list).containsExactlyInAnyOrder((Object[])new String[]{"car", "ball"});
    }

    @Test
    public void testClassTwoLevelPathWithAlphaConstraint() {
        String drl = "import org.drools.mvel.compiler.oopath.model.*;\nglobal java.util.List list\n\nrule R when\n  Man( $toy: /wife/children[age > 10, name.length > 5]/toys )\nthen\n  list.add( $toy.getName() );\nend\n";
        this.testScenarioTwoLevelPathWithConstraint("import org.drools.mvel.compiler.oopath.model.*;\nglobal java.util.List list\n\nrule R when\n  Man( $toy: /wife/children[age > 10, name.length > 5]/toys )\nthen\n  list.add( $toy.getName() );\nend\n");
    }

    @Test
    public void testClassTwoLevelPathWithBetaConstraint() {
        String drl = "import org.drools.mvel.compiler.oopath.model.*;\nglobal java.util.List list\n\nrule R when\n  $i : Integer()\n  Man( $toy: /wife/children[age > 10, name.length > $i]/toys )\nthen\n  list.add( $toy.getName() );\nend\n";
        this.testScenarioTwoLevelPathWithConstraint("import org.drools.mvel.compiler.oopath.model.*;\nglobal java.util.List list\n\nrule R when\n  $i : Integer()\n  Man( $toy: /wife/children[age > 10, name.length > $i]/toys )\nthen\n  list.add( $toy.getName() );\nend\n");
    }

    private void testScenarioTwoLevelPathWithConstraint(String drl) {
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession ksession = kbase.newKieSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        Woman alice = new Woman("Alice", 38);
        Man bob = new Man("Bob", 40);
        bob.setWife(alice);
        Child charlie = new Child("Charlie", 12);
        alice.addChild(charlie);
        Child debbie = new Child("Debbie", 8);
        alice.addChild(debbie);
        Child eric = new Child("Eric", 15);
        alice.addChild(eric);
        charlie.addToy(new Toy("car"));
        charlie.addToy(new Toy("ball"));
        debbie.addToy(new Toy("doll"));
        eric.addToy(new Toy("bike"));
        ksession.insert((Object)5);
        ksession.insert((Object)bob);
        ksession.fireAllRules();
        Assertions.assertThat(list).containsExactlyInAnyOrder((Object[])new String[]{"car", "ball"});
    }
}

