/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.compiler.rule.builder;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import org.drools.compiler.rule.builder.XpathAnalysis;
import org.junit.Assert;
import org.junit.Test;

public class XpathAnalysisTest {
    @Test
    public void testEmptyInput() {
        String xpath = "";
        XpathAnalysis result = XpathAnalysis.analyze((String)"");
        Assert.assertEquals((String)"The XPath has to start with '/'.", (Object)true, (Object)result.hasError());
        Assert.assertNotNull((Object)result.getError());
        Assert.assertEquals((Object)false, (Object)result.iterator().hasNext());
    }

    @Test
    public void testNotAnXPath() {
        String xpath = "someAttribute";
        XpathAnalysis result = XpathAnalysis.analyze((String)"someAttribute");
        Assert.assertEquals((String)"The XPath has to start with '/'.", (Object)true, (Object)result.hasError());
        Assert.assertNotNull((Object)result.getError());
        Assert.assertEquals((Object)false, (Object)result.iterator().hasNext());
    }

    @Test
    public void testEmptyXPath() {
        String xpath = "/";
        XpathAnalysis result = XpathAnalysis.analyze((String)"/");
        Assert.assertEquals((String)"The empty XPath should be valid.", (Object)false, (Object)result.hasError());
        Assert.assertNull((Object)result.getError());
        Iterator<XpathAnalysis.XpathPart> iterator = this.getNonEmptyIterator(result);
        this.verifyXpathPart(new XpathAnalysis.XpathPart("", true, false, new ArrayList(), null, -1, 0), iterator.next());
        Assert.assertEquals((Object)false, (Object)iterator.hasNext());
    }

    @Test
    public void testEmptyNonReactiveXPath() {
        String xpath = "?/";
        XpathAnalysis result = XpathAnalysis.analyze((String)"?/");
        Assert.assertEquals((String)"The empty XPath should be valid.", (Object)false, (Object)result.hasError());
        Assert.assertNull((Object)result.getError());
        Iterator<XpathAnalysis.XpathPart> iterator = this.getNonEmptyIterator(result);
        this.verifyXpathPart(new XpathAnalysis.XpathPart("", true, true, new ArrayList(), null, -1, 0), iterator.next());
        Assert.assertEquals((Object)false, (Object)iterator.hasNext());
    }

    @Test
    public void testAttribute() {
        String xpath = "/address";
        XpathAnalysis result = XpathAnalysis.analyze((String)"/address");
        Assert.assertEquals((String)"The XPath should be valid.", (Object)false, (Object)result.hasError());
        Assert.assertNull((Object)result.getError());
        Iterator<XpathAnalysis.XpathPart> iterator = this.getNonEmptyIterator(result);
        this.verifyXpathPart(new XpathAnalysis.XpathPart("address", true, false, new ArrayList(), null, -1, 0), iterator.next());
        Assert.assertEquals((Object)false, (Object)iterator.hasNext());
    }

    @Test
    public void testAttributeIterate() {
        String xpath = "/address/";
        XpathAnalysis result = XpathAnalysis.analyze((String)"/address/");
        Assert.assertEquals((String)"The XPath should be valid.", (Object)false, (Object)result.hasError());
        Assert.assertNull((Object)result.getError());
        Iterator<XpathAnalysis.XpathPart> iterator = this.getNonEmptyIterator(result);
        this.verifyXpathPart(new XpathAnalysis.XpathPart("address", true, false, new ArrayList(), null, -1, 0), iterator.next());
        this.verifyXpathPart(new XpathAnalysis.XpathPart("", true, false, new ArrayList(), null, -1, 0), iterator.next());
        Assert.assertEquals((Object)false, (Object)iterator.hasNext());
    }

    @Test
    public void testAttributeDereferenceDot() {
        String xpath = "/address.";
        XpathAnalysis result = XpathAnalysis.analyze((String)"/address.");
        Assert.assertEquals((String)"The XPath should be valid.", (Object)false, (Object)result.hasError());
        Assert.assertNull((Object)result.getError());
        Iterator<XpathAnalysis.XpathPart> iterator = this.getNonEmptyIterator(result);
        this.verifyXpathPart(new XpathAnalysis.XpathPart("address", true, false, new ArrayList(), null, -1, 0), iterator.next());
        this.verifyXpathPart(new XpathAnalysis.XpathPart("", false, false, new ArrayList(), null, -1, 0), iterator.next());
        Assert.assertEquals((Object)false, (Object)iterator.hasNext());
    }

    @Test
    public void testAttributeDereferenceMixed() {
        String xpath = "/address.street/name";
        XpathAnalysis result = XpathAnalysis.analyze((String)"/address.street/name");
        Assert.assertEquals((String)"The XPath should be valid.", (Object)false, (Object)result.hasError());
        Assert.assertNull((Object)result.getError());
        Iterator<XpathAnalysis.XpathPart> iterator = this.getNonEmptyIterator(result);
        this.verifyXpathPart(new XpathAnalysis.XpathPart("address", true, false, new ArrayList(), null, -1, 0), iterator.next());
        this.verifyXpathPart(new XpathAnalysis.XpathPart("street", false, false, new ArrayList(), null, -1, 0), iterator.next());
        this.verifyXpathPart(new XpathAnalysis.XpathPart("name", true, false, new ArrayList(), null, -1, 0), iterator.next());
        Assert.assertEquals((Object)false, (Object)iterator.hasNext());
    }

    @Test
    public void testAttributeDereferenceMixedIterate() {
        String xpath = "/address.street/name/";
        XpathAnalysis result = XpathAnalysis.analyze((String)"/address.street/name/");
        Assert.assertEquals((String)"The XPath should be valid.", (Object)false, (Object)result.hasError());
        Assert.assertNull((Object)result.getError());
        Iterator<XpathAnalysis.XpathPart> iterator = this.getNonEmptyIterator(result);
        this.verifyXpathPart(new XpathAnalysis.XpathPart("address", true, false, new ArrayList(), null, -1, 0), iterator.next());
        this.verifyXpathPart(new XpathAnalysis.XpathPart("street", false, false, new ArrayList(), null, -1, 0), iterator.next());
        this.verifyXpathPart(new XpathAnalysis.XpathPart("name", true, false, new ArrayList(), null, -1, 0), iterator.next());
        this.verifyXpathPart(new XpathAnalysis.XpathPart("", true, false, new ArrayList(), null, -1, 0), iterator.next());
        Assert.assertEquals((Object)false, (Object)iterator.hasNext());
    }

    @Test
    public void testRelativePathInCondition() {
        String xpath = "/address.street[../city == \"The City\"]/name/";
        XpathAnalysis result = XpathAnalysis.analyze((String)"/address.street[../city == \"The City\"]/name/");
        Assert.assertEquals((String)"The XPath should be valid.", (Object)false, (Object)result.hasError());
        Assert.assertNull((Object)result.getError());
        Iterator<XpathAnalysis.XpathPart> iterator = this.getNonEmptyIterator(result);
        this.verifyXpathPart(new XpathAnalysis.XpathPart("address", true, false, new ArrayList(), null, -1, 0), iterator.next());
        this.verifyXpathPart(new XpathAnalysis.XpathPart("street", false, false, new ArrayList<String>(Arrays.asList("../city == \"The City\"")), null, -1, 0), iterator.next());
        this.verifyXpathPart(new XpathAnalysis.XpathPart("name", true, false, new ArrayList(), null, -1, 0), iterator.next());
        this.verifyXpathPart(new XpathAnalysis.XpathPart("", true, false, new ArrayList(), null, -1, 0), iterator.next());
        Assert.assertEquals((Object)false, (Object)iterator.hasNext());
    }

    @Test
    public void testUnicode() {
        String xpath = "/address.uli\u010dka[name == '\u011b\u0161\u010d\u0159\u017e\u00fd\u00e1\u00ed\u00e9']/";
        XpathAnalysis result = XpathAnalysis.analyze((String)"/address.uli\u010dka[name == '\u011b\u0161\u010d\u0159\u017e\u00fd\u00e1\u00ed\u00e9']/");
        Assert.assertEquals((String)"The XPath should be valid.", (Object)false, (Object)result.hasError());
        Assert.assertNull((Object)result.getError());
        Iterator<XpathAnalysis.XpathPart> iterator = this.getNonEmptyIterator(result);
        this.verifyXpathPart(new XpathAnalysis.XpathPart("address", true, false, new ArrayList(), null, -1, 0), iterator.next());
        this.verifyXpathPart(new XpathAnalysis.XpathPart("uli\u010dka", false, false, new ArrayList<String>(Arrays.asList("name == '\u011b\u0161\u010d\u0159\u017e\u00fd\u00e1\u00ed\u00e9'")), null, -1, 0), iterator.next());
        this.verifyXpathPart(new XpathAnalysis.XpathPart("", true, false, new ArrayList(), null, -1, 0), iterator.next());
        Assert.assertEquals((Object)false, (Object)iterator.hasNext());
    }

    @Test
    public void testIndex() {
        String xpath = "/address[0]";
        XpathAnalysis result = XpathAnalysis.analyze((String)"/address[0]");
        Assert.assertEquals((String)"The XPath should be valid.", (Object)false, (Object)result.hasError());
        Assert.assertNull((Object)result.getError());
        Iterator<XpathAnalysis.XpathPart> iterator = this.getNonEmptyIterator(result);
        this.verifyXpathPart(new XpathAnalysis.XpathPart("address", true, false, new ArrayList(), null, 0, 0), iterator.next());
        Assert.assertEquals((Object)false, (Object)iterator.hasNext());
    }

    @Test
    public void testIndexIterate() {
        String xpath = "/address[0]/";
        XpathAnalysis result = XpathAnalysis.analyze((String)"/address[0]/");
        Assert.assertEquals((String)"The XPath should be valid.", (Object)false, (Object)result.hasError());
        Assert.assertNull((Object)result.getError());
        Iterator<XpathAnalysis.XpathPart> iterator = this.getNonEmptyIterator(result);
        this.verifyXpathPart(new XpathAnalysis.XpathPart("address", true, false, new ArrayList(), null, 0, 0), iterator.next());
        this.verifyXpathPart(new XpathAnalysis.XpathPart("", true, false, new ArrayList(), null, -1, 0), iterator.next());
        Assert.assertEquals((Object)false, (Object)iterator.hasNext());
    }

    @Test
    public void testCondition() {
        String xpath = "/address/street[name == \"Elm\"]";
        XpathAnalysis result = XpathAnalysis.analyze((String)"/address/street[name == \"Elm\"]");
        Assert.assertEquals((String)"The XPath should be valid.", (Object)false, (Object)result.hasError());
        Assert.assertNull((Object)result.getError());
        Iterator<XpathAnalysis.XpathPart> iterator = this.getNonEmptyIterator(result);
        this.verifyXpathPart(new XpathAnalysis.XpathPart("address", true, false, new ArrayList(), null, -1, 0), iterator.next());
        this.verifyXpathPart(new XpathAnalysis.XpathPart("street", true, false, new ArrayList<String>(Arrays.asList("name == \"Elm\"")), null, -1, 0), iterator.next());
        Assert.assertEquals((Object)false, (Object)iterator.hasNext());
    }

    @Test
    public void testThreeConditions() {
        String xpath = "/address/street[name == \"Elm\", length <= 10, code == \"Something, \\\"and\\\" other thing\"]";
        XpathAnalysis result = XpathAnalysis.analyze((String)"/address/street[name == \"Elm\", length <= 10, code == \"Something, \\\"and\\\" other thing\"]");
        Assert.assertEquals((String)"The XPath should be valid.", (Object)false, (Object)result.hasError());
        Assert.assertNull((Object)result.getError());
        Iterator<XpathAnalysis.XpathPart> iterator = this.getNonEmptyIterator(result);
        this.verifyXpathPart(new XpathAnalysis.XpathPart("address", true, false, new ArrayList(), null, -1, 0), iterator.next());
        this.verifyXpathPart(new XpathAnalysis.XpathPart("street", true, false, new ArrayList<String>(Arrays.asList("name == \"Elm\"", "length <= 10", "code == \"Something, \\\"and\\\" other thing\"")), null, -1, 0), iterator.next());
        Assert.assertEquals((Object)false, (Object)iterator.hasNext());
    }

    @Test
    public void testConditionIterate() {
        String xpath = "/address/street[name == \"Elm\"]/";
        XpathAnalysis result = XpathAnalysis.analyze((String)"/address/street[name == \"Elm\"]/");
        Assert.assertEquals((String)"The XPath should be valid.", (Object)false, (Object)result.hasError());
        Assert.assertNull((Object)result.getError());
        Iterator<XpathAnalysis.XpathPart> iterator = this.getNonEmptyIterator(result);
        this.verifyXpathPart(new XpathAnalysis.XpathPart("address", true, false, new ArrayList(), null, -1, 0), iterator.next());
        this.verifyXpathPart(new XpathAnalysis.XpathPart("street", true, false, new ArrayList<String>(Arrays.asList("name == \"Elm\"")), null, -1, 0), iterator.next());
        this.verifyXpathPart(new XpathAnalysis.XpathPart("", true, false, new ArrayList(), null, -1, 0), iterator.next());
        Assert.assertEquals((Object)false, (Object)iterator.hasNext());
    }

    @Test
    public void testBasicCast() {
        String xpath = "/address/street#MyStreetType[name.value == \"Elm\"].city";
        XpathAnalysis result = XpathAnalysis.analyze((String)"/address/street#MyStreetType[name.value == \"Elm\"].city");
        Assert.assertEquals((String)"The XPath should be valid.", (Object)false, (Object)result.hasError());
        Assert.assertNull((Object)result.getError());
        Iterator<XpathAnalysis.XpathPart> iterator = this.getNonEmptyIterator(result);
        this.verifyXpathPart(new XpathAnalysis.XpathPart("address", true, false, new ArrayList(), null, -1, 0), iterator.next());
        this.verifyXpathPart(new XpathAnalysis.XpathPart("street", true, false, new ArrayList<String>(Arrays.asList("name.value == \"Elm\"")), "MyStreetType", -1, 0), iterator.next());
        this.verifyXpathPart(new XpathAnalysis.XpathPart("city", false, false, new ArrayList(), null, -1, 0), iterator.next());
        Assert.assertEquals((Object)false, (Object)iterator.hasNext());
    }

    @Test
    public void testComplexCast() {
        String xpath = "/address/street#MyStreetType[name.value == \"Elm\"].city#MyCityMoreSpecificType[ value ]";
        XpathAnalysis result = XpathAnalysis.analyze((String)"/address/street#MyStreetType[name.value == \"Elm\"].city#MyCityMoreSpecificType[ value ]");
        Assert.assertEquals((String)"The XPath should be valid.", (Object)false, (Object)result.hasError());
        Assert.assertNull((Object)result.getError());
        Iterator<XpathAnalysis.XpathPart> iterator = this.getNonEmptyIterator(result);
        this.verifyXpathPart(new XpathAnalysis.XpathPart("address", true, false, new ArrayList(), null, -1, 0), iterator.next());
        this.verifyXpathPart(new XpathAnalysis.XpathPart("street", true, false, new ArrayList<String>(Arrays.asList("name.value == \"Elm\"")), "MyStreetType", -1, 0), iterator.next());
        this.verifyXpathPart(new XpathAnalysis.XpathPart("city", false, false, new ArrayList<String>(Arrays.asList("value")), "MyCityMoreSpecificType", -1, 0), iterator.next());
        Assert.assertEquals((Object)false, (Object)iterator.hasNext());
    }

    private Iterator<XpathAnalysis.XpathPart> getNonEmptyIterator(XpathAnalysis analysis) {
        Iterator iterator = analysis.iterator();
        Assert.assertEquals((Object)true, (Object)iterator.hasNext());
        return iterator;
    }

    private void verifyXpathPart(XpathAnalysis.XpathPart expected, XpathAnalysis.XpathPart actual) {
        if (expected == null) {
            Assert.assertNull((Object)actual);
        } else {
            Assert.assertNotNull((Object)actual);
        }
        Assert.assertEquals((Object)expected.getField(), (Object)actual.getField());
        Assert.assertEquals((Object)expected.isIterate(), (Object)actual.isIterate());
        Assert.assertEquals((Object)expected.isLazy(), (Object)actual.isLazy());
        Assert.assertEquals((Object)expected.getInlineCast(), (Object)actual.getInlineCast());
        Assert.assertEquals((long)expected.getIndex(), (long)actual.getIndex());
        Assert.assertArrayEquals((Object[])expected.getConstraints().toArray(), (Object[])actual.getConstraints().toArray());
    }
}

