/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.compiler.rule.builder.dialect.java;

import java.util.Collection;
import java.util.List;
import org.drools.core.base.ClassObjectType;
import org.drools.core.impl.KnowledgeBaseImpl;
import org.drools.core.reteoo.AlphaNode;
import org.drools.core.reteoo.BetaNode;
import org.drools.core.reteoo.ObjectTypeNode;
import org.drools.core.rule.PredicateConstraint;
import org.drools.core.spi.AlphaNodeFieldConstraint;
import org.drools.core.spi.BetaNodeFieldConstraint;
import org.drools.core.spi.CompiledInvoker;
import org.drools.core.spi.FieldValue;
import org.drools.core.spi.PredicateExpression;
import org.drools.mvel.MVELConstraint;
import org.drools.mvel.compiler.Person;
import org.drools.testcoverage.common.util.KieBaseTestConfiguration;
import org.drools.testcoverage.common.util.KieBaseUtil;
import org.drools.testcoverage.common.util.TestParametersUtil;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.KieBase;

@RunWith(value=Parameterized.class)
public class JavaDialectTest {
    private final KieBaseTestConfiguration kieBaseTestConfiguration;

    public JavaDialectTest(KieBaseTestConfiguration kieBaseTestConfiguration) {
        this.kieBaseTestConfiguration = kieBaseTestConfiguration;
    }

    @Parameterized.Parameters(name="KieBase type={0}")
    public static Collection<Object[]> getParameters() {
        return TestParametersUtil.getKieBaseCloudConfigurations((boolean)false);
    }

    @Test
    public void testEvalDetectionInAlphaNode() {
        String drl = "";
        drl = drl + "package org.drools.mvel.compiler.test\n";
        drl = drl + "import " + Person.class.getCanonicalName() + "\n";
        drl = drl + "global java.util.List list\n";
        drl = drl + "rule test1\n";
        drl = drl + "when\n";
        drl = drl + "   $p1 : Person( eval( name \n != null ), name == ( new String(\"xxx\") ) )\n";
        drl = drl + "then\n";
        drl = drl + "end\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        List nodes = ((KnowledgeBaseImpl)kbase).getRete().getObjectTypeNodes();
        ObjectTypeNode node = null;
        for (ObjectTypeNode n : nodes) {
            if (((ClassObjectType)n.getObjectType()).getClassType() != Person.class) continue;
            node = n;
            break;
        }
        AlphaNode alphanode = (AlphaNode)node.getObjectSinkPropagator().getSinks()[0];
        PredicateConstraint c = (PredicateConstraint)alphanode.getConstraint();
        Assert.assertTrue((boolean)(c.getPredicateExpression() instanceof PredicateExpression));
        Assert.assertTrue((boolean)(c.getPredicateExpression() instanceof CompiledInvoker));
        alphanode = (AlphaNode)alphanode.getObjectSinkPropagator().getSinks()[0];
        AlphaNodeFieldConstraint constraint = alphanode.getConstraint();
        if (constraint instanceof MVELConstraint) {
            FieldValue fieldVal = ((MVELConstraint)constraint).getField();
            Assert.assertEquals((Object)"xxx", (Object)fieldVal.getValue());
        }
    }

    @Test
    public void testEvalDetectionInBetaNode() {
        String drl = "";
        drl = drl + "package org.drools.mvel.compiler.test\n";
        drl = drl + "import " + Person.class.getCanonicalName() + "\n";
        drl = drl + "global java.util.List list\n";
        drl = drl + "rule test1\n";
        drl = drl + "when\n";
        drl = drl + "   $s  : String()\n";
        drl = drl + "   $p1 : Person( eval( name \n != $s ), name == ( new String($s+\"xxx\") ) )\n";
        drl = drl + "then\n";
        drl = drl + "end\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        List nodes = ((KnowledgeBaseImpl)kbase).getRete().getObjectTypeNodes();
        ObjectTypeNode node = null;
        for (ObjectTypeNode n : nodes) {
            if (((ClassObjectType)n.getObjectType()).getClassType() != Person.class) continue;
            node = n;
            break;
        }
        BetaNode betaanode = (BetaNode)node.getObjectSinkPropagator().getSinks()[0];
        BetaNodeFieldConstraint[] constraint = betaanode.getConstraints();
        PredicateConstraint c = (PredicateConstraint)constraint[0];
        Assert.assertTrue((boolean)(c.getPredicateExpression() instanceof PredicateExpression));
        Assert.assertTrue((boolean)(c.getPredicateExpression() instanceof CompiledInvoker));
    }
}

