/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.compiler.test;

import org.drools.mvel.compiler.test.Person;
import org.kie.api.definition.type.Position;

public class Man
extends Person {
    @Position(value=1)
    private int age;
    @Position(value=2)
    private double weight;

    public Man() {
    }

    public Man(String name, int age, double weight) {
        super(name);
        this.age = age;
        this.weight = weight;
    }

    public int getAge() {
        return this.age;
    }

    public void setAge(int age) {
        this.age = age;
    }

    public double getWeight() {
        return this.weight;
    }

    public void setWeight(double weight) {
        this.weight = weight;
    }

    public String toString() {
        return "Man{name='" + this.getName() + '\'' + ", age=" + this.age + ", weight=" + this.weight + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Man man = (Man)o;
        if (this.age != man.age) {
            return false;
        }
        if (Double.compare(man.weight, this.weight) != 0) {
            return false;
        }
        return !(this.getName() != null ? !this.getName().equals(man.getName()) : man.getName() != null);
    }

    public int hashCode() {
        int result = this.getName() != null ? this.getName().hashCode() : 0;
        result = 31 * result + this.age;
        long temp = this.weight != 0.0 ? Double.doubleToLongBits(this.weight) : 0L;
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }
}

