/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.integrationtests;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.drools.testcoverage.common.util.KieBaseTestConfiguration;
import org.drools.testcoverage.common.util.KieBaseUtil;
import org.drools.testcoverage.common.util.KieUtil;
import org.drools.testcoverage.common.util.TestParametersUtil;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.KieBase;
import org.kie.api.KieServices;
import org.kie.api.builder.KieBuilder;
import org.kie.api.builder.KieFileSystem;
import org.kie.api.builder.model.KieBaseModel;
import org.kie.api.builder.model.KieModuleModel;
import org.kie.api.conf.EventProcessingOption;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.conf.ClockTypeOption;
import org.kie.api.runtime.rule.QueryResults;
import org.kie.api.time.SessionPseudoClock;
import org.kie.internal.io.ResourceFactory;

@RunWith(value=Parameterized.class)
public class QueryInRHSCepTest {
    private final KieBaseTestConfiguration kieBaseTestConfiguration;
    private KieSession ksession;
    private SessionPseudoClock clock;
    private List<?> myGlobal;

    public QueryInRHSCepTest(KieBaseTestConfiguration kieBaseTestConfiguration) {
        this.kieBaseTestConfiguration = kieBaseTestConfiguration;
    }

    @Parameterized.Parameters(name="KieBase type={0}")
    public static Collection<Object[]> getParameters() {
        return TestParametersUtil.getKieBaseStreamConfigurations((boolean)true);
    }

    private void prepare1() {
        String drl = "package org.drools.mvel.integrationtests\nimport " + SolicitFirePojo.class.getCanonicalName() + "\nimport " + QueryItemPojo.class.getCanonicalName() + "\nglobal java.util.List myGlobal \ndeclare SolicitFirePojo\n    @role( event )\nend\nquery \"myQuery\"\n    $r : QueryItemPojo()\nend\nrule \"drools-usage/WLHxG8S\"\n no-loop\n when\n SolicitFirePojo()\n then\n myGlobal.add(drools.getKieRuntime().getQueryResults(\"myQuery\"));\n end\n";
        KieServices ks = KieServices.Factory.get();
        KieFileSystem kfs = ks.newKieFileSystem();
        KieModuleModel kmodule = ks.newKieModuleModel();
        KieBaseModel baseModel = kmodule.newKieBaseModel("defaultKBase").setDefault(true).setEventProcessingMode(EventProcessingOption.STREAM);
        baseModel.newKieSessionModel("defaultKSession").setDefault(true).setClockType(ClockTypeOption.PSEUDO);
        kfs.writeKModuleXML(kmodule.toXML());
        kfs.write(ResourceFactory.newByteArrayResource((byte[])drl.getBytes()).setTargetPath("org/drools/compiler/integrationtests/" + this.getClass().getName() + ".drl"));
        KieBuilder kieBuilder = KieUtil.getKieBuilderFromKieFileSystem((KieBaseTestConfiguration)this.kieBaseTestConfiguration, (KieFileSystem)kfs, (boolean)true);
        this.ksession = ks.newKieContainer(ks.getRepository().getDefaultReleaseId()).newKieSession();
        this.clock = (SessionPseudoClock)this.ksession.getSessionClock();
        this.myGlobal = new ArrayList();
        this.ksession.setGlobal("myGlobal", this.myGlobal);
    }

    @Test
    public void withResultOfSize1Test() {
        this.prepare1();
        this.clock.advanceTime(1L, TimeUnit.SECONDS);
        this.ksession.insert((Object)new QueryItemPojo());
        this.ksession.insert((Object)new SolicitFirePojo());
        int fired = this.ksession.fireAllRules();
        Assert.assertEquals((long)1L, (long)fired);
        Assert.assertEquals((long)1L, (long)this.myGlobal.size());
        Assert.assertEquals((long)1L, (long)((QueryResults)this.myGlobal.get(0)).size());
    }

    @Test
    public void withResultOfSize1AnotherTest() {
        this.prepare1();
        this.clock.advanceTime(1L, TimeUnit.SECONDS);
        this.ksession.insert((Object)new SolicitFirePojo());
        this.ksession.insert((Object)new QueryItemPojo());
        int fired = this.ksession.fireAllRules();
        Assert.assertEquals((long)1L, (long)fired);
        Assert.assertEquals((long)1L, (long)this.myGlobal.size());
        Assert.assertEquals((long)1L, (long)((QueryResults)this.myGlobal.get(0)).size());
    }

    @Test
    public void withResultOfSize0Test() {
        this.prepare1();
        this.clock.advanceTime(1L, TimeUnit.SECONDS);
        this.ksession.insert((Object)new SolicitFirePojo());
        int fired = this.ksession.fireAllRules();
        Assert.assertEquals((long)1L, (long)fired);
        Assert.assertEquals((long)1L, (long)this.myGlobal.size());
        Assert.assertEquals((long)0L, (long)((QueryResults)this.myGlobal.get(0)).size());
    }

    @Test
    public void withInsertBeforeQueryCloudTest() {
        String drl = "package org.drools.mvel.integrationtests\nimport " + SolicitFirePojo.class.getCanonicalName() + "\nimport " + QueryItemPojo.class.getCanonicalName() + "\nglobal java.util.List myGlobal \nquery \"myQuery\"\n    $r : QueryItemPojo()\nend\nrule \"drools-usage/WLHxG8S\"\n no-loop\n when\n SolicitFirePojo()\n then\n insert(new QueryItemPojo());\n myGlobal.add(drools.getKieRuntime().getQueryResults(\"myQuery\"));\n end\n";
        KieServices ks = KieServices.Factory.get();
        KieFileSystem kfs = ks.newKieFileSystem();
        KieModuleModel kmodule = ks.newKieModuleModel();
        KieBaseModel baseModel = kmodule.newKieBaseModel("defaultKBase").setDefault(true).setEventProcessingMode(EventProcessingOption.CLOUD);
        baseModel.newKieSessionModel("defaultKSession").setDefault(true);
        kfs.writeKModuleXML(kmodule.toXML());
        kfs.write(ResourceFactory.newByteArrayResource((byte[])drl.getBytes()).setTargetPath("org/drools/compiler/integrationtests/" + this.getClass().getName() + ".drl"));
        KieBuilder kieBuilder = KieUtil.getKieBuilderFromKieFileSystem((KieBaseTestConfiguration)this.kieBaseTestConfiguration, (KieFileSystem)kfs, (boolean)true);
        this.ksession = ks.newKieContainer(ks.getRepository().getDefaultReleaseId()).newKieSession();
        this.myGlobal = new ArrayList();
        this.ksession.setGlobal("myGlobal", this.myGlobal);
        this.ksession.insert((Object)new QueryItemPojo());
        this.ksession.insert((Object)new SolicitFirePojo());
        int fired = this.ksession.fireAllRules();
        Assert.assertEquals((long)1L, (long)fired);
        Assert.assertEquals((long)1L, (long)this.myGlobal.size());
        Assert.assertEquals((long)2L, (long)((QueryResults)this.myGlobal.get(0)).size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=10000L)
    public void testParallelQueryCallFromRuleAndAPI() {
        String drl = "global java.util.List myGlobal \nquery \"myQuery\"\n    $r : String()\nend\nrule R when\n  $i : Integer()\nthen\n  insert($i.toString());\n  myGlobal.add(drools.getKieRuntime().getQueryResults(\"myQuery\"));\nend\n";
        this.kieBaseTestConfiguration.setStreamMode(false);
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession kSession = kbase.newKieSession();
        this.myGlobal = new ArrayList();
        kSession.setGlobal("myGlobal", this.myGlobal);
        int threadCount = 4;
        int iterations = 1000;
        ExecutorService executor = Executors.newFixedThreadPool(threadCount);
        try {
            Callable[] tasks = new Callable[threadCount];
            for (int i = 0; i < threadCount; ++i) {
                tasks[i] = this.createTask(kSession, iterations);
            }
            ExecutorCompletionService ecs = new ExecutorCompletionService(executor);
            for (Callable task : tasks) {
                ecs.submit(task);
            }
            for (int i = 1; i <= iterations; ++i) {
                kSession.insert((Object)i);
                kSession.fireAllRules();
                Assert.assertEquals((long)1L, (long)this.myGlobal.size());
                Assert.assertEquals((long)i, (long)((QueryResults)this.myGlobal.get(0)).size());
                this.myGlobal.clear();
            }
            int successCounter = 0;
            for (int i = 0; i < threadCount; ++i) {
                try {
                    if (!((Boolean)ecs.take().get()).booleanValue()) continue;
                    ++successCounter;
                    continue;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            Assert.assertEquals((long)successCounter, (long)threadCount);
        }
        finally {
            kSession.dispose();
            executor.shutdownNow();
        }
    }

    private Callable<Boolean> createTask(KieSession kSession, int iterations) {
        return () -> {
            int currentValue = 0;
            for (int i = 0; i < iterations; ++i) {
                QueryResults queryResults = kSession.getQueryResults("myQuery", new Object[0]);
                int newValue = queryResults.size();
                if (newValue < currentValue) {
                    return false;
                }
                currentValue = newValue;
            }
            return true;
        };
    }

    public static class SolicitFirePojo {
    }

    public static class QueryItemPojo {
    }
}

