/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.integrationtests.concurrency;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.assertj.core.api.Assertions;
import org.drools.mvel.integrationtests.concurrency.AbstractConcurrentTest;
import org.drools.mvel.integrationtests.facts.AnEnum;
import org.drools.mvel.integrationtests.facts.FactWithBigDecimal;
import org.drools.mvel.integrationtests.facts.FactWithBoolean;
import org.drools.mvel.integrationtests.facts.FactWithByte;
import org.drools.mvel.integrationtests.facts.FactWithCharacter;
import org.drools.mvel.integrationtests.facts.FactWithDouble;
import org.drools.mvel.integrationtests.facts.FactWithEnum;
import org.drools.mvel.integrationtests.facts.FactWithFloat;
import org.drools.mvel.integrationtests.facts.FactWithInteger;
import org.drools.mvel.integrationtests.facts.FactWithLong;
import org.drools.mvel.integrationtests.facts.FactWithShort;
import org.drools.mvel.integrationtests.facts.FactWithString;
import org.drools.testcoverage.common.util.KieBaseTestConfiguration;
import org.drools.testcoverage.common.util.TestParametersUtil;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class DataTypeEvaluationConcurrentSessionsTest
extends AbstractConcurrentTest {
    private static final Integer NUMBER_OF_THREADS = 10;
    private static final Integer NUMBER_OF_REPETITIONS = 1;

    @Parameterized.Parameters(name="Enforced jitting={0}, Share KieBase={1}, Share KieSession={2}, KieBase type={3}")
    public static List<Object[]> getTestParameters() {
        List<Boolean[]> baseParams = Arrays.asList({false, false, false}, {true, false, false}, {false, true, false}, {true, true, false}, {false, false, true}, {true, false, true}, {false, true, true}, {true, true, true});
        Collection kbParams = TestParametersUtil.getKieBaseCloudConfigurations((boolean)false);
        ArrayList<Object[]> params = new ArrayList<Object[]>();
        for (Boolean[] baseParam : baseParams) {
            for (Object[] kbParam : kbParams) {
                if (baseParam[0].booleanValue() && ((KieBaseTestConfiguration)kbParam[0]).isExecutabelModel()) continue;
                params.add(new Object[]{baseParam[0], baseParam[1], baseParam[2], kbParam[0]});
            }
        }
        return params;
    }

    public DataTypeEvaluationConcurrentSessionsTest(boolean enforcedJitting, boolean sharedKieBase, boolean sharedKieSession, KieBaseTestConfiguration kieBaseTestConfiguration) {
        super(enforcedJitting, false, sharedKieBase, sharedKieSession, kieBaseTestConfiguration);
    }

    @Test(timeout=40000L)
    public void testBooleanPrimitive() throws InterruptedException {
        this.testFactAttributeType("    $factWithBoolean: FactWithBoolean(booleanValue == false) \n", new FactWithBoolean(false));
    }

    @Test(timeout=40000L)
    public void testBoolean() throws InterruptedException {
        this.testFactAttributeType("    $factWithBoolean: FactWithBoolean(booleanObjectValue == false) \n", new FactWithBoolean(false));
    }

    @Test(timeout=40000L)
    public void testBytePrimitive() throws InterruptedException {
        this.testFactAttributeType("    $factWithByte: FactWithByte(byteValue == 15) \n", new FactWithByte(15));
    }

    @Test(timeout=40000L)
    public void testByte() throws InterruptedException {
        this.testFactAttributeType("    $factWithByte: FactWithByte(byteObjectValue == 15) \n", new FactWithByte(15));
    }

    @Test(timeout=40000L)
    public void testShortPrimitive() throws InterruptedException {
        this.testFactAttributeType("    $factWithShort: FactWithShort(shortValue == 15) \n", new FactWithShort(15));
    }

    @Test(timeout=40000L)
    public void testShort() throws InterruptedException {
        this.testFactAttributeType("    $factWithShort: FactWithShort(shortObjectValue == 15) \n", new FactWithShort(15));
    }

    @Test(timeout=40000L)
    public void testIntPrimitive() throws InterruptedException {
        this.testFactAttributeType("    $factWithInt: FactWithInteger(intValue == 15) \n", new FactWithInteger(15));
    }

    @Test(timeout=40000L)
    public void testInteger() throws InterruptedException {
        this.testFactAttributeType("    $factWithInteger: FactWithInteger(integerValue == 15) \n", new FactWithInteger(15));
    }

    @Test(timeout=40000L)
    public void testLongPrimitive() throws InterruptedException {
        this.testFactAttributeType("    $factWithLong: FactWithLong(longValue == 15) \n", new FactWithLong(15L));
    }

    @Test(timeout=40000L)
    public void testLong() throws InterruptedException {
        this.testFactAttributeType("    $factWithLong: FactWithLong(longObjectValue == 15) \n", new FactWithLong(15L));
    }

    @Test(timeout=40000L)
    public void testFloatPrimitive() throws InterruptedException {
        this.testFactAttributeType("    $factWithFloat: FactWithFloat(floatValue == 15.1) \n", new FactWithFloat(15.1f));
    }

    @Test(timeout=40000L)
    public void testFloat() throws InterruptedException {
        this.testFactAttributeType("    $factWithFloat: FactWithFloat(floatObjectValue == 15.1) \n", new FactWithFloat(15.1f));
    }

    @Test(timeout=40000L)
    public void testDoublePrimitive() throws InterruptedException {
        this.testFactAttributeType("    $factWithDouble: FactWithDouble(doubleValue == 15.1) \n", new FactWithDouble(15.1));
    }

    @Test(timeout=40000L)
    public void testDouble() throws InterruptedException {
        this.testFactAttributeType("    $factWithDouble: FactWithDouble(doubleObjectValue == 15.1) \n", new FactWithDouble(15.1));
    }

    @Test(timeout=40000L)
    public void testBigDecimal() throws InterruptedException {
        this.testFactAttributeType("    $factWithBigDecimal: FactWithBigDecimal(bigDecimalValue == 10) \n", new FactWithBigDecimal(BigDecimal.TEN));
    }

    @Test(timeout=40000L)
    public void testCharPrimitive() throws InterruptedException {
        this.testFactAttributeType("    $factWithChar: FactWithCharacter(charValue == 'a') \n", new FactWithCharacter('a'));
    }

    @Test(timeout=40000L)
    public void testCharacter() throws InterruptedException {
        this.testFactAttributeType("    $factWithChar: FactWithCharacter(characterValue == 'a') \n", new FactWithCharacter('a'));
    }

    @Test(timeout=40000L)
    public void testString() throws InterruptedException {
        this.testFactAttributeType("    $factWithString: FactWithString(stringValue == \"test\") \n", new FactWithString("test"));
    }

    @Test(timeout=40000L)
    public void testEnum() throws InterruptedException {
        this.testFactAttributeType("    $factWithEnum: FactWithEnum(enumValue == AnEnum.FIRST) \n", new FactWithEnum(AnEnum.FIRST));
    }

    private void testFactAttributeType(String ruleConstraint, Object factInserted) throws InterruptedException {
        String drl = " import org.drools.mvel.integrationtests.facts.*;\n global " + AtomicInteger.class.getCanonicalName() + " numberOfFirings;\n rule R1 \n when \n" + ruleConstraint + " then \n numberOfFirings.incrementAndGet(); \n end ";
        AtomicInteger numberOfFirings = new AtomicInteger();
        this.parallelTest(NUMBER_OF_REPETITIONS, NUMBER_OF_THREADS, (kieSession, counter) -> {
            kieSession.insert(factInserted);
            int rulesFired = kieSession.fireAllRules();
            return this.sharedKieSession || rulesFired == 1;
        }, "numberOfFirings", numberOfFirings, drl);
        if (this.sharedKieSession) {
            Assertions.assertThat((int)numberOfFirings.get()).isEqualTo(1);
        } else {
            Assertions.assertThat((int)numberOfFirings.get()).isEqualTo(10);
        }
    }
}

