/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.integrationtests;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.drools.compiler.integrationtests.AbstractBackwardChainingTest;
import org.drools.compiler.integrationtests.incrementalcompilation.TestUtil;
import org.drools.core.InitialFact;
import org.drools.core.base.ClassObjectType;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.MemoryFactory;
import org.drools.core.impl.InternalKnowledgeBase;
import org.drools.core.impl.KnowledgeBaseImpl;
import org.drools.core.impl.StatefulKnowledgeSessionImpl;
import org.drools.core.reteoo.AccumulateNode;
import org.drools.core.reteoo.BetaMemory;
import org.drools.core.reteoo.BetaNode;
import org.drools.core.reteoo.ExistsNode;
import org.drools.core.reteoo.FromNode;
import org.drools.core.reteoo.NotNode;
import org.drools.core.reteoo.ObjectTypeNode;
import org.drools.core.reteoo.QueryElementNode;
import org.drools.core.reteoo.RightInputAdapterNode;
import org.drools.testcoverage.common.model.Address;
import org.drools.testcoverage.common.model.Person;
import org.drools.testcoverage.common.util.KieBaseTestConfiguration;
import org.drools.testcoverage.common.util.KieBaseUtil;
import org.drools.testcoverage.common.util.KieSessionTestConfiguration;
import org.drools.testcoverage.common.util.KieUtil;
import org.drools.testcoverage.common.util.SerializationHelper;
import org.drools.testcoverage.common.util.TestParametersUtil;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.KieBase;
import org.kie.api.KieServices;
import org.kie.api.builder.KieModule;
import org.kie.api.builder.ReleaseId;
import org.kie.api.definition.KiePackage;
import org.kie.api.io.ResourceType;
import org.kie.api.runtime.KieContainer;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.rule.FactHandle;
import org.kie.api.runtime.rule.LiveQuery;
import org.kie.api.runtime.rule.QueryResults;
import org.kie.api.runtime.rule.QueryResultsRow;
import org.kie.api.runtime.rule.Row;
import org.kie.api.runtime.rule.Variable;
import org.kie.api.runtime.rule.ViewChangedEventListener;
import org.kie.internal.builder.KnowledgeBuilder;
import org.kie.internal.builder.conf.PropertySpecificOption;
import org.kie.internal.io.ResourceFactory;

@RunWith(value=Parameterized.class)
public class BackwardChainingTest
extends AbstractBackwardChainingTest {
    public BackwardChainingTest(KieBaseTestConfiguration kieBaseTestConfiguration) {
        super(kieBaseTestConfiguration);
    }

    @Parameterized.Parameters(name="KieBase type={0}")
    public static Collection<Object[]> getParameters() {
        return TestParametersUtil.getKieBaseCloudConfigurations((boolean)true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=10000L)
    public void testQueryPatternBindingAsResult() throws IOException, ClassNotFoundException {
        String str = "package org.drools.compiler.test  \nimport " + Person.class.getCanonicalName() + "\nglobal java.util.List list\nquery peeps( Person $p, String $name, String $likes, int $age ) \n    $p := Person( $name := name, $likes := likes, $age := age; ) \nend\n";
        str = str + "rule x1\nwhen\n    String( this == \"go1\" )\n    ?peeps($p, $name1; $likes1 : $likes, $age1 : $age )\nthen\n   list.add( $p );\n   list.add( $name1 + \" : \" + $age1 );\nend \n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"backward-chaining-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{str});
        KieSession ksession = kbase.newKieSession();
        try {
            ArrayList list = new ArrayList();
            ksession.setGlobal("list", list);
            Person p1 = new Person("darth", "stilton", 100);
            Person p2 = new Person("darth", "stilton", 200);
            Person p3 = new Person("yoda", "stilton", 300);
            Person p4 = new Person("luke", "brie", 300);
            Person p5 = new Person("bobba", "cheddar", 300);
            ksession.insert((Object)p1);
            ksession.insert((Object)p2);
            ksession.insert((Object)p3);
            ksession.insert((Object)p4);
            ksession.insert((Object)p5);
            ksession.insert((Object)"go1");
            ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession((KieSession)ksession, (boolean)true);
            ksession.fireAllRules();
            if (this.kieBaseTestConfiguration.isIdentity()) {
                Assert.assertEquals((long)10L, (long)list.size());
                Assert.assertEquals((Object)p1, list.get(list.indexOf("darth : 100") - 1));
                Assert.assertTrue((boolean)list.contains("darth : 100"));
                Assert.assertEquals((Object)p2, list.get(list.indexOf("darth : 200") - 1));
                Assert.assertTrue((boolean)list.contains("darth : 200"));
                Assert.assertEquals((Object)p3, list.get(list.indexOf("yoda : 300") - 1));
                Assert.assertTrue((boolean)list.contains("yoda : 300"));
                Assert.assertEquals((Object)p4, list.get(list.indexOf("luke : 300") - 1));
                Assert.assertTrue((boolean)list.contains("luke : 300"));
                Assert.assertEquals((Object)p5, list.get(list.indexOf("bobba : 300") - 1));
                Assert.assertTrue((boolean)list.contains("bobba : 300"));
            } else {
                Assert.assertEquals((long)8L, (long)list.size());
                Assert.assertEquals((Object)p1, list.get(list.indexOf("darth : 100") - 1));
                Assert.assertTrue((boolean)list.contains("darth : 100"));
                Assert.assertEquals((Object)p3, list.get(list.indexOf("yoda : 300") - 1));
                Assert.assertTrue((boolean)list.contains("yoda : 300"));
                Assert.assertEquals((Object)p4, list.get(list.indexOf("luke : 300") - 1));
                Assert.assertTrue((boolean)list.contains("luke : 300"));
                Assert.assertEquals((Object)p5, list.get(list.indexOf("bobba : 300") - 1));
                Assert.assertTrue((boolean)list.contains("bobba : 300"));
            }
        }
        finally {
            ksession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=10000L)
    public void testQueriesWithNestedAccessorsAllOutputs() throws IOException, ClassNotFoundException {
        String drl = "package org.drools.compiler.test  \nimport " + Person.class.getCanonicalName() + "\nglobal java.util.List list\nquery peeps( String $name, String $likes, String $street ) \n   Person( $name := name, $likes := likes, $street := address.street ) \nend\n";
        drl = drl + "rule x1\nwhen\n    String( this == \"go1\" )\n    ?peeps($name1; $likes1 : $likes, $street1 : $street )\nthen\n   list.add( $name1 + \" : \" + $likes1 + \" : \" +  $street1 );\nend \n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"backward-chaining-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession ksession = kbase.newKieSession();
        try {
            ArrayList list = new ArrayList();
            ksession.setGlobal("list", list);
            Person p1 = new Person("darth", "stilton", 100);
            p1.setAddress(new Address("s1"));
            Person p2 = new Person("yoda", "stilton", 300);
            p2.setAddress(new Address("s2"));
            ksession.insert((Object)p1);
            ksession.insert((Object)p2);
            ksession.insert((Object)"go1");
            ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession((KieSession)ksession, (boolean)true);
            ksession.fireAllRules();
            Assert.assertEquals((long)2L, (long)list.size());
            Assert.assertTrue((boolean)list.contains("darth : stilton : s1"));
            Assert.assertTrue((boolean)list.contains("yoda : stilton : s2"));
        }
        finally {
            ksession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=10000L)
    public void testQueriesWithNestedAcecssorsMixedArgs() {
        String drl = "package org.drools.compiler.test  \nimport " + Person.class.getCanonicalName() + "\nglobal java.util.List list\nquery peeps( String $name, String $likes, String $street ) \n   Person( $name := name, $likes := likes, $street := address.street ) \nend\n";
        drl = drl + "rule x1\nwhen\n    $s : String()\n    ?peeps($name1; $likes1 : $likes, $street : $s )\nthen\n   list.add( $name1 + \" : \" + $likes1 + \" : \" +  $s );\nend \n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"backward-chaining-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession ksession = kbase.newKieSession();
        try {
            ArrayList list = new ArrayList();
            ksession.setGlobal("list", list);
            Person p1 = new Person("darth", "stilton", 100);
            p1.setAddress(new Address("s1"));
            Person p2 = new Person("yoda", "stilton", 300);
            p2.setAddress(new Address("s2"));
            ksession.insert((Object)p1);
            ksession.insert((Object)p2);
            ksession.insert((Object)"s1");
            ksession.fireAllRules();
            Assert.assertEquals((long)1L, (long)list.size());
            Assert.assertTrue((boolean)list.contains("darth : stilton : s1"));
            list.clear();
            ksession.insert((Object)"s2");
            ksession.fireAllRules();
            Assert.assertEquals((long)1L, (long)list.size());
            Assert.assertTrue((boolean)list.contains("yoda : stilton : s2"));
        }
        finally {
            ksession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=10000L)
    public void testQueryWithDynamicData() throws IOException, ClassNotFoundException {
        String drl = "package org.drools.compiler.test  \nimport " + Person.class.getCanonicalName() + "\nglobal java.util.List list\nquery peeps( Person $p, String $name, String $likes, int $age ) \n    $p := Person( ) from new Person( $name, $likes, $age ) \nend\n";
        drl = drl + "rule x1\nwhen\n    $n1 : String( )\n    ?peeps($p; $name : $n1, $likes : \"stilton\", $age : 100 )\nthen\n   list.add( $p );\nend \n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"backward-chaining-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession ksession = kbase.newKieSession();
        try {
            ArrayList list = new ArrayList();
            ksession.setGlobal("list", list);
            Person p1 = new Person("darth", "stilton", 100);
            Person p2 = new Person("yoda", "stilton", 100);
            ksession.insert((Object)"darth");
            ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession((KieSession)ksession, (boolean)true);
            ksession.fireAllRules();
            Assert.assertEquals((long)1L, (long)list.size());
            Assert.assertEquals((Object)p1, list.get(0));
            list.clear();
            ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession((KieSession)ksession, (boolean)true);
            ksession.insert((Object)"yoda");
            ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession((KieSession)ksession, (boolean)true);
            ksession.fireAllRules();
            Assert.assertEquals((long)1L, (long)list.size());
            Assert.assertEquals((Object)p2, list.get(0));
        }
        finally {
            ksession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=10000L)
    public void testQueryWithDyanmicInsert() throws IOException, ClassNotFoundException {
        String drl = "package org.drools.compiler.test  \nimport " + Person.class.getCanonicalName() + "\nglobal java.util.List list\nquery peeps( Person $p, String $name, String $likes, int $age ) \n    $p := Person( ) from new Person( $name, $likes, $age ) \nend\n";
        drl = drl + "rule x1\nwhen\n    $n1 : String( )\n    not Person( name == 'darth' )\n     ?peeps($p; $name : $n1, $likes : \"stilton\", $age : 100 )\nthen\n   insert( $p );\nend \n";
        drl = drl + "rule x2\nwhen\n    $p : Person( )\nthen\n   list.add( $p );\nend \n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"backward-chaining-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession ksession = kbase.newKieSession();
        try {
            ArrayList list = new ArrayList();
            ksession.setGlobal("list", list);
            Person p1 = new Person("darth", "stilton", 100);
            ksession.insert((Object)"darth");
            ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession((KieSession)ksession, (boolean)true);
            ksession.fireAllRules();
            ksession.insert((Object)"yoda");
            ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession((KieSession)ksession, (boolean)true);
            ksession.fireAllRules();
            Assert.assertEquals((long)1L, (long)list.size());
            Assert.assertEquals((Object)p1, list.get(0));
        }
        finally {
            ksession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=10000L)
    public void testQueryWithOr() {
        String drl = "package org.drools.compiler.test  \nimport java.util.List\nimport java.util.ArrayList\nimport " + BackwardChainingTest.class.getName() + ".Q\nimport " + BackwardChainingTest.class.getName() + ".R\nimport " + BackwardChainingTest.class.getName() + ".S\nglobal List list\ndialect \"mvel\"\n\nquery q(int x)\n    Q( x := value )\nend\n\nquery r(int x)\n    R( x := value )\nend\n\nquery s(int x)\n    S( x := value )    \nend\n\nquery p(int x)\n    (?q(x;) and ?r(x;) ) \n    or\n    ?s(x;)\nend\nrule init when\nthen\n insert( new Q(1) );\n  insert( new Q(5) );\n  insert( new Q(6) );\n  insert( new R(1) );\n  insert( new R(4) );\n  insert( new R(6) );\n  insert( new R(2) );\n  insert( new S(2) );\n  insert( new S(3) );\n  insert( new S(6) );\n end\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"backward-chaining-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession ksession = kbase.newKieSession();
        try {
            ArrayList<Integer> list = new ArrayList<Integer>();
            ksession.setGlobal("list", list);
            ksession.fireAllRules();
            list.clear();
            QueryResults results = ksession.getQueryResults("p", (Object[])new Integer[]{0});
            for (QueryResultsRow result : results) {
                list.add((Integer)result.get("x"));
            }
            Assert.assertEquals((long)0L, (long)list.size());
            list.clear();
            results = ksession.getQueryResults("p", (Object[])new Integer[]{1});
            for (QueryResultsRow result : results) {
                list.add((Integer)result.get("x"));
            }
            Assert.assertEquals((long)1L, (long)list.size());
            Assert.assertEquals((long)1L, (long)((Integer)list.get(0)).intValue());
            list.clear();
            results = ksession.getQueryResults("p", (Object[])new Integer[]{2});
            for (QueryResultsRow result : results) {
                list.add((Integer)result.get("x"));
            }
            Assert.assertEquals((long)1L, (long)list.size());
            Assert.assertEquals((long)2L, (long)((Integer)list.get(0)).intValue());
            list.clear();
            results = ksession.getQueryResults("p", (Object[])new Integer[]{3});
            for (QueryResultsRow result : results) {
                list.add((Integer)result.get("x"));
            }
            Assert.assertEquals((long)1L, (long)list.size());
            Assert.assertEquals((long)3L, (long)((Integer)list.get(0)).intValue());
            list.clear();
            results = ksession.getQueryResults("p", (Object[])new Integer[]{4});
            for (QueryResultsRow result : results) {
                list.add((Integer)result.get("x"));
            }
            Assert.assertEquals((long)0L, (long)list.size());
            list.clear();
            results = ksession.getQueryResults("p", (Object[])new Integer[]{5});
            for (QueryResultsRow result : results) {
                list.add((Integer)result.get("x"));
            }
            Assert.assertEquals((long)0L, (long)list.size());
            list.clear();
            results = ksession.getQueryResults("p", (Object[])new Integer[]{6});
            for (QueryResultsRow result : results) {
                list.add((Integer)result.get("x"));
            }
            Assert.assertEquals((long)2L, (long)list.size());
            Assert.assertEquals((long)6L, (long)((Integer)list.get(0)).intValue());
            Assert.assertEquals((long)6L, (long)((Integer)list.get(1)).intValue());
        }
        finally {
            ksession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=10000L)
    public void testGeneology() throws IOException, ClassNotFoundException {
        String drl = "package org.drools.compiler.test2  \nglobal java.util.List list\ndialect \"mvel\"\nquery man( String name ) \n   " + BackwardChainingTest.class.getName() + ".Man( name := name ) \nend\nquery woman( String name ) \n   " + BackwardChainingTest.class.getName() + ".Woman( name := name ) \nend\nquery parent( String parent, String child ) \n   " + BackwardChainingTest.class.getName() + ".Parent( parent := parent, child := child ) \nend\nquery father( String father, String child ) \n   ?man( father; ) \n   ?parent( father, child; ) \nend\nquery mother( String mother, String child ) \n   ?woman( mother; ) \n   ?parent( mother, child; ) \nend\nquery son( String son, String parent ) \n   ?man( son; ) \n   ?parent( parent, son; ) \nend\nquery daughter( String daughter, String parent ) \n   ?woman( daughter; ) \n   ?parent( parent, daughter; ) \nend\nquery siblings( String c1, String c2 ) \n   ?parent( $p, c1; ) \n   ?parent( $p, c2; ) \n   eval( !c1.equals( c2 ) )\nend\nquery fullSiblings( String c1, String c2 )\n   ?parent( $p1, c1; ) ?parent( $p1, c2; )\n   ?parent( $p2, c1; ) ?parent( $p2, c2; )\n   eval( !c1.equals( c2 ) && !$p1.equals( $p2 )  )\nend\nquery fullSiblings2( String c1, String c2 )\n   ?father( $p1, c1; ) ?father( $p1, c2; )\n   ?mother( $p2, c1; ) ?mother( $p2, c2; )\n   eval( !c1.equals( c2 ) )\nend\nquery uncle( String uncle, String n )\n   ?man( uncle; ) ?siblings( uncle, parent; )\n   ?parent( parent, n; )\n end\nquery aunt( String aunt, String n )\n   ?woman( aunt; ) ?siblings( aunt, parent; )\n   ?parent( parent, n; )\n end\nquery grantParents( String gp, String gc )\n   ?parent( gp, p; ) ?parent( p, gc; )\nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"backward-chaining-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession ksession = kbase.newKieSession();
        try {
            ArrayList<String> list = new ArrayList<String>();
            ksession.setGlobal("list", list);
            ksession.insert((Object)new Man("john"));
            ksession.insert((Object)new Woman("janet"));
            ksession.insert((Object)new Man("adam"));
            ksession.insert((Object)new Parent("john", "adam"));
            ksession.insert((Object)new Parent("janet", "adam"));
            ksession.insert((Object)new Man("stan"));
            ksession.insert((Object)new Parent("john", "stan"));
            ksession.insert((Object)new Parent("janet", "stan"));
            ksession.insert((Object)new Man("carl"));
            ksession.insert((Object)new Woman("tina"));
            ksession.insert((Object)new Woman("eve"));
            ksession.insert((Object)new Parent("carl", "eve"));
            ksession.insert((Object)new Parent("tina", "eve"));
            ksession.insert((Object)new Woman("mary"));
            ksession.insert((Object)new Parent("carl", "mary"));
            ksession.insert((Object)new Parent("tina", "mary"));
            ksession.insert((Object)new Man("peter"));
            ksession.insert((Object)new Parent("adam", "peter"));
            ksession.insert((Object)new Parent("eve", "peter"));
            ksession.insert((Object)new Man("paul"));
            ksession.insert((Object)new Parent("adam", "paul"));
            ksession.insert((Object)new Parent("mary", "paul"));
            ksession.insert((Object)new Woman("jill"));
            ksession.insert((Object)new Parent("adam", "jill"));
            ksession.insert((Object)new Parent("eve", "jill"));
            QueryResults results = null;
            ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession((KieSession)ksession, (boolean)true);
            list.clear();
            results = ksession.getQueryResults("woman", new Object[]{Variable.v});
            for (QueryResultsRow result : results) {
                list.add((String)result.get("name"));
            }
            Assert.assertEquals((long)5L, (long)list.size());
            BackwardChainingTest.assertContains(new String[]{"janet", "mary", "tina", "eve", "jill"}, list);
            list.clear();
            results = ksession.getQueryResults("man", new Object[]{Variable.v});
            for (QueryResultsRow result : results) {
                list.add((String)result.get("name"));
            }
            Assert.assertEquals((long)6L, (long)list.size());
            BackwardChainingTest.assertContains(new String[]{"stan", "john", "peter", "carl", "adam", "paul"}, list);
            list.clear();
            results = ksession.getQueryResults("father", new Object[]{Variable.v, Variable.v});
            for (QueryResultsRow result : results) {
                list.add(result.get("father") + ", " + result.get("child"));
            }
            Assert.assertEquals((long)7L, (long)list.size());
            BackwardChainingTest.assertContains(new String[]{"john, adam", "john, stan", "carl, eve", "carl, mary", "adam, peter", "adam, paul", "adam, jill"}, list);
            list.clear();
            results = ksession.getQueryResults("mother", new Object[]{Variable.v, Variable.v});
            for (QueryResultsRow result : results) {
                list.add(result.get("mother") + ", " + result.get("child"));
            }
            Assert.assertEquals((long)7L, (long)list.size());
            BackwardChainingTest.assertContains(new String[]{"janet, adam", "janet, stan", "mary, paul", "tina, eve", "tina, mary", "eve, peter", "eve, jill"}, list);
            list.clear();
            results = ksession.getQueryResults("son", new Object[]{Variable.v, Variable.v});
            for (QueryResultsRow result : results) {
                list.add(result.get("son") + ", " + result.get("parent"));
            }
            Assert.assertEquals((long)8L, (long)list.size());
            BackwardChainingTest.assertContains(new String[]{"stan, john", "stan, janet", "peter, adam", "peter, eve", "adam, john", "adam, janet", "paul, mary", "paul, adam"}, list);
            list.clear();
            results = ksession.getQueryResults("daughter", new Object[]{Variable.v, Variable.v});
            for (QueryResultsRow result : results) {
                list.add(result.get("daughter") + ", " + result.get("parent"));
            }
            Assert.assertEquals((long)6L, (long)list.size());
            BackwardChainingTest.assertContains(new String[]{"mary, carl", "mary, tina", "eve, carl", "eve, tina", "jill, adam", "jill, eve"}, list);
            list.clear();
            results = ksession.getQueryResults("siblings", new Object[]{Variable.v, Variable.v});
            for (QueryResultsRow result : results) {
                list.add(result.get("c1") + ", " + result.get("c2"));
            }
            Assert.assertEquals((long)16L, (long)list.size());
            BackwardChainingTest.assertContains(new String[]{"eve, mary", "mary, eve", "adam, stan", "stan, adam", "adam, stan", "stan, adam", "peter, paul", "peter, jill", "paul, peter", "paul, jill", "jill, peter", "jill, paul", "peter, jill", "jill, peter", "eve, mary", "mary, eve"}, list);
            list.clear();
            list.clear();
            results = ksession.getQueryResults("parent", new Object[]{Variable.v, Variable.v});
            for (QueryResultsRow result : results) {
                list.add(result.get("parent") + ":" + result.get("child"));
            }
            System.out.println(list);
            list.clear();
            results = ksession.getQueryResults("fullSiblings", new Object[]{Variable.v, Variable.v});
            for (QueryResultsRow result : results) {
                list.add(result.get("c1") + ", " + result.get("c2"));
            }
            System.out.println(list);
            Assert.assertEquals((long)12L, (long)list.size());
            BackwardChainingTest.assertContains(new String[]{"eve, mary", "mary, eve", "adam, stan", "stan, adam", "adam, stan", "stan, adam", "peter, jill", "jill, peter", "peter, jill", "jill, peter", "eve, mary", "mary, eve"}, list);
            list.clear();
            results = ksession.getQueryResults("fullSiblings", new Object[]{Variable.v, Variable.v});
            for (QueryResultsRow result : results) {
                list.add(result.get("c1") + ", " + result.get("c2"));
            }
            Assert.assertEquals((long)12L, (long)list.size());
            BackwardChainingTest.assertContains(new String[]{"eve, mary", "mary, eve", "adam, stan", "stan, adam", "adam, stan", "stan, adam", "peter, jill", "jill, peter", "peter, jill", "jill, peter", "eve, mary", "mary, eve"}, list);
            list.clear();
            results = ksession.getQueryResults("uncle", new Object[]{Variable.v, Variable.v});
            for (QueryResultsRow result : results) {
                list.add(result.get("uncle") + ", " + result.get("n"));
            }
            Assert.assertEquals((long)6L, (long)list.size());
            BackwardChainingTest.assertContains(new String[]{"stan, peter", "stan, paul", "stan, jill", "stan, peter", "stan, paul", "stan, jill"}, list);
            list.clear();
            results = ksession.getQueryResults("aunt", new Object[]{Variable.v, Variable.v});
            for (QueryResultsRow result : results) {
                list.add(result.get("aunt") + ", " + result.get("n"));
            }
            Assert.assertEquals((long)6L, (long)list.size());
            BackwardChainingTest.assertContains(new String[]{"mary, peter", "mary, jill", "mary, peter", "mary, jill", "eve, paul", "eve, paul"}, list);
            list.clear();
            results = ksession.getQueryResults("grantParents", new Object[]{Variable.v, Variable.v});
            for (QueryResultsRow result : results) {
                list.add(result.get("gp") + ", " + result.get("gc"));
            }
            Assert.assertEquals((long)12L, (long)list.size());
            BackwardChainingTest.assertContains(new String[]{"carl, peter", "carl, jill", "carl, paul", "john, peter", "john, paul", "john, jill", "janet, peter", "janet, paul", "janet, jill", "tina, peter", "tina, jill", "tina, paul"}, list);
        }
        finally {
            ksession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=10000L)
    public void testDynamicRulesWithSharing() {
        String drl = "package org.drools.compiler.test1  \n\ndeclare Location\n    thing : String \n    location : String \nend\ndeclare Edible\n   thing : String\nend\nquery whereFood( String x, String y ) \n    Location(x, y;) Edible(x;) \nend\n\nrule init when\nthen\n        \n        insert( new Location(\"apple\", \"kitchen\") );\n        insert( new Location(\"crackers\", \"kitchen\") );\n        insert( new Location(\"broccoli\", \"kitchen\") );\n        insert( new Location(\"computer\", \"office\") );\n        insert( new Edible(\"apple\") );\n        insert( new Edible(\"crackers\") );\nend\n";
        KieBase kieBase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"backward-chaining-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[0]);
        KnowledgeBuilder knowledgeBuilder = TestUtil.createKnowledgeBuilder(kieBase, drl);
        drl = "package org.drools.compiler.test2  \nimport org.drools.compiler.test1.*\nimport java.util.List\nimport java.util.ArrayList\nimport java.util.Map\nimport java.util.HashMap\nglobal List list\n\nrule look2 when\n     $place : String() // just here to give a OTN lookup point\n     whereFood(thing, $place;)\nthen\n      list.add( \"2:\" + thing );\nend\n";
        knowledgeBuilder.add(ResourceFactory.newByteArrayResource((byte[])drl.getBytes()), ResourceType.DRL);
        if (knowledgeBuilder.hasErrors()) {
            Assert.fail((String)knowledgeBuilder.getErrors().toString());
        }
        drl = "package org.drools.compiler.test3  \nimport org.drools.compiler.test1.*\nimport java.util.List\nimport java.util.ArrayList\nimport java.util.Map\nimport java.util.HashMap\nglobal List list\n\nrule look3 when\n     $place : String() // just here to give a OTN lookup point\n     whereFood(thing, $place;)\nthen\n      list.add( \"3:\" + thing );\nend\n";
        knowledgeBuilder.add(ResourceFactory.newByteArrayResource((byte[])drl.getBytes()), ResourceType.DRL);
        if (knowledgeBuilder.hasErrors()) {
            Assert.fail((String)knowledgeBuilder.getErrors().toString());
        }
        drl = "package org.drools.compiler.test4  \nimport org.drools.compiler.test1.*\nimport java.util.List\nimport java.util.ArrayList\nimport java.util.Map\nimport java.util.HashMap\nglobal List list\n\nrule look4 when\n     $place : String() // just here to give a OTN lookup point\n     whereFood(thing, $place;)\nthen\n      list.add( \"4:\" + thing );\nend\n";
        knowledgeBuilder.add(ResourceFactory.newByteArrayResource((byte[])drl.getBytes()), ResourceType.DRL);
        if (knowledgeBuilder.hasErrors()) {
            Assert.fail((String)knowledgeBuilder.getErrors().toString());
        }
        HashMap<String, KiePackage> pkgs = new HashMap<String, KiePackage>();
        for (KiePackage pkg : knowledgeBuilder.getKnowledgePackages()) {
            pkgs.put(pkg.getName(), pkg);
        }
        InternalKnowledgeBase kbase = (InternalKnowledgeBase)KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"backward-chaining-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[0]);
        kbase.addPackages(Arrays.asList((KiePackage)pkgs.get("org.drools.compiler.test1"), (KiePackage)pkgs.get("org.drools.compiler.test2")));
        KieSession ksession = kbase.newKieSession();
        try {
            ArrayList list = new ArrayList();
            ksession.setGlobal("list", list);
            ksession.insert((Object)"kitchen");
            ksession.fireAllRules();
            Assert.assertEquals((long)2L, (long)list.size());
            BackwardChainingTest.assertContains(new String[]{"2:crackers", "2:apple"}, list);
            list.clear();
            kbase.addPackages(Collections.singletonList(pkgs.get("org.drools.compiler.test3")));
            ksession.fireAllRules();
            Assert.assertEquals((long)2L, (long)list.size());
            BackwardChainingTest.assertContains(new String[]{"3:crackers", "3:apple"}, list);
            list.clear();
            kbase.addPackages(Collections.singletonList(pkgs.get("org.drools.compiler.test4")));
            ksession.fireAllRules();
            Assert.assertEquals((long)2L, (long)list.size());
            BackwardChainingTest.assertContains(new String[]{"4:crackers", "4:apple"}, list);
        }
        finally {
            ksession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=10000L)
    public void testOpenBackwardChain() {
        String drl = "package org.drools.compiler.test  \nimport java.util.List\nimport java.util.ArrayList\nimport " + Person.class.getCanonicalName() + "\nglobal List list\ndialect \"mvel\"\ndeclare Location\n    thing : String \n    location : String \nend\nquery isContainedIn( String x, String y ) \n    Location(x, y;)\n    or \n    ( Location(z, y;) and isContainedIn(x, z;) )\nend\n\nrule look when \n    Person( $l : likes ) \n    isContainedIn( $l, 'office'; )\nthen\n   insertLogical( 'blah' );end\nrule existsBlah when \n    exists String( this == 'blah') \nthen\n   list.add( 'exists blah' );end\n\nrule notBlah when \n    not String( this == 'blah') \nthen\n   list.add( 'not blah' );end\n\nrule init when\nthen\n        insert( new Location(\"desk\", \"office\") );\n        insert( new Location(\"envelope\", \"desk\") );\n        insert( new Location(\"key\", \"envelope\") );\nend\n\nrule go1 when \n    String( this == 'go1') \nthen\n        list.add( drools.getRule().getName() ); \n        insert( new Location('lamp', 'desk') );\nend\n\nrule go2 when \n    String( this == 'go2') \n    $l : Location('lamp', 'desk'; )\nthen\n    list.add( drools.getRule().getName() ); \n    retract( $l );\nend\n\nrule go3 when \n    String( this == 'go3') \nthen\n        list.add( drools.getRule().getName() ); \n        insert( new Location('lamp', 'desk') );\nend\n\nrule go4 when \n    String( this == 'go4') \n    $l : Location('lamp', 'desk'; )\nthen\n        list.add( drools.getRule().getName() ); \n    modify( $l ) { thing = 'book' };\nend\n\nrule go5 when \n    String( this == 'go5') \n    $l : Location('book', 'desk'; )\nthen\n    list.add( drools.getRule().getName() ); \n    modify( $l ) { thing = 'lamp' };\nend\n\nrule go6 when \n    String( this == 'go6') \n    $l : Location( 'lamp', 'desk'; )\nthen\n    list.add( drools.getRule().getName() ); \n    modify( $l ) { thing = 'book' };\nend\n\nrule go7 when \n    String( this == 'go7') \n    $p : Person( likes == 'lamp' ) \nthen\n    list.add( drools.getRule().getName() ); \n    modify( $p ) { likes = 'key' };\nend\n\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"backward-chaining-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession ksession = kbase.newKieSession();
        try {
            ArrayList list = new ArrayList();
            ksession.setGlobal("list", list);
            Person p = new Person();
            p.setLikes("lamp");
            ksession.insert((Object)p);
            ksession.fireAllRules();
            Assert.assertEquals((Object)"not blah", list.get(0));
            list.clear();
            InternalFactHandle fh = (InternalFactHandle)ksession.insert((Object)"go1");
            ksession.fireAllRules();
            fh = BackwardChainingTest.getFactHandle((FactHandle)fh, ksession);
            ksession.delete((FactHandle)fh);
            Assert.assertEquals((Object)"go1", list.get(0));
            Assert.assertEquals((Object)"exists blah", list.get(1));
            fh = (InternalFactHandle)ksession.insert((Object)"go2");
            ksession.fireAllRules();
            fh = BackwardChainingTest.getFactHandle((FactHandle)fh, ksession);
            ksession.delete((FactHandle)fh);
            Assert.assertEquals((Object)"go2", list.get(2));
            Assert.assertEquals((Object)"not blah", list.get(3));
            fh = (InternalFactHandle)ksession.insert((Object)"go3");
            ksession.fireAllRules();
            fh = BackwardChainingTest.getFactHandle((FactHandle)fh, ksession);
            ksession.delete((FactHandle)fh);
            Assert.assertEquals((Object)"go3", list.get(4));
            Assert.assertEquals((Object)"exists blah", list.get(5));
            fh = (InternalFactHandle)ksession.insert((Object)"go4");
            ksession.fireAllRules();
            fh = BackwardChainingTest.getFactHandle((FactHandle)fh, ksession);
            ksession.delete((FactHandle)fh);
            Assert.assertEquals((Object)"go4", list.get(6));
            Assert.assertEquals((Object)"not blah", list.get(7));
            fh = (InternalFactHandle)ksession.insert((Object)"go5");
            ksession.fireAllRules();
            fh = BackwardChainingTest.getFactHandle((FactHandle)fh, ksession);
            ksession.delete((FactHandle)fh);
            Assert.assertEquals((Object)"go5", list.get(8));
            Assert.assertEquals((Object)"exists blah", list.get(9));
            fh = (InternalFactHandle)ksession.insert((Object)"go6");
            ksession.fireAllRules();
            fh = BackwardChainingTest.getFactHandle((FactHandle)fh, ksession);
            ksession.delete((FactHandle)fh);
            Assert.assertEquals((Object)"go6", list.get(10));
            Assert.assertEquals((Object)"not blah", list.get(11));
            fh = (InternalFactHandle)ksession.insert((Object)"go7");
            ksession.fireAllRules();
            fh = BackwardChainingTest.getFactHandle((FactHandle)fh, ksession);
            ksession.delete((FactHandle)fh);
            Assert.assertEquals((Object)"go7", list.get(12));
            Assert.assertEquals((Object)"exists blah", list.get(13));
        }
        finally {
            ksession.dispose();
        }
    }

    @Test(timeout=10000L)
    public void testCompile() {
        String drl = "declare Location\nthing : String\nlocation : String\nend\n\nquery isContainedIn( String x, String y )\nLocation( x := thing, y := location)\nor \n( Location(z := thing, y := location) and ?isContainedIn( x := x, z := y ) )\nend\n";
        KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"backward-chaining-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"declare Location\nthing : String\nlocation : String\nend\n\nquery isContainedIn( String x, String y )\nLocation( x := thing, y := location)\nor \n( Location(z := thing, y := location) and ?isContainedIn( x := x, z := y ) )\nend\n"});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=10000L)
    public void testInsertionOrder() {
        String drl = "package org.drools.compiler.integrationtests  \nimport java.util.List\nimport java.util.ArrayList\nglobal List list\ndialect \"mvel\"\ndeclare Person\n   name : String\n   likes : String\nend\n\ndeclare Location\n    thing : String \n    location : String \nend\n\ndeclare Edible\n   thing : String\nend\n\n\nquery hasFood( String x, String y ) \n    Location(x, y;)      or \n     ( Location(z, y;) and hasFood(x, z;) )\nend\n\nrule look when \n    Person( $l : likes ) \n    hasFood( $l, 'kitchen'; )\nthen\n   list.add( 'kitchen has ' + $l );end\nrule go1 when\n    String( this == 'go1') \nthen\n        insert( new Person('zool', 'peach') );\n        insert( new Location(\"table\", \"kitchen\") );\n        insert( new Location(\"peach\", \"table\") );\nend\nrule go2 when\n    String( this == 'go2') \nthen\n        insert( new Person('zool', 'peach') );\n        insert( new Location(\"peach\", \"table\") );\n        insert( new Location(\"table\", \"kitchen\") );\nend\n\nrule go3 when\n    String( this == 'go3') \nthen\n        insert( new Location(\"table\", \"kitchen\") );\n        insert( new Location(\"peach\", \"table\") );\n        insert( new Person('zool', 'peach') );\nend\n\nrule go4 when\n    String( this == 'go4') \nthen\n        insert( new Location(\"peach\", \"table\") );\n        insert( new Location(\"table\", \"kitchen\") );\n        insert( new Person('zool', 'peach') );\nend\nrule go5 when\n    String( this == 'go5') \nthen\n        insert( new Location(\"peach\", \"table\") );\n        insert( new Person('zool', 'peach') );\n        insert( new Location(\"table\", \"kitchen\") );\nend\nrule go6 when\n    String( this == 'go6') \nthen\n        insert( new Location(\"table\", \"kitchen\") );\n        insert( new Person('zool', 'peach') );\n        insert( new Location(\"peach\", \"table\") );\nend\n\n\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"backward-chaining-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"package org.drools.compiler.integrationtests  \nimport java.util.List\nimport java.util.ArrayList\nglobal List list\ndialect \"mvel\"\ndeclare Person\n   name : String\n   likes : String\nend\n\ndeclare Location\n    thing : String \n    location : String \nend\n\ndeclare Edible\n   thing : String\nend\n\n\nquery hasFood( String x, String y ) \n    Location(x, y;)      or \n     ( Location(z, y;) and hasFood(x, z;) )\nend\n\nrule look when \n    Person( $l : likes ) \n    hasFood( $l, 'kitchen'; )\nthen\n   list.add( 'kitchen has ' + $l );end\nrule go1 when\n    String( this == 'go1') \nthen\n        insert( new Person('zool', 'peach') );\n        insert( new Location(\"table\", \"kitchen\") );\n        insert( new Location(\"peach\", \"table\") );\nend\nrule go2 when\n    String( this == 'go2') \nthen\n        insert( new Person('zool', 'peach') );\n        insert( new Location(\"peach\", \"table\") );\n        insert( new Location(\"table\", \"kitchen\") );\nend\n\nrule go3 when\n    String( this == 'go3') \nthen\n        insert( new Location(\"table\", \"kitchen\") );\n        insert( new Location(\"peach\", \"table\") );\n        insert( new Person('zool', 'peach') );\nend\n\nrule go4 when\n    String( this == 'go4') \nthen\n        insert( new Location(\"peach\", \"table\") );\n        insert( new Location(\"table\", \"kitchen\") );\n        insert( new Person('zool', 'peach') );\nend\nrule go5 when\n    String( this == 'go5') \nthen\n        insert( new Location(\"peach\", \"table\") );\n        insert( new Person('zool', 'peach') );\n        insert( new Location(\"table\", \"kitchen\") );\nend\nrule go6 when\n    String( this == 'go6') \nthen\n        insert( new Location(\"table\", \"kitchen\") );\n        insert( new Person('zool', 'peach') );\n        insert( new Location(\"peach\", \"table\") );\nend\n\n\n"});
        for (int i = 1; i <= 6; ++i) {
            KieSession ksession = kbase.newKieSession();
            try {
                ArrayList list = new ArrayList();
                ksession.setGlobal("list", list);
                ksession.fireAllRules();
                list.clear();
                FactHandle fh = ksession.insert((Object)("go" + i));
                ksession.fireAllRules();
                ksession.delete(fh);
                Assert.assertEquals((long)1L, (long)list.size());
                Assert.assertEquals((Object)"kitchen has peach", list.get(0));
                continue;
            }
            finally {
                ksession.dispose();
            }
        }
    }

    @Test(timeout=10000L)
    public void testQueryFindAll() {
        Object[] objects = new Object[]{42, "a String", 100};
        int oCount = objects.length;
        ArrayList<Object> queryList = new ArrayList<Object>();
        ArrayList<Object> ruleList = new ArrayList<Object>();
        this.runTestQueryFindAll(0, queryList, ruleList, objects);
        Assert.assertEquals((long)oCount, (long)queryList.size());
        BackwardChainingTest.assertContains(objects, queryList);
        queryList.clear();
        ruleList.clear();
        this.runTestQueryFindAll(1, queryList, ruleList, objects);
        Assert.assertEquals((long)(oCount * oCount), (long)queryList.size());
        queryList.clear();
        ruleList.clear();
        this.runTestQueryFindAll(2, queryList, ruleList, objects);
        Assert.assertEquals((long)(oCount * oCount), (long)queryList.size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runTestQueryFindAll(int iCase, List<Object> queryList, List<Object> ruleList, Object[] objects) {
        String drl = "package org.drools.compiler.test \nglobal java.util.List queryList \nglobal java.util.List ruleList \nquery object( Object o ) \n    o := Object( ) \nend \nrule findObjectByQuery \nwhen \n";
        switch (iCase) {
            case 0: {
                drl = drl + "    object( $a ; ) \n";
                break;
            }
            case 1: {
                drl = drl + "    Object() ";
                drl = drl + "    object( $a ; ) \n";
                break;
            }
            case 2: {
                drl = drl + "    object( $a ; ) \n";
                drl = drl + "    Object() ";
            }
        }
        drl = drl + "then \n//   System.out.println( \"Object by query: \" + $a );\n    queryList.add( $a ); \nend \nrule findObject \nsalience 10 \nwhen \n    $o: Object() \nthen //   System.out.println( \"Object: \" + $o );\n    ruleList.add( $o ); \nend \n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"backward-chaining-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession ksession = kbase.newKieSession();
        try {
            ksession.setGlobal("queryList", queryList);
            ksession.setGlobal("ruleList", ruleList);
            for (Object o : objects) {
                ksession.insert(o);
            }
            ksession.fireAllRules();
        }
        finally {
            ksession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=10000L)
    public void testQueryWithObject() {
        String drl = "package org.drools.compiler.test  \nimport java.util.List\nimport java.util.ArrayList\nglobal List list\ndialect \"mvel\"\n\nimport " + BackwardChainingTest.class.getName() + ".Q\nimport " + BackwardChainingTest.class.getName() + ".R\nimport " + BackwardChainingTest.class.getName() + ".S\nquery object(Object o)\n    o := Object() \nend\nrule collectObjects when\n   String( this == 'go1' )\n   object( o; )\nthen\n   list.add( o );\nend\nrule init when\n   String( this == 'init' )\nthen\n insert( new Q(1) );\n  insert( new Q(5) );\n  insert( new Q(6) );\n  insert( new R(1) );\n  insert( new R(4) );\n  insert( new R(6) );\n  insert( new R(2) );\n  insert( new S(2) );\n  insert( new S(3) );\n  insert( new S(6) );\n end\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"backward-chaining-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession ksession = kbase.newKieSession();
        ArrayList list = new ArrayList();
        try {
            ksession.setGlobal("list", list);
            ksession.insert((Object)"init");
            ksession.fireAllRules();
            ksession.insert((Object)"go1");
            ksession.fireAllRules();
            Assert.assertEquals((long)12L, (long)list.size());
            BackwardChainingTest.assertContains(new Object[]{"go1", "init", new Q(6), new R(6), new S(3), new R(2), new R(1), new R(4), new S(2), new S(6), new Q(1), new Q(5)}, list);
        }
        finally {
            ksession.dispose();
        }
        ksession = kbase.newKieSession();
        try {
            list = new ArrayList();
            ksession.setGlobal("list", list);
            ksession.insert((Object)"go1");
            ksession.fireAllRules();
            ksession.insert((Object)"init");
            ksession.fireAllRules();
            Assert.assertEquals((long)12L, (long)list.size());
            BackwardChainingTest.assertContains(new Object[]{"go1", "init", new Q(6), new R(6), new S(3), new R(2), new R(1), new R(4), new S(2), new S(6), new Q(1), new Q(5)}, list);
        }
        finally {
            ksession.dispose();
        }
    }

    public static void assertContains(Object[] objects, List list) {
        for (Object object : objects) {
            if (list.contains(object)) continue;
            Assert.fail((String)("does not contain:" + object));
        }
    }

    public static void assertContains(List objects, List list) {
        if (!list.contains(objects)) {
            Assert.fail((String)("does not contain:" + objects));
        }
    }

    public static InternalFactHandle getFactHandle(FactHandle factHandle, KieSession ksession) {
        HashMap handles = new HashMap();
        ksession.getFactHandles().forEach(fh -> handles.put(((InternalFactHandle)fh).getId(), fh));
        return (InternalFactHandle)handles.get(((InternalFactHandle)factHandle).getId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=10000L)
    public void testQueryWithClassLiterals() {
        String drl = "package org.drools.test \nimport java.util.List\nimport java.util.ArrayList\nglobal List list\ndeclare Foo end \nquery klass( Class $c )\n Object( this.getClass() == $c ) \nend\nrule R when\n o : String( this == 'go1' )\n klass( String.class ; )\nthen\n list.add( o );\n insert( new Foo() ); \nend\nrule S when\n o : Foo()\n klass( Foo.class ; )\nthen\n list.add( o );\nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"backward-chaining-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"package org.drools.test \nimport java.util.List\nimport java.util.ArrayList\nglobal List list\ndeclare Foo end \nquery klass( Class $c )\n Object( this.getClass() == $c ) \nend\nrule R when\n o : String( this == 'go1' )\n klass( String.class ; )\nthen\n list.add( o );\n insert( new Foo() ); \nend\nrule S when\n o : Foo()\n klass( Foo.class ; )\nthen\n list.add( o );\nend\n"});
        KieSession ksession = kbase.newKieSession();
        try {
            ArrayList list = new ArrayList();
            ksession.setGlobal("list", list);
            ksession.insert((Object)"go1");
            ksession.fireAllRules();
            Assert.assertEquals((long)2L, (long)list.size());
            Assert.assertEquals((Object)"go1", list.get(0));
            Assert.assertEquals((Object)"org.drools.test.Foo", (Object)list.get(1).getClass().getName());
        }
        finally {
            ksession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=10000L)
    public void testQueryIndexingWithUnification() {
        String drl = "package org.drools.test \nimport java.util.List\nimport java.util.ArrayList\nglobal List list\ndeclare Foo id : int end \ndeclare Bar  name : String  val : int end \nquery fooffa( String $name, Foo $f )\n Bar( name == $name, $id : val )\n $f := Foo( id == $id ) \nend\nrule R when\n o : String( this == 'go' )\n fooffa( \"x\", $f ; )\nthen\n list.add( $f );\nend\nrule S when\nthen\n insert( new Foo( 1 ) );\n insert( new Bar( \"x\", 1 ) );\nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"backward-chaining-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"package org.drools.test \nimport java.util.List\nimport java.util.ArrayList\nglobal List list\ndeclare Foo id : int end \ndeclare Bar  name : String  val : int end \nquery fooffa( String $name, Foo $f )\n Bar( name == $name, $id : val )\n $f := Foo( id == $id ) \nend\nrule R when\n o : String( this == 'go' )\n fooffa( \"x\", $f ; )\nthen\n list.add( $f );\nend\nrule S when\nthen\n insert( new Foo( 1 ) );\n insert( new Bar( \"x\", 1 ) );\nend\n"});
        KieSession ksession = kbase.newKieSession();
        try {
            ArrayList list = new ArrayList();
            ksession.setGlobal("list", list);
            ksession.fireAllRules();
            ksession.insert((Object)"go");
            ksession.fireAllRules();
            Assert.assertEquals((long)1L, (long)list.size());
        }
        finally {
            ksession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=10000L)
    public void testQueryWithEvents() {
        String drl = "global java.util.List list; declare Inner\n  @role(event)\nend\nrule \"Input\"\nwhen\nthen\n    insert( \"X\" );\n    insert( new Inner( ) );\nend\n\nquery myAgg(  )\n    Inner(  )\nend\n\nrule \"React\"\nwhen\n    String()\n    myAgg(  )\nthen\n    list.add( 42 );\nend";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"backward-chaining-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"global java.util.List list; declare Inner\n  @role(event)\nend\nrule \"Input\"\nwhen\nthen\n    insert( \"X\" );\n    insert( new Inner( ) );\nend\n\nquery myAgg(  )\n    Inner(  )\nend\n\nrule \"React\"\nwhen\n    String()\n    myAgg(  )\nthen\n    list.add( 42 );\nend"});
        KieSession ksession = kbase.newKieSession();
        try {
            ArrayList list = new ArrayList();
            ksession.setGlobal("list", list);
            ksession.fireAllRules();
            Assert.assertEquals(Collections.singletonList(42), list);
        }
        finally {
            ksession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=10000L)
    public void testNpeOnQuery() {
        String drl = "global java.util.List list; query foo( Integer $i )    $i := Integer( this < 10 ) end\n\nrule r1 when    foo( $i ; )    Integer( this == 10 ) then    System.out.println(\"10 \" + $i);   list.add( 10 );\nend\n\nrule r2 when    foo( $i; )    Integer( this == 20 ) then    System.out.println(\"20 \" + $i);   list.add( 20 );\nend\nrule r3 when    $i : Integer( this == 1 ) then    System.out.println($i);   update( kcontext.getKieRuntime().getFactHandle( $i ), $i + 1 );end\n\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"backward-chaining-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"global java.util.List list; query foo( Integer $i )    $i := Integer( this < 10 ) end\n\nrule r1 when    foo( $i ; )    Integer( this == 10 ) then    System.out.println(\"10 \" + $i);   list.add( 10 );\nend\n\nrule r2 when    foo( $i; )    Integer( this == 20 ) then    System.out.println(\"20 \" + $i);   list.add( 20 );\nend\nrule r3 when    $i : Integer( this == 1 ) then    System.out.println($i);   update( kcontext.getKieRuntime().getFactHandle( $i ), $i + 1 );end\n\n"});
        KieSession kieSession = kbase.newKieSession();
        try {
            ArrayList list = new ArrayList();
            kieSession.setGlobal("list", list);
            kieSession.insert((Object)1);
            kieSession.insert((Object)20);
            kieSession.fireAllRules();
            Assert.assertEquals((long)1L, (long)list.size());
            Assert.assertEquals((long)20L, (long)((Integer)list.get(0)).intValue());
        }
        finally {
            kieSession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testQueryWithEvalAndTypeBoxingUnboxing() {
        String drl = "package org.drools.test;\n\nglobal java.util.List list \n;\nquery primitiveInt( int $a )\n Integer( intValue == $a )\n eval( $a == 178 )\nend\n\nquery boxedInteger( Integer $a )\n Integer( this == $a )\n eval( $a == 178 )\nend\n\nquery boxInteger( int $a )\n Integer( this == $a )\n eval( $a == 178 )\nend\n\nquery unboxInteger( Integer $a )\n Integer( intValue == $a )\n eval( $a == 178 )\nend\n\nquery cast( int $a )\n Integer( intValue == $a )\n eval( $a == 178 )\nend\nrule Init when then insert( 178 ); end\n\nrule Check\nwhen\n String()\n ?primitiveInt( 178 ; )\n ?boxedInteger( $x ; )\n ?boxInteger( $x ; )\n ?unboxInteger( $y ; )\n ?cast( $z ; )\nthen\n list.add( $x ); \n list.add( $y ); \n list.add( $z ); \nend";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"backward-chaining-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"package org.drools.test;\n\nglobal java.util.List list \n;\nquery primitiveInt( int $a )\n Integer( intValue == $a )\n eval( $a == 178 )\nend\n\nquery boxedInteger( Integer $a )\n Integer( this == $a )\n eval( $a == 178 )\nend\n\nquery boxInteger( int $a )\n Integer( this == $a )\n eval( $a == 178 )\nend\n\nquery unboxInteger( Integer $a )\n Integer( intValue == $a )\n eval( $a == 178 )\nend\n\nquery cast( int $a )\n Integer( intValue == $a )\n eval( $a == 178 )\nend\nrule Init when then insert( 178 ); end\n\nrule Check\nwhen\n String()\n ?primitiveInt( 178 ; )\n ?boxedInteger( $x ; )\n ?boxInteger( $x ; )\n ?unboxInteger( $y ; )\n ?cast( $z ; )\nthen\n list.add( $x ); \n list.add( $y ); \n list.add( $z ); \nend"});
        KieSession ksession = kbase.newKieSession();
        try {
            ArrayList list = new ArrayList();
            ksession.setGlobal("list", list);
            ksession.fireAllRules();
            Assert.assertTrue((boolean)list.isEmpty());
            ksession.insert((Object)"go");
            ksession.fireAllRules();
            Assert.assertEquals(Arrays.asList(178, 178, 178), list);
        }
        finally {
            ksession.dispose();
        }
    }

    @Test
    public void testNaniSearchsNoPropReactivity() throws IOException, ClassNotFoundException {
        this.testNaniSearchs(PropertySpecificOption.ALLOWED);
    }

    @Test
    public void testNaniSearchsWithPropReactivity() throws IOException, ClassNotFoundException {
        this.testNaniSearchs(PropertySpecificOption.ALWAYS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testNaniSearchs(PropertySpecificOption propertySpecificOption) throws IOException, ClassNotFoundException {
        String drl = "package org.drools.compiler.test  \nimport java.util.List\nimport java.util.ArrayList\nimport java.util.Map\nimport java.util.HashMap\nglobal List list\ndialect \"mvel\"\ndeclare Room    name : String\nend\n\ndeclare Location\n    thing : String \n    location : String \nend\ndeclare Door\n   fromLocation : String\n   toLocation : String\nend\ndeclare Edible\n   thing : String\nend\ndeclare TastesYucky\n   thing : String\nend\n\ndeclare Here\n   place : String \nend\n\nquery whereFood( String x, String y ) \n    ( Location(x, y;) and\n      Edible(x;) )      or \n     ( Location(z, y;) and ?whereFood(x, z;) )\nend\nquery connect( String x, String y ) \n    Door(x, y;)\n    or \n    Door(y, x;)\nend\n\nquery isContainedIn( String x, String y ) \n    Location(x, y;)\n    or \n    ( Location(z, y;) and ?isContainedIn(x, z;) )\nend\n\nquery look(String place, List things, List food, List exits ) \n    Here(place;)\n    things := List() from accumulate( Location(thing, place;),\n                                      collectList( thing ) )\n    food := List() from accumulate( ?whereFood(thing, place;) ,                                    collectList( thing ) )\n    exits := List() from accumulate( ?connect(place, exit;),\n                                    collectList( exit ) )\nend\n\nrule reactiveLook when\n    Here( place : place) \n    ?look(place, things, food, exits;)\nthen\n    Map map = new HashMap();    list.add(map);    map.put( 'place', place);     map.put( 'things', things);     map.put( 'food', food);     map.put( 'exits', exits);     System.out.println( \"You are in the \" + place);\n    System.out.println( \"  You can see \" + things );\n    System.out.println( \"  You can eat \" + food );\n    System.out.println( \"  You can go to \" + exits );\nend\n\nrule init when\nthen\n        insert( new Room(\"kitchen\") );\n        insert( new Room(\"office\") );\n        insert( new Room(\"hall\") );\n        insert( new Room(\"dining room\") );\n        insert( new Room(\"cellar\") );\n        \n        insert( new Location(\"apple\", \"kitchen\") );\n        insert( new Location(\"desk\", \"office\") );\n        insert( new Location(\"apple\", \"desk\") );\n        insert( new Location(\"flashlight\", \"desk\") );\n        insert( new Location(\"envelope\", \"desk\") );\n        insert( new Location(\"key\", \"envelope\") );\n        insert( new Location(\"washing machine\", \"cellar\") );\n        insert( new Location(\"nani\", \"washing machine\") );\n        insert( new Location(\"broccoli\", \"kitchen\") );\n        insert( new Location(\"crackers\", \"kitchen\") );\n        insert( new Location(\"computer\", \"office\") );\n        \n        insert( new Door(\"office\", \"hall\") );\n        insert( new Door(\"kitchen\", \"office\") );\n        insert( new Door(\"hall\", \"dining room\") );\n        insert( new Door(\"kitchen\", \"cellar\") );\n        insert( new Door(\"dining room\", \"kitchen\") );\n        \n        insert( new Edible(\"apple\") );\n        insert( new Edible(\"crackers\") );\n        \n        insert( new TastesYucky(\"broccoli\") );  end\nrule go1 when\n   String( this == 'go1' )\nthen\n   insert( new Here(\"kitchen\") );\nend\n\nrule go2 when\n   String( this == 'go2' )\n   $h : Here( place == \"kitchen\")then\n   modify( $h ) { place = \"office\" };\nend\n";
        ReleaseId releaseId1 = KieServices.get().newReleaseId("org.kie", "backward-chaining-test", "1");
        HashMap<String, String> kieModuleConfigurationProperties = new HashMap<String, String>();
        kieModuleConfigurationProperties.put("drools.propertySpecific", propertySpecificOption.toString());
        KieModule kieModule = KieUtil.getKieModuleFromDrls((ReleaseId)releaseId1, (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (KieSessionTestConfiguration)KieSessionTestConfiguration.STATEFUL_REALTIME, kieModuleConfigurationProperties, (String[])new String[]{"package org.drools.compiler.test  \nimport java.util.List\nimport java.util.ArrayList\nimport java.util.Map\nimport java.util.HashMap\nglobal List list\ndialect \"mvel\"\ndeclare Room    name : String\nend\n\ndeclare Location\n    thing : String \n    location : String \nend\ndeclare Door\n   fromLocation : String\n   toLocation : String\nend\ndeclare Edible\n   thing : String\nend\ndeclare TastesYucky\n   thing : String\nend\n\ndeclare Here\n   place : String \nend\n\nquery whereFood( String x, String y ) \n    ( Location(x, y;) and\n      Edible(x;) )      or \n     ( Location(z, y;) and ?whereFood(x, z;) )\nend\nquery connect( String x, String y ) \n    Door(x, y;)\n    or \n    Door(y, x;)\nend\n\nquery isContainedIn( String x, String y ) \n    Location(x, y;)\n    or \n    ( Location(z, y;) and ?isContainedIn(x, z;) )\nend\n\nquery look(String place, List things, List food, List exits ) \n    Here(place;)\n    things := List() from accumulate( Location(thing, place;),\n                                      collectList( thing ) )\n    food := List() from accumulate( ?whereFood(thing, place;) ,                                    collectList( thing ) )\n    exits := List() from accumulate( ?connect(place, exit;),\n                                    collectList( exit ) )\nend\n\nrule reactiveLook when\n    Here( place : place) \n    ?look(place, things, food, exits;)\nthen\n    Map map = new HashMap();    list.add(map);    map.put( 'place', place);     map.put( 'things', things);     map.put( 'food', food);     map.put( 'exits', exits);     System.out.println( \"You are in the \" + place);\n    System.out.println( \"  You can see \" + things );\n    System.out.println( \"  You can eat \" + food );\n    System.out.println( \"  You can go to \" + exits );\nend\n\nrule init when\nthen\n        insert( new Room(\"kitchen\") );\n        insert( new Room(\"office\") );\n        insert( new Room(\"hall\") );\n        insert( new Room(\"dining room\") );\n        insert( new Room(\"cellar\") );\n        \n        insert( new Location(\"apple\", \"kitchen\") );\n        insert( new Location(\"desk\", \"office\") );\n        insert( new Location(\"apple\", \"desk\") );\n        insert( new Location(\"flashlight\", \"desk\") );\n        insert( new Location(\"envelope\", \"desk\") );\n        insert( new Location(\"key\", \"envelope\") );\n        insert( new Location(\"washing machine\", \"cellar\") );\n        insert( new Location(\"nani\", \"washing machine\") );\n        insert( new Location(\"broccoli\", \"kitchen\") );\n        insert( new Location(\"crackers\", \"kitchen\") );\n        insert( new Location(\"computer\", \"office\") );\n        \n        insert( new Door(\"office\", \"hall\") );\n        insert( new Door(\"kitchen\", \"office\") );\n        insert( new Door(\"hall\", \"dining room\") );\n        insert( new Door(\"kitchen\", \"cellar\") );\n        insert( new Door(\"dining room\", \"kitchen\") );\n        \n        insert( new Edible(\"apple\") );\n        insert( new Edible(\"crackers\") );\n        \n        insert( new TastesYucky(\"broccoli\") );  end\nrule go1 when\n   String( this == 'go1' )\nthen\n   insert( new Here(\"kitchen\") );\nend\n\nrule go2 when\n   String( this == 'go2' )\n   $h : Here( place == \"kitchen\")then\n   modify( $h ) { place = \"office\" };\nend\n"});
        KieContainer kieContainer = KieServices.get().newKieContainer(kieModule.getReleaseId());
        KieBase kbase = kieContainer.getKieBase();
        KieSession ksession = kbase.newKieSession();
        try {
            ArrayList list = new ArrayList();
            ksession.setGlobal("list", list);
            ksession.fireAllRules();
            ksession.insert((Object)"go1");
            ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession((KieSession)ksession, (boolean)true);
            ksession.fireAllRules();
            Map map = (Map)list.get(0);
            Assert.assertEquals((Object)"kitchen", map.get("place"));
            List items = (List)map.get("things");
            Assert.assertEquals((long)3L, (long)items.size());
            BackwardChainingTest.assertContains(new String[]{"apple", "broccoli", "crackers"}, items);
            items = (List)map.get("food");
            Assert.assertEquals((long)2L, (long)items.size());
            BackwardChainingTest.assertContains(new String[]{"apple", "crackers"}, items);
            items = (List)map.get("exits");
            Assert.assertEquals((long)3L, (long)items.size());
            BackwardChainingTest.assertContains(new String[]{"office", "cellar", "dining room"}, items);
            ksession.insert((Object)"go2");
            ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession((KieSession)ksession, (boolean)true);
            ksession.fireAllRules();
            map = (Map)list.get(1);
            Assert.assertEquals((Object)"office", map.get("place"));
            items = (List)map.get("things");
            Assert.assertEquals((long)2L, (long)items.size());
            BackwardChainingTest.assertContains(new String[]{"computer", "desk"}, items);
            items = (List)map.get("food");
            Assert.assertEquals((long)1L, (long)items.size());
            BackwardChainingTest.assertContains(new String[]{"apple"}, items);
            items = (List)map.get("exits");
            Assert.assertEquals((long)2L, (long)items.size());
            BackwardChainingTest.assertContains(new String[]{"hall", "kitchen"}, items);
            QueryResults results = ksession.getQueryResults("isContainedIn", new Object[]{"key", "office"});
            Assert.assertEquals((long)1L, (long)results.size());
            QueryResultsRow result = (QueryResultsRow)results.iterator().next();
            Assert.assertEquals((Object)"key", (Object)result.get("x"));
            Assert.assertEquals((Object)"office", (Object)result.get("y"));
            results = ksession.getQueryResults("isContainedIn", new Object[]{"key", Variable.v});
            ArrayList<List<String>> l = new ArrayList<List<String>>();
            for (QueryResultsRow r : results) {
                l.add(Arrays.asList((String)r.get("x"), (String)r.get("y")));
            }
            Assert.assertEquals((long)3L, (long)results.size());
            BackwardChainingTest.assertContains(Arrays.asList("key", "desk"), l);
            BackwardChainingTest.assertContains(Arrays.asList("key", "office"), l);
            BackwardChainingTest.assertContains(Arrays.asList("key", "envelope"), l);
            results = ksession.getQueryResults("isContainedIn", new Object[]{Variable.v, "office"});
            l = new ArrayList();
            for (QueryResultsRow r : results) {
                l.add(Arrays.asList((String)r.get("x"), (String)r.get("y")));
            }
            Assert.assertEquals((long)6L, (long)results.size());
            BackwardChainingTest.assertContains(Arrays.asList("desk", "office"), l);
            BackwardChainingTest.assertContains(Arrays.asList("computer", "office"), l);
            BackwardChainingTest.assertContains(Arrays.asList("apple", "office"), l);
            BackwardChainingTest.assertContains(Arrays.asList("envelope", "office"), l);
            BackwardChainingTest.assertContains(Arrays.asList("flashlight", "office"), l);
            BackwardChainingTest.assertContains(Arrays.asList("key", "office"), l);
            results = ksession.getQueryResults("isContainedIn", new Object[]{Variable.v, Variable.v});
            l = new ArrayList();
            for (QueryResultsRow r : results) {
                l.add(Arrays.asList((String)r.get("x"), (String)r.get("y")));
            }
            Assert.assertEquals((long)17L, (long)results.size());
            BackwardChainingTest.assertContains(Arrays.asList("apple", "kitchen"), l);
            BackwardChainingTest.assertContains(Arrays.asList("apple", "desk"), l);
            BackwardChainingTest.assertContains(Arrays.asList("envelope", "desk"), l);
            BackwardChainingTest.assertContains(Arrays.asList("desk", "office"), l);
            BackwardChainingTest.assertContains(Arrays.asList("computer", "office"), l);
            BackwardChainingTest.assertContains(Arrays.asList("washing machine", "cellar"), l);
            BackwardChainingTest.assertContains(Arrays.asList("key", "envelope"), l);
            BackwardChainingTest.assertContains(Arrays.asList("broccoli", "kitchen"), l);
            BackwardChainingTest.assertContains(Arrays.asList("nani", "washing machine"), l);
            BackwardChainingTest.assertContains(Arrays.asList("crackers", "kitchen"), l);
            BackwardChainingTest.assertContains(Arrays.asList("flashlight", "desk"), l);
            BackwardChainingTest.assertContains(Arrays.asList("nani", "cellar"), l);
            BackwardChainingTest.assertContains(Arrays.asList("apple", "office"), l);
            BackwardChainingTest.assertContains(Arrays.asList("envelope", "office"), l);
            BackwardChainingTest.assertContains(Arrays.asList("flashlight", "office"), l);
            BackwardChainingTest.assertContains(Arrays.asList("key", "office"), l);
            BackwardChainingTest.assertContains(Arrays.asList("key", "desk"), l);
        }
        finally {
            ksession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=10000L)
    public void testSubNetworksAndQueries() {
        String drl = "package org.drools.compiler.test  \nimport java.util.List\nimport java.util.ArrayList\nimport java.util.Map\nimport java.util.HashMap\nglobal List list\ndialect \"mvel\"\n\ndeclare Location\n    thing : String \n    location : String \nend\ndeclare Edible\n   thing : String\nend\nquery whereFood( String x, String y ) \n    Location(x, y;) Edible(x;) \nend\n\nquery look(String place, List food ) \n    $s : String() // just here to give a OTN lookup point\n    food := List() from accumulate( whereFood(thing, place;) ,                                    collectList( thing ) )\n    exists( whereFood(thing, place;) )\n    not( whereFood(thing, place;) and\n          String( this == $s ) from thing )\nend\n\nrule init when\nthen\n        \n        insert( new Location(\"apple\", \"kitchen\") );\n        insert( new Location(\"crackers\", \"kitchen\") );\n        insert( new Location(\"broccoli\", \"kitchen\") );\n        insert( new Location(\"computer\", \"office\") );\n        insert( new Edible(\"apple\") );\n        insert( new Edible(\"crackers\") );\nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"backward-chaining-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"package org.drools.compiler.test  \nimport java.util.List\nimport java.util.ArrayList\nimport java.util.Map\nimport java.util.HashMap\nglobal List list\ndialect \"mvel\"\n\ndeclare Location\n    thing : String \n    location : String \nend\ndeclare Edible\n   thing : String\nend\nquery whereFood( String x, String y ) \n    Location(x, y;) Edible(x;) \nend\n\nquery look(String place, List food ) \n    $s : String() // just here to give a OTN lookup point\n    food := List() from accumulate( whereFood(thing, place;) ,                                    collectList( thing ) )\n    exists( whereFood(thing, place;) )\n    not( whereFood(thing, place;) and\n          String( this == $s ) from thing )\nend\n\nrule init when\nthen\n        \n        insert( new Location(\"apple\", \"kitchen\") );\n        insert( new Location(\"crackers\", \"kitchen\") );\n        insert( new Location(\"broccoli\", \"kitchen\") );\n        insert( new Location(\"computer\", \"office\") );\n        insert( new Edible(\"apple\") );\n        insert( new Edible(\"crackers\") );\nend\n"});
        List nodes = ((KnowledgeBaseImpl)kbase).getRete().getObjectTypeNodes();
        ObjectTypeNode node = null;
        for (ObjectTypeNode n : nodes) {
            if (((ClassObjectType)n.getObjectType()).getClassType() != String.class) continue;
            node = n;
            break;
        }
        Assert.assertNotNull(node);
        BetaNode stringBetaNode = (BetaNode)node.getObjectSinkPropagator().getSinks()[0];
        QueryElementNode queryElementNode1 = (QueryElementNode)stringBetaNode.getSinkPropagator().getSinks()[0];
        RightInputAdapterNode riaNode1 = (RightInputAdapterNode)queryElementNode1.getSinkPropagator().getSinks()[0];
        AccumulateNode accNode = (AccumulateNode)riaNode1.getObjectSinkPropagator().getSinks()[0];
        QueryElementNode queryElementNode2 = (QueryElementNode)accNode.getSinkPropagator().getSinks()[0];
        RightInputAdapterNode riaNode2 = (RightInputAdapterNode)queryElementNode2.getSinkPropagator().getSinks()[0];
        ExistsNode existsNode = (ExistsNode)riaNode2.getObjectSinkPropagator().getSinks()[0];
        QueryElementNode queryElementNode3 = (QueryElementNode)existsNode.getSinkPropagator().getSinks()[0];
        FromNode fromNode = (FromNode)queryElementNode3.getSinkPropagator().getSinks()[0];
        RightInputAdapterNode riaNode3 = (RightInputAdapterNode)fromNode.getSinkPropagator().getSinks()[0];
        NotNode notNode = (NotNode)riaNode3.getObjectSinkPropagator().getSinks()[0];
        KieSession ksession = kbase.newKieSession();
        try {
            StatefulKnowledgeSessionImpl wm = (StatefulKnowledgeSessionImpl)ksession;
            AccumulateNode.AccumulateMemory accMemory = (AccumulateNode.AccumulateMemory)wm.getNodeMemory((MemoryFactory)accNode);
            BetaMemory existsMemory = (BetaMemory)wm.getNodeMemory((MemoryFactory)existsNode);
            FromNode.FromMemory fromMemory = (FromNode.FromMemory)wm.getNodeMemory((MemoryFactory)fromNode);
            BetaMemory notMemory = (BetaMemory)wm.getNodeMemory((MemoryFactory)notNode);
            ArrayList list = new ArrayList();
            ksession.setGlobal("list", list);
            FactHandle fh = ksession.insert((Object)"bread");
            ksession.fireAllRules();
            final ArrayList food = new ArrayList();
            QueryResults results = ksession.getQueryResults("look", new Object[]{"kitchen", Variable.v});
            Assert.assertEquals((long)1L, (long)results.size());
            for (QueryResultsRow row : results) {
                food.addAll((Collection)row.get("food"));
            }
            Assert.assertEquals((long)2L, (long)food.size());
            BackwardChainingTest.assertContains(new String[]{"crackers", "apple"}, food);
            Assert.assertEquals((long)0L, (long)accMemory.getBetaMemory().getRightTupleMemory().size());
            Assert.assertEquals((long)0L, (long)existsMemory.getRightTupleMemory().size());
            Assert.assertEquals((long)0L, (long)fromMemory.getBetaMemory().getLeftTupleMemory().size());
            Assert.assertEquals((long)0L, (long)notMemory.getRightTupleMemory().size());
            food.clear();
            final ArrayList foodUpdated = new ArrayList();
            LiveQuery query = ksession.openLiveQuery("look", new Object[]{"kitchen", Variable.v}, new ViewChangedEventListener(){

                public void rowUpdated(Row row) {
                    foodUpdated.addAll((Collection)row.get("food"));
                }

                public void rowDeleted(Row row) {
                }

                public void rowInserted(Row row) {
                    food.addAll((Collection)row.get("food"));
                }
            });
            Assert.assertEquals((long)2L, (long)food.size());
            BackwardChainingTest.assertContains(new String[]{"crackers", "apple"}, food);
            Assert.assertEquals((long)2L, (long)accMemory.getBetaMemory().getRightTupleMemory().size());
            Assert.assertEquals((long)2L, (long)existsMemory.getRightTupleMemory().size());
            Assert.assertEquals((long)2L, (long)fromMemory.getBetaMemory().getLeftTupleMemory().size());
            Assert.assertEquals((long)0L, (long)notMemory.getRightTupleMemory().size());
            food.clear();
            results = ksession.getQueryResults("look", new Object[]{"kitchen", Variable.v});
            Assert.assertEquals((long)1L, (long)results.size());
            for (QueryResultsRow row : results) {
                food.addAll((Collection)row.get("food"));
            }
            Assert.assertEquals((long)2L, (long)food.size());
            BackwardChainingTest.assertContains(new String[]{"crackers", "apple"}, food);
            Assert.assertEquals((long)2L, (long)accMemory.getBetaMemory().getRightTupleMemory().size());
            Assert.assertEquals((long)2L, (long)existsMemory.getRightTupleMemory().size());
            Assert.assertEquals((long)2L, (long)fromMemory.getBetaMemory().getLeftTupleMemory().size());
            Assert.assertEquals((long)0L, (long)notMemory.getRightTupleMemory().size());
            food.clear();
            ksession.update(fh, (Object)"crackers");
            ksession.fireAllRules();
            Assert.assertEquals((long)2L, (long)accMemory.getBetaMemory().getRightTupleMemory().size());
            Assert.assertEquals((long)2L, (long)existsMemory.getRightTupleMemory().size());
            Assert.assertEquals((long)2L, (long)fromMemory.getBetaMemory().getLeftTupleMemory().size());
            Assert.assertEquals((long)1L, (long)notMemory.getRightTupleMemory().size());
            Assert.assertEquals((long)0L, (long)foodUpdated.size());
            ksession.update(fh, (Object)"oranges");
            ksession.fireAllRules();
            Assert.assertEquals((long)2L, (long)accMemory.getBetaMemory().getRightTupleMemory().size());
            Assert.assertEquals((long)2L, (long)existsMemory.getRightTupleMemory().size());
            Assert.assertEquals((long)2L, (long)fromMemory.getBetaMemory().getLeftTupleMemory().size());
            Assert.assertEquals((long)0L, (long)notMemory.getRightTupleMemory().size());
            Assert.assertEquals((long)2L, (long)food.size());
            BackwardChainingTest.assertContains(new String[]{"crackers", "apple"}, food);
            query.close();
            Assert.assertEquals((long)0L, (long)accMemory.getBetaMemory().getRightTupleMemory().size());
            Assert.assertEquals((long)0L, (long)existsMemory.getRightTupleMemory().size());
            Assert.assertEquals((long)0L, (long)fromMemory.getBetaMemory().getLeftTupleMemory().size());
            Assert.assertEquals((long)0L, (long)notMemory.getRightTupleMemory().size());
        }
        finally {
            ksession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=10000L)
    public void testInsertionOrderTwo() {
        Object o;
        ArrayList list;
        int i;
        StringBuilder drlBuilder = new StringBuilder("package org.drools.compiler.test \nimport java.util.List \nglobal List list \ndeclare Thing \n    thing : String @key \nend \ndeclare Edible extends Thing \nend \ndeclare Location extends Thing \n    location : String  @key \nend \ndeclare Here \n    place : String \nend \nrule kickOff \nwhen \n    Integer( $i: intValue ) \nthen \n    switch( $i ){ \n");
        String[] facts = new String[]{"new Edible( 'peach' )", "new Location( 'peach', 'table' )", "new Here( 'table' )"};
        int f = 0;
        for (String fact : facts) {
            for (String fact1 : facts) {
                for (String fact2 : facts) {
                    HashSet<String> set = new HashSet<String>();
                    set.add(fact);
                    set.add(fact1);
                    set.add(fact2);
                    if (set.size() != 3) continue;
                    drlBuilder.append("    case ").append(f++).append(": \n").append("        insert( ").append(fact).append(" ); \n").append("        insert( ").append(fact1).append(" ); \n").append("        insert( ").append(fact2).append(" ); \n").append("        break; \n");
                }
            }
        }
        facts = new String[]{"new Edible( 'peach' )", "new Location( 'table', 'office' )", "new Location( 'peach', 'table' )", "new Here( 'office' )"};
        int h = f;
        for (String fact : facts) {
            for (String fact1 : facts) {
                for (String fact3 : facts) {
                    for (String fact2 : facts) {
                        HashSet<String> set = new HashSet<String>();
                        set.add(fact);
                        set.add(fact1);
                        set.add(fact3);
                        set.add(fact2);
                        if (set.size() != 4) continue;
                        drlBuilder.append("    case ").append(h++).append(": \n").append("        insert( ").append(fact).append(" ); \n").append("        insert( ").append(fact1).append(" ); \n").append("        insert( ").append(fact3).append(" ); \n").append("        insert( ").append(fact2).append(" ); \n").append("        break; \n");
                    }
                }
            }
        }
        drlBuilder.append("    } \nend \n\nquery whereFood( String x, String y ) \n    ( Location(x, y;) and Edible(x;) ) \n     or  \n    ( Location(z, y;) and whereFood(x, z;) ) \nend query look(String place, List things, List food)  \n    Here(place;) \n    things := List() from accumulate( Location(thing, place;), \n                                      collectList( thing ) ) \n    food := List() from accumulate( whereFood(thing, place;), \n                                    collectList( thing ) ) \nend \nrule reactiveLook \nwhen \n    Here( $place : place)  \n    look($place, $things, $food;) \nthen \n    list.addAll( $things ); \n    list.addAll( $food   ); \nend \n");
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"backward-chaining-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drlBuilder.toString()});
        for (i = 0; i < f; ++i) {
            KieSession ksession = kbase.newKieSession();
            try {
                list = new ArrayList();
                ksession.setGlobal("list", list);
                ksession.fireAllRules();
                list.clear();
                InternalFactHandle fh = (InternalFactHandle)ksession.insert((Object)i);
                ksession.fireAllRules();
                Assert.assertEquals((long)2L, (long)list.size());
                Assert.assertEquals((Object)"peach", list.get(0));
                Assert.assertEquals((Object)"peach", list.get(1));
                list.clear();
                InternalFactHandle[] handles = ksession.getFactHandles().toArray(new InternalFactHandle[0]);
                for (int j = 0; j < handles.length; ++j) {
                    if (handles[j].getObject() instanceof InitialFact || handles[j].getObject() instanceof Integer) continue;
                    handles[j] = BackwardChainingTest.getFactHandle((FactHandle)handles[j], ksession);
                    o = handles[j].getObject();
                    ksession.delete((FactHandle)handles[j]);
                    handles[j] = (InternalFactHandle)ksession.insert(o);
                    ksession.fireAllRules();
                    Assert.assertEquals((long)2L, (long)list.size());
                    Assert.assertEquals((Object)"peach", list.get(0));
                    Assert.assertEquals((Object)"peach", list.get(1));
                    list.clear();
                    handles[j] = BackwardChainingTest.getFactHandle((FactHandle)handles[j], ksession);
                    ksession.update((FactHandle)handles[j], handles[j].getObject());
                    ksession.fireAllRules();
                    Assert.assertEquals((long)2L, (long)list.size());
                    Assert.assertEquals((Object)"peach", list.get(0));
                    Assert.assertEquals((Object)"peach", list.get(1));
                    list.clear();
                }
                fh = BackwardChainingTest.getFactHandle((FactHandle)fh, ksession);
                ksession.delete((FactHandle)fh);
                continue;
            }
            finally {
                ksession.dispose();
            }
        }
        for (i = f; i < h; ++i) {
            KieSession ksession = kbase.newKieSession();
            try {
                list = new ArrayList();
                ksession.setGlobal("list", list);
                ksession.fireAllRules();
                list.clear();
                InternalFactHandle fh = (InternalFactHandle)ksession.insert((Object)i);
                ksession.fireAllRules();
                Assert.assertEquals((long)2L, (long)list.size());
                Assert.assertEquals((Object)"table", list.get(0));
                Assert.assertEquals((Object)"peach", list.get(1));
                list.clear();
                InternalFactHandle[] handles = ksession.getFactHandles().toArray(new InternalFactHandle[0]);
                for (int j = 0; j < handles.length; ++j) {
                    if (handles[j].getObject() instanceof InitialFact || handles[j].getObject() instanceof Integer) continue;
                    handles[j] = BackwardChainingTest.getFactHandle((FactHandle)handles[j], ksession);
                    o = handles[j].getObject();
                    ksession.delete((FactHandle)handles[j]);
                    handles[j] = (InternalFactHandle)ksession.insert(o);
                    ksession.fireAllRules();
                    Assert.assertEquals((long)2L, (long)list.size());
                    Assert.assertEquals((Object)"table", list.get(0));
                    Assert.assertEquals((Object)"peach", list.get(1));
                    list.clear();
                    handles[j] = BackwardChainingTest.getFactHandle((FactHandle)handles[j], ksession);
                    ksession.update((FactHandle)handles[j], handles[j].getObject());
                    ksession.fireAllRules();
                    Assert.assertEquals((long)2L, (long)list.size());
                    Assert.assertEquals((Object)"table", list.get(0));
                    Assert.assertEquals((Object)"peach", list.get(1));
                    list.clear();
                }
                fh = BackwardChainingTest.getFactHandle((FactHandle)fh, ksession);
                ksession.delete((FactHandle)fh);
                continue;
            }
            finally {
                ksession.dispose();
            }
        }
    }

    public static class S {
        int value;

        public S(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public void setValue(int value) {
            this.value = value;
        }

        public String toString() {
            return "S" + this.value;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.value;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            S other = (S)obj;
            return this.value == other.value;
        }
    }

    public static class R {
        int value;

        public R(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public void setValue(int value) {
            this.value = value;
        }

        public String toString() {
            return "R" + this.value;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.value;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            R other = (R)obj;
            return this.value == other.value;
        }
    }

    public static class Q {
        int value;

        public Q(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public void setValue(int value) {
            this.value = value;
        }

        public String toString() {
            return "Q" + this.value;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.value;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Q other = (Q)obj;
            return this.value == other.value;
        }
    }

    public static class Parent
    implements Serializable {
        private String parent;
        private String child;

        public Parent(String parent, String child) {
            this.parent = parent;
            this.child = child;
        }

        public String getParent() {
            return this.parent;
        }

        public void setParent(String parent) {
            this.parent = parent;
        }

        public String getChild() {
            return this.child;
        }

        public void setChild(String child) {
            this.child = child;
        }

        public String toString() {
            return "Parent [parent=" + this.parent + ", child=" + this.child + "]";
        }
    }

    public static class Woman
    implements Serializable {
        private String name;

        public Woman(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String toString() {
            return "Woman [name=" + this.name + "]";
        }
    }

    public static class Man
    implements Serializable {
        private String name;

        public Man(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String toString() {
            return "Man [name=" + this.name + "]";
        }
    }
}

