/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.integrationtests;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.drools.testcoverage.common.util.KieBaseTestConfiguration;
import org.drools.testcoverage.common.util.KieBaseUtil;
import org.drools.testcoverage.common.util.KieSessionTestConfiguration;
import org.drools.testcoverage.common.util.TestParametersUtil;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.KieBase;
import org.kie.api.event.rule.AfterMatchFiredEvent;
import org.kie.api.event.rule.AgendaEventListener;
import org.kie.api.event.rule.DefaultAgendaEventListener;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.rule.EntryPoint;
import org.kie.api.runtime.rule.FactHandle;
import org.kie.api.time.SessionPseudoClock;

@RunWith(value=Parameterized.class)
public class NegativePatternsTest {
    private static final int LOOPS = 300;
    private static final int SHORT_SLEEP_TIME = 20;
    private static final int LONG_SLEEP_TIME = 30;
    private final KieBaseTestConfiguration kieBaseTestConfiguration;
    private KieSession ksession;
    private TrackingAgendaEventListener firedRulesListener;

    public NegativePatternsTest(KieBaseTestConfiguration kieBaseTestConfiguration) {
        this.kieBaseTestConfiguration = kieBaseTestConfiguration;
    }

    @Parameterized.Parameters(name="KieBase type={0}")
    public static Collection<Object[]> getParameters() {
        return TestParametersUtil.getKieBaseStreamConfigurations((boolean)true);
    }

    @Before
    public void prepareKieSession() {
        String drl = "package org.drools.compiler.integrationtests\n\nimport " + TestEvent.class.getCanonicalName() + "\n\ndeclare TestEvent\n    @role( event )\n    @expires( 22ms )\nend\n\nrule \"SingleAbsence\"\n    duration( 18ms )\n    when\n        not ( TestEvent ( ) from entry-point EventStream )\n    then\n        // consequence\nend\n\nrule \"SingleConstrained\"\n    duration( 18ms )\n    when\n        not ( TestEvent ( name == \"EventA\" ) from entry-point EventStream )\n    then\n        // consequence\nend\n\nrule \"MultipleEvents\"\n    duration( 18ms )\n    when\n        TestEvent ( name == \"EventA\" ) over window:time( 22ms ) from entry-point EventStream\n        not ( TestEvent ( name == \"EventB\" ) over window:time( 22ms )  from entry-point EventStream )\n    then\n        // consequence\nend\n\nrule \"MultipleEntryPoints\"\n    duration( 18ms )\n    when\n        not (\n            TestEvent( name == \"EventA\" ) from entry-point EventStream\n        )\n        not (\n            TestEvent( name == \"EventB\" ) from entry-point OtherStream\n        )\n    then\n        // consequence\nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"subnetwork-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        this.ksession = kbase.newKieSession(KieSessionTestConfiguration.STATEFUL_PSEUDO.getKieSessionConfiguration(), null);
        this.firedRulesListener = new TrackingAgendaEventListener();
        this.ksession.addEventListener((AgendaEventListener)this.firedRulesListener);
    }

    @After
    public void cleanKieSession() {
        if (this.ksession != null) {
            this.ksession.dispose();
        }
    }

    @Test
    public void testSingleEvent() {
        EntryPoint entryPoint = this.ksession.getEntryPoint("EventStream");
        int count = 0;
        this.advanceTime(30L);
        Assert.assertEquals((long)count, (long)this.firedRulesListener.ruleFiredCount("SingleAbsence"));
        this.ksession.fireAllRules();
        Assert.assertEquals((long)count, (long)this.firedRulesListener.ruleFiredCount("SingleAbsence"));
        this.advanceTime(30L);
        this.ksession.fireAllRules();
        Assert.assertEquals((long)(++count), (long)this.firedRulesListener.ruleFiredCount("SingleAbsence"));
        FactHandle event = entryPoint.insert((Object)new TestEvent(0, "EventA"));
        this.ksession.fireAllRules();
        this.advanceTime(30L);
        this.ksession.fireAllRules();
        Assert.assertEquals((long)count, (long)this.firedRulesListener.ruleFiredCount("SingleAbsence"));
        entryPoint.delete(event);
        this.ksession.fireAllRules();
        this.advanceTime(30L);
        this.ksession.fireAllRules();
        Assert.assertEquals((long)(++count), (long)this.firedRulesListener.ruleFiredCount("SingleAbsence"));
        this.ksession.fireAllRules();
        this.advanceTime(30L);
        this.ksession.fireAllRules();
        Assert.assertEquals((long)count, (long)this.firedRulesListener.ruleFiredCount("SingleAbsence"));
    }

    @Test
    public void testConstrainedAbsence() {
        EntryPoint entryPoint = this.ksession.getEntryPoint("EventStream");
        int count = 0;
        ++count;
        for (int i = 0; i < 300; ++i) {
            entryPoint.insert((Object)new TestEvent(count, "EventB"));
            this.ksession.fireAllRules();
            this.advanceTime(30L);
        }
        for (int i = 0; i < 300; ++i) {
            FactHandle handle = entryPoint.insert((Object)new TestEvent(i, "EventA"));
            this.advanceTime(30L);
            this.ksession.fireAllRules();
            entryPoint.delete(handle);
            ++count;
            this.advanceTime(30L);
            this.ksession.fireAllRules();
        }
        this.ksession.fireAllRules();
        Assert.assertEquals((long)count, (long)this.firedRulesListener.ruleFiredCount("SingleConstrained"));
    }

    @Test
    public void testMultipleEvents() {
        int count;
        EntryPoint entryPoint = this.ksession.getEntryPoint("EventStream");
        for (count = 0; count < 150; ++count) {
            entryPoint.insert((Object)new TestEvent(count, "EventA"));
            this.ksession.fireAllRules();
            this.advanceTime(20L);
            this.ksession.fireAllRules();
        }
        Assert.assertEquals((long)count, (long)this.firedRulesListener.ruleFiredCount("MultipleEvents"));
        entryPoint.insert((Object)new TestEvent(count, "EventA"));
        FactHandle handle = entryPoint.insert((Object)new TestEvent(-1, "EventB"));
        this.advanceTime(20L);
        this.ksession.fireAllRules();
        entryPoint.delete(handle);
        this.ksession.fireAllRules();
        this.advanceTime(20L);
        this.ksession.fireAllRules();
        while (count < 300) {
            entryPoint.insert((Object)new TestEvent(count, "EventA"));
            this.ksession.fireAllRules();
            ++count;
            this.advanceTime(20L);
            this.ksession.fireAllRules();
        }
        this.ksession.fireAllRules();
        Assert.assertEquals((long)count, (long)this.firedRulesListener.ruleFiredCount("MultipleEvents"));
    }

    @Test
    public void testMultipleEntryPoints() {
        FactHandle handle;
        int i;
        EntryPoint entryPoint = this.ksession.getEntryPoint("EventStream");
        EntryPoint otherStream = this.ksession.getEntryPoint("OtherStream");
        int count = 0;
        ++count;
        this.ksession.fireAllRules();
        this.advanceTime(30L);
        this.ksession.fireAllRules();
        Assert.assertEquals((long)count, (long)this.firedRulesListener.ruleFiredCount("MultipleEntryPoints"));
        for (i = 0; i < 300; ++i) {
            handle = entryPoint.insert((Object)new TestEvent(count, "EventA"));
            this.ksession.fireAllRules();
            this.advanceTime(30L);
            entryPoint.delete(handle);
            this.ksession.fireAllRules();
            ++count;
            this.advanceTime(30L);
            this.ksession.fireAllRules();
        }
        for (i = 0; i < 300; ++i) {
            handle = otherStream.insert((Object)new TestEvent(count, "EventB"));
            this.advanceTime(30L);
            this.ksession.fireAllRules();
            otherStream.delete(handle);
            ++count;
            this.advanceTime(20L);
            this.ksession.fireAllRules();
        }
        this.ksession.fireAllRules();
        Assert.assertEquals((long)count, (long)this.firedRulesListener.ruleFiredCount("MultipleEntryPoints"));
    }

    private void advanceTime(long amount) {
        SessionPseudoClock clock = (SessionPseudoClock)this.ksession.getSessionClock();
        clock.advanceTime(amount, TimeUnit.MILLISECONDS);
    }

    public static class TrackingAgendaEventListener
    extends DefaultAgendaEventListener {
        private final Map<String, Integer> rulesFired = new HashMap<String, Integer>();

        public void afterMatchFired(AfterMatchFiredEvent event) {
            String rule = event.getMatch().getRule().getName();
            if (this.isRuleFired(rule)) {
                this.rulesFired.put(rule, this.rulesFired.get(rule) + 1);
            } else {
                this.rulesFired.put(rule, 1);
            }
        }

        public boolean isRuleFired(String rule) {
            return this.rulesFired.containsKey(rule);
        }

        public int ruleFiredCount(String rule) {
            if (this.isRuleFired(rule)) {
                return this.rulesFired.get(rule);
            }
            return 0;
        }

        public void clear() {
            this.rulesFired.clear();
        }
    }

    public static class TestEvent
    implements Serializable {
        private static final long serialVersionUID = -6985691286327371275L;
        private final Integer id;
        private final String name;

        public TestEvent(Integer id, String name) {
            this.id = id;
            this.name = name;
        }

        public int getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public String toString() {
            return String.format("TestEvent[id=%s, name=%s]", this.id, this.name);
        }
    }
}

