/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.extractors;

import org.drools.core.base.ClassFieldAccessorCache;
import org.drools.core.base.ClassFieldAccessorStore;
import org.drools.core.base.TestBean;
import org.drools.core.spi.InternalReadAccessor;
import org.drools.mvel.extractors.BaseClassFieldExtractorsTest;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class LongClassFieldExtractorTest
extends BaseClassFieldExtractorsTest {
    private static final long VALUE = 5L;
    InternalReadAccessor extractor;
    TestBean bean = new TestBean();

    @Before
    public void setUp() throws Exception {
        ClassFieldAccessorStore store = new ClassFieldAccessorStore();
        store.setClassFieldAccessorCache(new ClassFieldAccessorCache(Thread.currentThread().getContextClassLoader()));
        store.setEagerWire(true);
        this.extractor = store.getReader(TestBean.class, "longAttr");
    }

    @Override
    @Test
    public void testGetBooleanValue() {
        try {
            this.extractor.getBooleanValue(null, (Object)this.bean);
            Assert.fail((String)"Should have throw an exception");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    @Test
    public void testGetByteValue() {
        try {
            Assert.assertEquals((long)5L, (long)this.extractor.getByteValue(null, (Object)this.bean));
        }
        catch (Exception e) {
            Assert.fail((String)"Should not throw an exception");
        }
    }

    @Override
    @Test
    public void testGetCharValue() {
        try {
            this.extractor.getCharValue(null, (Object)this.bean);
            Assert.fail((String)"Should have throw an exception");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    @Test
    public void testGetDoubleValue() {
        try {
            Assert.assertEquals((double)5.0, (double)this.extractor.getDoubleValue(null, (Object)this.bean), (double)0.01);
        }
        catch (Exception e) {
            Assert.fail((String)"Should not throw an exception");
        }
    }

    @Override
    @Test
    public void testGetFloatValue() {
        try {
            Assert.assertEquals((double)5.0, (double)this.extractor.getFloatValue(null, (Object)this.bean), (double)0.01);
        }
        catch (Exception e) {
            Assert.fail((String)"Should not throw an exception");
        }
    }

    @Override
    @Test
    public void testGetIntValue() {
        try {
            Assert.assertEquals((long)5L, (long)this.extractor.getIntValue(null, (Object)this.bean));
        }
        catch (Exception e) {
            Assert.fail((String)"Should not throw an exception");
        }
    }

    @Override
    @Test
    public void testGetLongValue() {
        try {
            Assert.assertEquals((long)5L, (long)this.extractor.getLongValue(null, (Object)this.bean));
        }
        catch (Exception e) {
            Assert.fail((String)"Should not throw an exception");
        }
    }

    @Override
    @Test
    public void testGetShortValue() {
        try {
            Assert.assertEquals((long)5L, (long)this.extractor.getShortValue(null, (Object)this.bean));
        }
        catch (Exception e) {
            Assert.fail((String)"Should not throw an exception");
        }
    }

    @Override
    @Test
    public void testGetValue() {
        try {
            Assert.assertEquals((Object)new Long(5L), (Object)this.extractor.getValue(null, (Object)this.bean));
            Assert.assertTrue((boolean)(this.extractor.getValue(null, (Object)this.bean) instanceof Long));
        }
        catch (Exception e) {
            Assert.fail((String)"Should not throw an exception");
        }
    }

    @Override
    @Test
    public void testIsNullValue() {
        try {
            Assert.assertFalse((boolean)this.extractor.isNullValue(null, (Object)this.bean));
        }
        catch (Exception e) {
            Assert.fail((String)"Should not throw an exception");
        }
    }
}

