/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.integrationtests;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Test;
import org.kie.api.conf.KieBaseOption;
import org.kie.api.io.ResourceType;
import org.kie.api.runtime.KieSession;
import org.kie.internal.utils.KieHelper;

public class PropertyChangeSupportTest {
    @Test
    public void testPropertyChanged() {
        String drl = "import " + DynamicFact.class.getCanonicalName() + ";\ndeclare DynamicFact\n  @propertyChangeSupport\nend\nrule rule1\n   when\n     $fact: DynamicFact(name == \"user1\")\n   then\n     $fact.setName(\"user2\");\n end\n \n rule rule2\n   when\n     $fact: DynamicFact(name == \"user2\")\n   then\n     $fact.setValue($fact.getValue() + \"VAL1\");\n end";
        KieSession ksession = new KieHelper().addContent(drl, ResourceType.DRL).build(new KieBaseOption[0]).newKieSession();
        DynamicFact fact = new DynamicFact();
        fact.setName("user1");
        fact.setValue("");
        ksession.insert((Object)fact);
        ksession.fireAllRules(10);
        MatcherAssert.assertThat((Object)fact.getName(), (Matcher)CoreMatchers.is((Object)"user2"));
        MatcherAssert.assertThat((Object)fact.getValue(), (Matcher)CoreMatchers.is((Object)"VAL1"));
    }

    public static class DynamicFact {
        private PropertyChangeSupport support = new PropertyChangeSupport(this);
        private String name;
        private String value;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            String old = this.name;
            this.name = name;
            this.support.firePropertyChange("name", old, name);
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            String old = this.value;
            this.value = value;
            this.support.firePropertyChange("value", old, value);
        }

        public void addPropertyChangeListener(PropertyChangeListener listener) {
            this.support.addPropertyChangeListener(listener);
        }

        public void removePropertyChangeListener(PropertyChangeListener listener) {
            this.support.removePropertyChangeListener(listener);
        }
    }
}

