/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import org.drools.core.RuleBaseConfiguration;
import org.drools.core.WorkingMemoryEntryPoint;
import org.drools.core.base.ClassFieldAccessorCache;
import org.drools.core.base.ClassFieldAccessorStore;
import org.drools.core.base.ClassFieldReader;
import org.drools.core.base.ValueType;
import org.drools.core.common.DisconnectedWorkingMemoryEntryPoint;
import org.drools.core.common.EmptyBetaConstraints;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.common.Memory;
import org.drools.core.definitions.rule.impl.RuleImpl;
import org.drools.core.impl.InternalKnowledgeBase;
import org.drools.core.impl.KnowledgeBaseFactory;
import org.drools.core.reteoo.AlphaNode;
import org.drools.core.reteoo.BetaNode;
import org.drools.core.reteoo.CompositeObjectSinkAdapter;
import org.drools.core.reteoo.LeftTuple;
import org.drools.core.reteoo.LeftTupleImpl;
import org.drools.core.reteoo.LeftTupleSource;
import org.drools.core.reteoo.ModifyPreviousTuples;
import org.drools.core.reteoo.ObjectSink;
import org.drools.core.reteoo.ObjectSource;
import org.drools.core.reteoo.ReteooBuilder;
import org.drools.core.reteoo.ReteooFactHandleFactory;
import org.drools.core.reteoo.RightTuple;
import org.drools.core.reteoo.RuleRemovalContext;
import org.drools.core.reteoo.Sink;
import org.drools.core.reteoo.builder.BuildContext;
import org.drools.core.rule.PredicateConstraint;
import org.drools.core.spi.AlphaNodeFieldConstraint;
import org.drools.core.spi.InternalReadAccessor;
import org.drools.core.spi.PropagationContext;
import org.drools.mvel.ConstraintTestUtil;
import org.drools.mvel.model.Cheese;
import org.drools.mvel.model.MockObjectSource;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class CompositeObjectSinkAdapterTest {
    private InternalKnowledgeBase kBase;
    private BuildContext buildContext;
    ClassFieldAccessorStore store = new ClassFieldAccessorStore();
    private final boolean useLambdaConstraint;
    public int la;
    public int blah;

    public CompositeObjectSinkAdapterTest(boolean useLambdaConstraint) {
        this.useLambdaConstraint = useLambdaConstraint;
    }

    @Parameterized.Parameters(name="useLambdaConstraint={0}")
    public static Collection<Object[]> getParameters() {
        ArrayList<Object[]> parameters = new ArrayList<Object[]>();
        parameters.add(new Object[]{false});
        parameters.add(new Object[]{true});
        return parameters;
    }

    @Before
    public void setUp() throws Exception {
        this.store.setClassFieldAccessorCache(new ClassFieldAccessorCache(Thread.currentThread().getContextClassLoader()));
        this.store.setEagerWire(true);
        this.kBase = KnowledgeBaseFactory.newKnowledgeBase();
        this.buildContext = new BuildContext(this.kBase);
        this.buildContext.setRule(new RuleImpl("test"));
    }

    @Test
    public void testBeta() {
        CompositeObjectSinkAdapter ad = new CompositeObjectSinkAdapter();
        MockBetaNode beta = new MockBetaNode(this.buildContext.getNextId(), (LeftTupleSource)new MockBetaNode(), new MockObjectSource(), this.buildContext);
        ad.addObjectSink((ObjectSink)beta);
        Assert.assertEquals((long)1L, (long)ad.getSinks().length);
        Assert.assertEquals((Object)((Object)beta), (Object)ad.getSinks()[0]);
        Assert.assertEquals((long)1L, (long)ad.getOtherSinks().size());
        Assert.assertEquals((Object)((Object)beta), ad.getOtherSinks().get(0));
        Assert.assertNull((Object)ad.getHashableSinks());
        Assert.assertNull((Object)ad.getHashedFieldIndexes());
        Assert.assertNull((Object)ad.getHashedSinkMap());
        ad.removeObjectSink((ObjectSink)beta);
        Assert.assertNull((Object)ad.getOtherSinks());
        Assert.assertEquals((long)0L, (long)ad.getSinks().length);
    }

    @Test
    public void testAlphaWithPredicate() {
        CompositeObjectSinkAdapter ad = new CompositeObjectSinkAdapter();
        AlphaNode al = new AlphaNode(this.buildContext.getNextId(), (AlphaNodeFieldConstraint)new PredicateConstraint(null, null), null, this.buildContext);
        ad.addObjectSink((ObjectSink)al);
        Assert.assertEquals((long)1L, (long)ad.getSinks().length);
        Assert.assertEquals((long)1L, (long)ad.getOtherSinks().size());
        Assert.assertEquals((Object)al, ad.getOtherSinks().get(0));
        ad.removeObjectSink((ObjectSink)al);
        Assert.assertEquals((long)0L, (long)ad.getSinks().length);
        Assert.assertNull((Object)ad.getOtherSinks());
    }

    @Test
    public void testSingleAlpha() {
        CompositeObjectSinkAdapter ad = new CompositeObjectSinkAdapter();
        AlphaNodeFieldConstraint lit = ConstraintTestUtil.createCheeseTypeEqualsConstraint(new MockExtractor(), "stilton", this.useLambdaConstraint);
        AlphaNode al = new AlphaNode(this.buildContext.getNextId(), lit, (ObjectSource)new MockObjectSource(0), this.buildContext);
        ad.addObjectSink((ObjectSink)al);
        Assert.assertNull((Object)ad.getOtherSinks());
        Assert.assertNotNull((Object)ad.getHashedFieldIndexes());
        Assert.assertEquals((long)1L, (long)ad.getHashableSinks().size());
        Assert.assertEquals((Object)al, (Object)ad.getSinks()[0]);
        ad.removeObjectSink((ObjectSink)al);
        Assert.assertNull((Object)ad.getOtherSinks());
        Assert.assertNull((Object)ad.getHashableSinks());
    }

    @Test
    public void testDoubleAlphaWithBeta() {
        CompositeObjectSinkAdapter ad = new CompositeObjectSinkAdapter();
        AlphaNodeFieldConstraint lit = ConstraintTestUtil.createCheeseTypeEqualsConstraint(new MockExtractor(), "stilton", this.useLambdaConstraint);
        AlphaNode al = new AlphaNode(this.buildContext.getNextId(), lit, (ObjectSource)new MockObjectSource(0), this.buildContext);
        ad.addObjectSink((ObjectSink)al);
        Assert.assertNull((Object)ad.getOtherSinks());
        Assert.assertNotNull((Object)ad.getHashedFieldIndexes());
        Assert.assertEquals((long)1L, (long)ad.getHashableSinks().size());
        Assert.assertEquals((Object)al, (Object)ad.getSinks()[0]);
        AlphaNodeFieldConstraint lit2 = ConstraintTestUtil.createCheeseTypeEqualsConstraint(new MockExtractor(), "cheddar", this.useLambdaConstraint);
        AlphaNode al2 = new AlphaNode(this.buildContext.getNextId(), lit2, (ObjectSource)new MockObjectSource(this.buildContext.getNextId()), this.buildContext);
        ad.addObjectSink((ObjectSink)al2);
        Assert.assertNull((Object)ad.getOtherSinks());
        Assert.assertEquals((long)2L, (long)ad.getHashableSinks().size());
        Assert.assertEquals((Object)al, (Object)ad.getSinks()[0]);
        Assert.assertEquals((Object)al2, (Object)ad.getSinks()[1]);
        MockBetaNode beta = new MockBetaNode(this.buildContext.getNextId(), (LeftTupleSource)new MockBetaNode(), new MockObjectSource(), this.buildContext);
        ad.addObjectSink((ObjectSink)beta);
        Assert.assertNotNull((Object)ad.getOtherSinks());
        Assert.assertEquals((long)2L, (long)ad.getHashableSinks().size());
        Assert.assertEquals((long)1L, (long)ad.getOtherSinks().size());
        Assert.assertEquals((Object)((Object)beta), ad.getOtherSinks().get(0));
        ad.removeObjectSink((ObjectSink)beta);
        Assert.assertNull((Object)ad.getOtherSinks());
        Assert.assertEquals((long)2L, (long)ad.getHashableSinks().size());
    }

    @Test
    public void testTripleAlpha() {
        CompositeObjectSinkAdapter ad = new CompositeObjectSinkAdapter();
        ClassFieldReader extractor = this.store.getReader(Cheese.class, "type");
        AlphaNodeFieldConstraint lit = ConstraintTestUtil.createCheeseTypeEqualsConstraint(new MockExtractor(), "stilton", this.useLambdaConstraint);
        AlphaNode al = new AlphaNode(this.buildContext.getNextId(), lit, (ObjectSource)new MockObjectSource(this.buildContext.getNextId()), this.buildContext);
        ad.addObjectSink((ObjectSink)al);
        Assert.assertNull((Object)ad.getOtherSinks());
        Assert.assertNotNull((Object)ad.getHashedFieldIndexes());
        Assert.assertEquals((long)1L, (long)ad.getHashableSinks().size());
        Assert.assertEquals((Object)al, (Object)ad.getSinks()[0]);
        AlphaNodeFieldConstraint lit2 = ConstraintTestUtil.createCheeseTypeEqualsConstraint(new MockExtractor(), "cheddar", this.useLambdaConstraint);
        AlphaNode al2 = new AlphaNode(this.buildContext.getNextId(), lit2, (ObjectSource)new MockObjectSource(this.buildContext.getNextId()), this.buildContext);
        ad.addObjectSink((ObjectSink)al2);
        Assert.assertNull((Object)ad.getHashedSinkMap());
        Assert.assertEquals((long)2L, (long)ad.getHashableSinks().size());
        AlphaNodeFieldConstraint lit3 = ConstraintTestUtil.createCheeseTypeEqualsConstraint(new MockExtractor(), "stinky", this.useLambdaConstraint);
        AlphaNode al3 = new AlphaNode(this.buildContext.getNextId(), lit3, (ObjectSource)new MockObjectSource(this.buildContext.getNextId()), this.buildContext);
        ad.addObjectSink((ObjectSink)al3);
        Assert.assertNotNull((Object)ad.getHashedSinkMap());
        Assert.assertNull((Object)ad.getHashableSinks());
        ad.removeObjectSink((ObjectSink)al2);
        Assert.assertNotNull((Object)ad.getHashableSinks());
        Assert.assertEquals((long)2L, (long)ad.getHashableSinks().size());
        Assert.assertNull((Object)ad.getHashedSinkMap());
    }

    @Test
    public void testTripleAlphaCharacterConstraint() {
        CompositeObjectSinkAdapter ad = new CompositeObjectSinkAdapter();
        ClassFieldReader extractor = this.store.getReader(Cheese.class, "charType");
        AlphaNodeFieldConstraint lit = ConstraintTestUtil.createCheeseCharTypeEqualsConstraint((InternalReadAccessor)extractor, 65, this.useLambdaConstraint);
        AlphaNode al = new AlphaNode(this.buildContext.getNextId(), lit, (ObjectSource)new MockObjectSource(this.buildContext.getNextId()), this.buildContext);
        ad.addObjectSink((ObjectSink)al);
        Assert.assertNull((Object)ad.getOtherSinks());
        Assert.assertNotNull((Object)ad.getHashedFieldIndexes());
        Assert.assertEquals((long)1L, (long)ad.getHashableSinks().size());
        Assert.assertEquals((Object)al, (Object)ad.getSinks()[0]);
        AlphaNodeFieldConstraint lit2 = ConstraintTestUtil.createCheeseCharTypeEqualsConstraint((InternalReadAccessor)extractor, 66, this.useLambdaConstraint);
        AlphaNode al2 = new AlphaNode(this.buildContext.getNextId(), lit2, (ObjectSource)new MockObjectSource(this.buildContext.getNextId()), this.buildContext);
        ad.addObjectSink((ObjectSink)al2);
        Assert.assertNull((Object)ad.getHashedSinkMap());
        Assert.assertEquals((long)2L, (long)ad.getHashableSinks().size());
        AlphaNodeFieldConstraint lit3 = ConstraintTestUtil.createCheeseCharTypeEqualsConstraint((InternalReadAccessor)extractor, 67, this.useLambdaConstraint);
        AlphaNode al3 = new AlphaNode(this.buildContext.getNextId(), lit3, (ObjectSource)new MockObjectSource(this.buildContext.getNextId()), this.buildContext);
        ad.addObjectSink((ObjectSink)al3);
        Assert.assertNotNull((Object)ad.getHashedSinkMap());
        Assert.assertNull((Object)ad.getHashableSinks());
        Cheese cheese = new Cheese();
        cheese.setCharType('B');
        CompositeObjectSinkAdapter.HashKey hashKey = new CompositeObjectSinkAdapter.HashKey();
        hashKey.setValue(extractor.getIndex(), (Object)cheese, (InternalReadAccessor)extractor);
        ObjectSink sink = (ObjectSink)ad.getHashedSinkMap().get(hashKey);
        Assert.assertSame((Object)al2, (Object)sink);
        cheese.setCharType('X');
        hashKey.setValue(extractor.getIndex(), (Object)cheese, (InternalReadAccessor)extractor);
        sink = (ObjectSink)ad.getHashedSinkMap().get(hashKey);
        Assert.assertNull((Object)sink);
        ad.removeObjectSink((ObjectSink)al2);
        Assert.assertNotNull((Object)ad.getHashableSinks());
        Assert.assertEquals((long)2L, (long)ad.getHashableSinks().size());
        Assert.assertNull((Object)ad.getHashedSinkMap());
    }

    @Test
    public void testTripleAlphaObjectCharacterConstraint() {
        CompositeObjectSinkAdapter ad = new CompositeObjectSinkAdapter();
        ClassFieldReader extractor = this.store.getReader(Cheese.class, "charObjectType");
        AlphaNodeFieldConstraint lit = ConstraintTestUtil.createCheeseCharObjectTypeEqualsConstraint((InternalReadAccessor)extractor, 65, this.useLambdaConstraint);
        AlphaNode al = new AlphaNode(this.buildContext.getNextId(), lit, (ObjectSource)new MockObjectSource(this.buildContext.getNextId()), this.buildContext);
        ad.addObjectSink((ObjectSink)al);
        Assert.assertNull((Object)ad.getOtherSinks());
        Assert.assertNotNull((Object)ad.getHashedFieldIndexes());
        Assert.assertEquals((long)1L, (long)ad.getHashableSinks().size());
        Assert.assertEquals((Object)al, (Object)ad.getSinks()[0]);
        AlphaNodeFieldConstraint lit2 = ConstraintTestUtil.createCheeseCharObjectTypeEqualsConstraint((InternalReadAccessor)extractor, 66, this.useLambdaConstraint);
        AlphaNode al2 = new AlphaNode(this.buildContext.getNextId(), lit2, (ObjectSource)new MockObjectSource(this.buildContext.getNextId()), this.buildContext);
        ad.addObjectSink((ObjectSink)al2);
        Assert.assertNull((Object)ad.getHashedSinkMap());
        Assert.assertEquals((long)2L, (long)ad.getHashableSinks().size());
        AlphaNodeFieldConstraint lit3 = ConstraintTestUtil.createCheeseCharObjectTypeEqualsConstraint((InternalReadAccessor)extractor, 67, this.useLambdaConstraint);
        AlphaNode al3 = new AlphaNode(this.buildContext.getNextId(), lit3, (ObjectSource)new MockObjectSource(this.buildContext.getNextId()), this.buildContext);
        ad.addObjectSink((ObjectSink)al3);
        Assert.assertNotNull((Object)ad.getHashedSinkMap());
        Assert.assertNull((Object)ad.getHashableSinks());
        Cheese cheese = new Cheese();
        cheese.setCharObjectType(Character.valueOf('B'));
        CompositeObjectSinkAdapter.HashKey hashKey = new CompositeObjectSinkAdapter.HashKey();
        hashKey.setValue(extractor.getIndex(), (Object)cheese, (InternalReadAccessor)extractor);
        ObjectSink sink = (ObjectSink)ad.getHashedSinkMap().get(hashKey);
        Assert.assertSame((Object)al2, (Object)sink);
        cheese.setCharObjectType(Character.valueOf('X'));
        hashKey.setValue(extractor.getIndex(), (Object)cheese, (InternalReadAccessor)extractor);
        sink = (ObjectSink)ad.getHashedSinkMap().get(hashKey);
        Assert.assertNull((Object)sink);
        ad.removeObjectSink((ObjectSink)al2);
        Assert.assertNotNull((Object)ad.getHashableSinks());
        Assert.assertEquals((long)2L, (long)ad.getHashableSinks().size());
        Assert.assertNull((Object)ad.getHashedSinkMap());
    }

    @Test
    public void testPropagationWithNullValue() {
        CompositeObjectSinkAdapter ad = new CompositeObjectSinkAdapter();
        ClassFieldReader extractor = this.store.getReader(Cheese.class, "type");
        AlphaNodeFieldConstraint lit1 = ConstraintTestUtil.createCheeseTypeEqualsConstraint(new MockExtractor(), "stilton", this.useLambdaConstraint);
        AlphaNode al1 = new AlphaNode(this.buildContext.getNextId(), lit1, (ObjectSource)new MockObjectSource(this.buildContext.getNextId()), this.buildContext);
        AlphaNodeFieldConstraint lit2 = ConstraintTestUtil.createCheeseTypeEqualsConstraint(new MockExtractor(), "brie", this.useLambdaConstraint);
        AlphaNode al2 = new AlphaNode(this.buildContext.getNextId(), lit2, (ObjectSource)new MockObjectSource(this.buildContext.getNextId()), this.buildContext);
        AlphaNodeFieldConstraint lit3 = ConstraintTestUtil.createCheeseTypeEqualsConstraint(new MockExtractor(), "muzzarela", this.useLambdaConstraint);
        AlphaNode al3 = new AlphaNode(this.buildContext.getNextId(), lit3, (ObjectSource)new MockObjectSource(this.buildContext.getNextId()), this.buildContext);
        ad.addObjectSink((ObjectSink)al1);
        ad.addObjectSink((ObjectSink)al2);
        ad.addObjectSink((ObjectSink)al3);
        InternalFactHandle handle = new ReteooFactHandleFactory().newFactHandle((Object)new Cheese(), null, null, (WorkingMemoryEntryPoint)new DisconnectedWorkingMemoryEntryPoint("DEFAULT"));
        try {
            ad.propagateAssertObject(handle, null, null);
        }
        catch (RuntimeException e) {
            Assert.fail((String)("Not supposed to throw any exception: " + e.getMessage()));
        }
    }

    public static class MockBetaNode
    extends BetaNode {
        public MockBetaNode() {
        }

        protected boolean doRemove(RuleRemovalContext context, ReteooBuilder builder) {
            return true;
        }

        MockBetaNode(int id, LeftTupleSource leftInput, ObjectSource rightInput, BuildContext buildContext) {
            super(id, leftInput, rightInput, EmptyBetaConstraints.getInstance(), buildContext);
        }

        MockBetaNode(int id, LeftTupleSource leftInput, ObjectSource rightInput) {
            super(id, leftInput, rightInput, EmptyBetaConstraints.getInstance(), null);
        }

        public void assertObject(InternalFactHandle factHandle, PropagationContext pctx, InternalWorkingMemory workingMemory) {
        }

        public void modifyObject(InternalFactHandle factHandle, ModifyPreviousTuples modifyPreviousTuples, PropagationContext context, InternalWorkingMemory workingMemory) {
        }

        public void retractRightTuple(RightTuple rightTuple, PropagationContext context, InternalWorkingMemory workingMemory) {
        }

        public short getType() {
            return 0;
        }

        public void modifyRightTuple(RightTuple rightTuple, PropagationContext context, InternalWorkingMemory workingMemory) {
        }

        public LeftTuple createLeftTuple(InternalFactHandle factHandle, boolean leftTupleMemoryEnabled) {
            return new LeftTupleImpl(factHandle, (Sink)this, leftTupleMemoryEnabled);
        }

        public LeftTuple createLeftTuple(LeftTuple leftTuple, Sink sink, PropagationContext pctx, boolean leftTupleMemoryEnabled) {
            return new LeftTupleImpl(leftTuple, sink, pctx, leftTupleMemoryEnabled);
        }

        public LeftTuple createLeftTuple(InternalFactHandle factHandle, LeftTuple leftTuple, Sink sink) {
            return new LeftTupleImpl(factHandle, leftTuple, sink);
        }

        public LeftTuple createLeftTuple(LeftTuple leftTuple, RightTuple rightTuple, Sink sink) {
            return new LeftTupleImpl(leftTuple, rightTuple, sink);
        }

        public LeftTuple createLeftTuple(LeftTuple leftTuple, RightTuple rightTuple, LeftTuple currentLeftChild, LeftTuple currentRightChild, Sink sink, boolean leftTupleMemoryEnabled) {
            return new LeftTupleImpl(leftTuple, rightTuple, currentLeftChild, currentRightChild, sink, leftTupleMemoryEnabled);
        }

        public Memory createMemory(RuleBaseConfiguration config, InternalWorkingMemory wm) {
            return super.createMemory(config, wm);
        }

        public LeftTuple createPeer(LeftTuple original) {
            return null;
        }
    }

    public static class MockExtractor
    implements InternalReadAccessor {
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        }

        public void writeExternal(ObjectOutput out) throws IOException {
        }

        public int getIndex() {
            return 0;
        }

        public boolean getBooleanValue(InternalWorkingMemory workingMemory, Object object) {
            return false;
        }

        public byte getByteValue(InternalWorkingMemory workingMemory, Object object) {
            return 0;
        }

        public char getCharValue(InternalWorkingMemory workingMemory, Object object) {
            return '\u0000';
        }

        public double getDoubleValue(InternalWorkingMemory workingMemory, Object object) {
            return 0.0;
        }

        public Class getExtractToClass() {
            return null;
        }

        public String getExtractToClassName() {
            return null;
        }

        public float getFloatValue(InternalWorkingMemory workingMemory, Object object) {
            return 0.0f;
        }

        public int getIntValue(InternalWorkingMemory workingMemory, Object object) {
            return 0;
        }

        public long getLongValue(InternalWorkingMemory workingMemory, Object object) {
            return 0L;
        }

        public Method getNativeReadMethod() {
            return null;
        }

        public String getNativeReadMethodName() {
            return null;
        }

        public short getShortValue(InternalWorkingMemory workingMemory, Object object) {
            return 0;
        }

        public Object getValue(InternalWorkingMemory workingMemory, Object object) {
            return null;
        }

        public boolean isNullValue(Object object, InternalWorkingMemory workingMemory) {
            return false;
        }

        public ValueType getValueType() {
            return ValueType.STRING_TYPE;
        }

        public int getHashCode(InternalWorkingMemory workingMemory, Object object) {
            return 0;
        }

        public boolean isGlobal() {
            return false;
        }

        public boolean isNullValue(InternalWorkingMemory workingMemory, Object object) {
            return false;
        }

        public boolean getBooleanValue(Object object) {
            return false;
        }

        public byte getByteValue(Object object) {
            return 0;
        }

        public char getCharValue(Object object) {
            return '\u0000';
        }

        public double getDoubleValue(Object object) {
            return 0.0;
        }

        public float getFloatValue(Object object) {
            return 0.0f;
        }

        public int getHashCode(Object object) {
            return 0;
        }

        public int getIntValue(Object object) {
            return 0;
        }

        public long getLongValue(Object object) {
            return 0L;
        }

        public short getShortValue(Object object) {
            return 0;
        }

        public Object getValue(Object object) {
            return null;
        }

        public boolean isNullValue(Object object) {
            return false;
        }

        public boolean isSelfReference() {
            return false;
        }

        public BigDecimal getBigDecimalValue(InternalWorkingMemory workingMemory, Object object) {
            return null;
        }

        public BigInteger getBigIntegerValue(InternalWorkingMemory workingMemory, Object object) {
            return null;
        }

        public BigDecimal getBigDecimalValue(Object object) {
            return null;
        }

        public BigInteger getBigIntegerValue(Object object) {
            return null;
        }
    }
}

