/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.compiler;

import java.io.Serializable;
import java.util.Date;
import org.drools.mvel.compiler.StockTickInterface;

public class StockTick
implements Serializable,
StockTickInterface {
    private static final long serialVersionUID = 510L;
    private long seq;
    private String company;
    private double price;
    private long time;
    private long duration;

    public StockTick() {
    }

    public StockTick(long seq, String company, double price) {
        this(seq, company, price, System.currentTimeMillis());
    }

    public StockTick(long seq, String company, double price, long time) {
        this.seq = seq;
        this.company = company;
        this.price = price;
        this.time = time;
    }

    public StockTick(long seq, String company, double price, long time, long duration) {
        this.seq = seq;
        this.company = company;
        this.price = price;
        this.time = time;
        this.duration = duration;
    }

    @Override
    public String getCompany() {
        return this.company;
    }

    @Override
    public void setCompany(String company) {
        this.company = company;
    }

    @Override
    public double getPrice() {
        return this.price;
    }

    @Override
    public void setPrice(double price) {
        this.price = price;
    }

    @Override
    public long getSeq() {
        return this.seq;
    }

    @Override
    public void setSeq(long seq) {
        this.seq = seq;
    }

    @Override
    public long getTime() {
        return this.time;
    }

    @Override
    public void setTime(long time) {
        this.time = time;
    }

    public String toString() {
        return "StockTick( " + this.seq + " : " + this.company + " : " + this.price + " )";
    }

    @Override
    public long getDuration() {
        return this.duration;
    }

    @Override
    public void setDuration(long duration) {
        this.duration = duration;
    }

    @Override
    public Date getDateTimestamp() {
        return new Date(this.time);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.company == null ? 0 : this.company.hashCode());
        result = 31 * result + (int)(this.seq ^ this.seq >>> 32);
        result = 31 * result + (int)(this.time ^ this.time >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        StockTick other = (StockTick)obj;
        if (this.company == null ? other.company != null : !this.company.equals(other.company)) {
            return false;
        }
        if (this.seq != other.seq) {
            return false;
        }
        return this.time == other.time;
    }
}

