/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.integrationtests;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import org.drools.core.definitions.impl.KnowledgePackageImpl;
import org.drools.core.definitions.rule.impl.RuleImpl;
import org.drools.core.impl.InternalKnowledgeBase;
import org.drools.core.impl.KnowledgeBaseFactory;
import org.drools.core.rule.TypeDeclaration;
import org.drools.core.util.DroolsStreamUtils;
import org.drools.core.util.FileManager;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.kie.api.definition.KiePackage;
import org.kie.api.definition.rule.Rule;
import org.kie.api.definition.type.FactType;
import org.kie.api.internal.utils.ServiceRegistry;
import org.kie.api.io.Resource;
import org.kie.api.io.ResourceType;
import org.kie.api.runtime.KieSession;
import org.kie.internal.builder.KnowledgeBuilder;
import org.kie.internal.builder.KnowledgeBuilderFactory;
import org.kie.internal.io.ResourceFactory;

public class KnowledgeBuilderTest {
    private FileManager fileManager;

    @Before
    public void setUp() throws Exception {
        this.fileManager = new FileManager().setUp();
    }

    @After
    public void tearDown() throws Exception {
        this.fileManager.tearDown();
    }

    @Test
    public void testCompositeKnowledgeBuilder() throws Exception {
        String rule = "package org.drools.mvel.compiler.test\nrule R1 when\n   $fieldA : FactA( $fieldB : fieldB )\n   FactB( this == $fieldB, fieldA == $fieldA )\nthen\nend";
        String declarationA = "package org.drools.mvel.compiler.test\ndeclare FactA\n    fieldB: FactB\nend\n";
        String declarationB = "package org.drools.mvel.compiler.test\ndeclare FactB\n    fieldA: FactA\nend\n";
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])rule.getBytes()), ResourceType.DRL);
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])declarationA.getBytes()), ResourceType.DRL);
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])declarationB.getBytes()), ResourceType.DRL);
        Assert.assertTrue((boolean)kbuilder.hasErrors());
        kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])declarationA.getBytes()), ResourceType.DRL);
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])declarationB.getBytes()), ResourceType.DRL);
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])rule.getBytes()), ResourceType.DRL);
        Assert.assertTrue((boolean)kbuilder.hasErrors());
        KnowledgeBuilder kbuilder2 = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder2.batch().add(ResourceFactory.newByteArrayResource((byte[])rule.getBytes()), ResourceType.DRL).add(ResourceFactory.newByteArrayResource((byte[])declarationA.getBytes()), ResourceType.DRL).add(ResourceFactory.newByteArrayResource((byte[])declarationB.getBytes()), ResourceType.DRL).build();
        if (kbuilder2.hasErrors()) {
            Assert.fail((String)kbuilder2.getErrors().toString());
        }
        InternalKnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addPackages(kbuilder2.getKnowledgePackages());
        KieSession ksession = kbase.newKieSession();
        FactType aType = kbase.getFactType("org.drools.mvel.compiler.test", "FactA");
        Object a = aType.newInstance();
        FactType bType = kbase.getFactType("org.drools.mvel.compiler.test", "FactB");
        Object b = bType.newInstance();
        aType.set(a, "fieldB", b);
        bType.set(b, "fieldA", a);
        a.toString();
        b.toString();
        ksession.insert(a);
        ksession.insert(b);
        int rules = ksession.fireAllRules();
        Assert.assertEquals((long)1L, (long)rules);
    }

    @Test
    public void testDifferentPackages() throws Exception {
        String rule = "package org.drools.mvel.compiler.test.rule\nimport org.drools.mvel.compiler.testA.FactA\nimport org.drools.mvel.compiler.testB.FactB\nrule R1 when\n   $fieldA : FactA( $fieldB : fieldB, bigint == 1 )\n   FactB( this == $fieldB, fieldA == $fieldA )\nthen\n   list.add(\"OK\");end";
        String declarationA = "package org.drools.mvel.compiler.testA\nimport org.drools.mvel.compiler.testB.FactB\nimport java.math.BigInteger\ndeclare FactA\n    fieldB: FactB\n    bigint: BigInteger\nend\n";
        String declarationB = "package org.drools.mvel.compiler.testB\nimport org.drools.mvel.compiler.testA.FactA\nglobal java.util.List list\ndeclare FactB\n    fieldA: FactA\nend\n";
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.batch().type(ResourceType.DRL).add(ResourceFactory.newByteArrayResource((byte[])rule.getBytes())).add(ResourceFactory.newByteArrayResource((byte[])declarationA.getBytes())).add(ResourceFactory.newByteArrayResource((byte[])declarationB.getBytes())).build();
        if (kbuilder.hasErrors()) {
            Assert.fail((String)kbuilder.getErrors().toString());
        }
        String declarationC = "package org.drools.mvel.compiler.testA\ndeclare FactC\n    field : UnknownClass\nend\n";
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])declarationC.getBytes()), ResourceType.DRL);
        Assert.assertTrue((boolean)kbuilder.hasErrors());
        kbuilder.undo();
        Assert.assertFalse((boolean)kbuilder.hasErrors());
        InternalKnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addPackages(kbuilder.getKnowledgePackages());
        KieSession ksession = kbase.newKieSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        FactType aType = kbase.getFactType("org.drools.mvel.compiler.testA", "FactA");
        Object a = aType.newInstance();
        FactType bType = kbase.getFactType("org.drools.mvel.compiler.testB", "FactB");
        Object b = bType.newInstance();
        aType.set(a, "fieldB", b);
        aType.set(a, "bigint", (Object)new BigInteger("1"));
        bType.set(b, "fieldA", a);
        ksession.insert(a);
        ksession.insert(b);
        int rules = ksession.fireAllRules();
        Assert.assertEquals((long)1L, (long)rules);
        Assert.assertEquals((Object)"OK", list.get(0));
    }

    @Test
    @Ignore(value="All the classes generated by type declarations are now defined in the ProjectClassLoader")
    public void testUndoTypeDeclaration() throws Exception {
        String rule = "package org.drools.mvel.compiler.test\nimport org.drools.compiler.test.FactA\nimport org.drools.compiler.test.FactB\nrule R1 when\n   FactA( i == 1 )\n   FactB( i == 1 )\nthen\n   list.add(\"OK\");end\n";
        String declarationA = "package org.drools.mvel.compiler.test\nglobal java.util.List list\ndeclare FactA\n    j : int\nend\n";
        String declarationB = "package org.drools.mvel.compiler.test\ndeclare FactB\n    i : int\nend\n";
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])declarationB.getBytes()), ResourceType.DRL);
        Assert.assertFalse((boolean)kbuilder.hasErrors());
        kbuilder.batch().type(ResourceType.DRL).add(ResourceFactory.newByteArrayResource((byte[])rule.getBytes())).add(ResourceFactory.newByteArrayResource((byte[])declarationA.getBytes())).build();
        Assert.assertTrue((boolean)kbuilder.hasErrors());
        kbuilder.undo();
        Assert.assertFalse((boolean)kbuilder.hasErrors());
        declarationA = "package org.drools.mvel.compiler.test\nglobal java.util.List list\ndeclare FactA\n    i : int\nend\n";
        kbuilder.batch().type(ResourceType.DRL).add(ResourceFactory.newByteArrayResource((byte[])rule.getBytes())).add(ResourceFactory.newByteArrayResource((byte[])declarationA.getBytes())).build();
        Assert.assertFalse((boolean)kbuilder.hasErrors());
        InternalKnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addPackages(kbuilder.getKnowledgePackages());
        KieSession ksession = kbase.newKieSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        FactType aType = kbase.getFactType("org.drools.mvel.compiler.test", "FactA");
        Object a = aType.newInstance();
        aType.set(a, "i", (Object)1);
        FactType bType = kbase.getFactType("org.drools.mvel.compiler.test", "FactB");
        Object b = bType.newInstance();
        bType.set(b, "i", (Object)1);
        ksession.insert(a);
        ksession.insert(b);
        int rules = ksession.fireAllRules();
        Assert.assertEquals((long)1L, (long)rules);
        Assert.assertEquals((Object)"OK", list.get(0));
    }

    @Test
    public void testUndoRule() throws Exception {
        String rule = "package org.drools.mvel.compiler.test\nglobal java.util.List list\nimport org.drools.mvel.compiler.test.FactA\nimport org.drools.mvel.compiler.test.FactB\nrule R1 when\n   FactA( j == 1 )\n   FactB( i == 1 )\nthen\n   list.add(\"OK\");end\n";
        String declarationA = "package org.drools.mvel.compiler.test\ndeclare FactA\n    i : int\nend\n";
        String declarationB = "package org.drools.mvel.compiler.test\ndeclare FactB\n    i : int\nend\n";
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])declarationB.getBytes()), ResourceType.DRL);
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])declarationA.getBytes()), ResourceType.DRL);
        Assert.assertFalse((boolean)kbuilder.hasErrors());
        kbuilder.batch().type(ResourceType.DRL).add(ResourceFactory.newByteArrayResource((byte[])rule.getBytes())).build();
        Assert.assertTrue((boolean)kbuilder.hasErrors());
        kbuilder.undo();
        Assert.assertFalse((boolean)kbuilder.hasErrors());
        rule = "package org.drools.mvel.compiler.test\nglobal java.util.List list\nimport org.drools.mvel.compiler.test.FactA\nimport org.drools.mvel.compiler.test.FactB\nrule R1 when\n   FactA( i == 1 )\n   FactB( i == 1 )\nthen\n   list.add(\"OK\");end\n";
        kbuilder.batch().type(ResourceType.DRL).add(ResourceFactory.newByteArrayResource((byte[])rule.getBytes())).add(ResourceFactory.newByteArrayResource((byte[])declarationA.getBytes())).build();
        Assert.assertFalse((boolean)kbuilder.hasErrors());
        InternalKnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addPackages(kbuilder.getKnowledgePackages());
        KieSession ksession = kbase.newKieSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        FactType aType = kbase.getFactType("org.drools.mvel.compiler.test", "FactA");
        Object a = aType.newInstance();
        aType.set(a, "i", (Object)1);
        FactType bType = kbase.getFactType("org.drools.mvel.compiler.test", "FactB");
        Object b = bType.newInstance();
        bType.set(b, "i", (Object)1);
        ksession.insert(a);
        ksession.insert(b);
        int rules = ksession.fireAllRules();
        Assert.assertEquals((long)1L, (long)rules);
        Assert.assertEquals((Object)"OK", list.get(0));
    }

    @Test
    public void testAddKPackageSingle() throws Exception {
        String rule = "package org.drools.mvel.compiler.test\nimport org.drools.mvel.compiler.StockTick\nrule R1 when\n   StockTick()\nthen\nend\n";
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])rule.getBytes()), ResourceType.DRL);
        Assert.assertFalse((String)kbuilder.getErrors().toString(), (boolean)kbuilder.hasErrors());
        Collection kpkgs = kbuilder.getKnowledgePackages();
        Assert.assertEquals((long)2L, (long)kpkgs.size());
        KiePackage kpkg = (KiePackage)kpkgs.iterator().next();
        byte[] skpkg = DroolsStreamUtils.streamOut((Object)kpkg);
        kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])skpkg), ResourceType.PKG);
        Assert.assertFalse((String)kbuilder.getErrors().toString(), (boolean)kbuilder.hasErrors());
        kpkgs = kbuilder.getKnowledgePackages();
        Assert.assertEquals((long)1L, (long)kpkgs.size());
        kpkg = (KiePackage)kpkgs.iterator().next();
        Assert.assertEquals((long)1L, (long)kpkg.getRules().size());
    }

    @Test
    public void testAddKPackageCollection() throws Exception {
        String rule = "package org.drools.mvel.compiler.test\nimport org.drools.mvel.compiler.StockTick\ndeclare StockTick @role(event) end\nrule R1 when\n   StockTick()\nthen\nend\n";
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])rule.getBytes()), ResourceType.DRL);
        Assert.assertFalse((String)kbuilder.getErrors().toString(), (boolean)kbuilder.hasErrors());
        Collection kpkgs = kbuilder.getKnowledgePackages();
        Assert.assertEquals((long)2L, (long)kpkgs.size());
        byte[] skpkg = DroolsStreamUtils.streamOut((Object)kpkgs);
        kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])skpkg), ResourceType.PKG);
        Assert.assertFalse((String)kbuilder.getErrors().toString(), (boolean)kbuilder.hasErrors());
        kpkgs = kbuilder.getKnowledgePackages();
        Assert.assertEquals((long)2L, (long)kpkgs.size());
    }

    @Test
    public void testAddPackageSingle() throws Exception {
        String rule = "package org.drools.mvel.compiler.test\nimport org.drools.mvel.compiler.StockTick\nrule R1 when\n   StockTick()\nthen\nend\n";
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])rule.getBytes()), ResourceType.DRL);
        Assert.assertFalse((String)kbuilder.getErrors().toString(), (boolean)kbuilder.hasErrors());
        Collection kpkgs = kbuilder.getKnowledgePackages();
        Assert.assertEquals((long)2L, (long)kpkgs.size());
        KiePackage kpkg = (KiePackage)kpkgs.iterator().next();
        Assert.assertEquals((long)1L, (long)kpkg.getRules().size());
    }

    @Test
    public void testAddPackageArray() throws Exception {
        String rule = "package org.drools.mvel.compiler.test\nimport org.drools.mvel.compiler.StockTick\ndeclare StockTick @role(event) end\nrule R1 when\n   StockTick()\nthen\nend\n";
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])rule.getBytes()), ResourceType.DRL);
        Assert.assertFalse((String)kbuilder.getErrors().toString(), (boolean)kbuilder.hasErrors());
        Collection kpkgs = kbuilder.getKnowledgePackages();
        Assert.assertEquals((long)2L, (long)kpkgs.size());
    }

    @Ignore
    @Test
    public void testResourceMapping() throws Exception {
        ServiceRegistry.Impl serviceRegistry = (ServiceRegistry.Impl)ServiceRegistry.getInstance();
        serviceRegistry.reset();
        serviceRegistry.reload();
        String rule = "package org.drools.mvel.compiler.test\nrule R1 when\n \nthen\nend\n";
        Resource res1 = ResourceFactory.newByteArrayResource((byte[])rule.getBytes());
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(res1, ResourceType.DRL);
        Assert.assertFalse((String)kbuilder.getErrors().toString(), (boolean)kbuilder.hasErrors());
        KiePackage kp1 = (KiePackage)kbuilder.getKnowledgePackages().iterator().next();
        Assert.assertEquals((long)1L, (long)kp1.getRules().size());
        Rule r = (Rule)kp1.getRules().iterator().next();
        Assert.assertEquals((Object)res1, (Object)((RuleImpl)r).getResource());
        String pmml = "<PMML version=\"4.0\"><Header/></PMML>";
        Resource res2 = ResourceFactory.newByteArrayResource((byte[])pmml.getBytes());
        KnowledgeBuilder kbuilder2 = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder2.add(res2, ResourceType.PMML);
        Assert.assertFalse((String)kbuilder2.getErrors().toString(), (boolean)kbuilder2.hasErrors());
        KiePackage kp2 = (KiePackage)kbuilder2.getKnowledgePackages().iterator().next();
        Assert.assertEquals((long)1L, (long)kp2.getRules().size());
        Rule r2 = (Rule)kp2.getRules().iterator().next();
        Assert.assertEquals((Object)res2, (Object)((RuleImpl)r2).getResource());
    }

    @Test
    public void testRepeatedDeclarationInMultiplePackages() {
        String str = "package org.drools.test1;\nimport org.drools.mvel.compiler.Cheese;\nrule R\nwhen Cheese() then end \n";
        String str2 = "package org.drools.test2;\nimport org.drools.mvel.compiler.Cheese;\nrule S\nwhen Cheese() then end \n";
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])str.getBytes()), ResourceType.DRL);
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])str2.getBytes()), ResourceType.DRL);
        Assert.assertEquals((long)3L, (long)kbuilder.getKnowledgePackages().size());
        for (KiePackage kp : kbuilder.getKnowledgePackages()) {
            KnowledgePackageImpl kpi = (KnowledgePackageImpl)kp;
            TypeDeclaration cheez = kpi.getTypeDeclaration("Cheese");
            if ("org.drools.mvel.compiler".equals(kpi.getName())) {
                Assert.assertNotNull((Object)cheez);
                continue;
            }
            Assert.assertNull((Object)cheez);
        }
    }
}

