/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.integrationtests;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.drools.compiler.compiler.DroolsParserException;
import org.drools.core.common.DroolsObjectInputStream;
import org.drools.core.common.DroolsObjectOutputStream;
import org.drools.core.impl.InternalKnowledgeBase;
import org.drools.core.impl.KnowledgeBaseFactory;
import org.kie.api.KieBase;
import org.kie.api.io.ResourceType;
import org.kie.internal.builder.KnowledgeBuilder;
import org.kie.internal.builder.KnowledgeBuilderFactory;
import org.kie.internal.io.ResourceFactory;

public class LargeRuleBase {
    private static final int RULE_COUNT = 20000;

    public static void main(String[] args) throws Exception {
        System.err.println(Runtime.getRuntime().freeMemory());
        LargeRuleBase.bigBlobCompile();
        System.gc();
        Thread.sleep(5000L);
        System.err.println(Runtime.getRuntime().freeMemory());
    }

    private static void bigBlobCompile() throws DroolsParserException, IOException, Exception {
        StringBuilder buf = new StringBuilder();
        buf.append(LargeRuleBase.getHeader());
        int i = 0;
        while (i < 1) {
            String name = "x" + i;
            int status = i++;
            String r = LargeRuleBase.getTemplate1(name, status);
            buf.append(r);
        }
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])buf.toString().getBytes()), ResourceType.DRL);
        InternalKnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addPackages(kbuilder.getKnowledgePackages());
        File f = new File("foo.rulebase");
        if (f.exists()) {
            f.delete();
        }
        DroolsObjectOutputStream out = new DroolsObjectOutputStream((OutputStream)new FileOutputStream(f));
        out.writeObject(kbase);
        out.flush();
        out.close();
        DroolsObjectInputStream in = new DroolsObjectInputStream((InputStream)new FileInputStream(f));
        KieBase rb_ = (KieBase)in.readObject();
    }

    public static String getHeader() {
        return "package org.kie.test; \n import org.drools.mvel.compiler.Person; \n import org.drools.mvel.compiler.Cheese; \n import org.drools.compiler.Cheesery; \n  import java.util.List \n  global List list \n dialect 'mvel'\n  ";
    }

    public static String getTemplate1(String name, int status) {
        return "rule 'match Person " + name + "' \n agenda-group 'xxx' \n salience ($age2 - $age1) \n  dialect 'mvel' \n\twhen \n  \t\t$person : Person(name=='" + name + "', $age1 : age ) \n \t    cheesery : Cheesery( cheeses contains $person, status == " + status + " ) \n  \t\tcheeses : List() from cheesery.getCheeses() \n \t\tPerson( age < ( $age1 ) ) \n \t\tPerson( $age2 : age, eval( $age1 == $age2 ) ) \n \t\teval( $age1 == $age2 ) \n    then \n \t\tlist.add( $person ); \n \t\t$person.setStatus(\"match Person ok\"); \n  end \n";
    }

    private static String getTemplate2(String name, int num, int status) {
        return "rule 'match Person " + num + "' \n dialect 'mvel' \n\twhen \n  \t\t$person : Person(name=='" + name + "', $age1 : age ) \n \t    cheesery : Cheesery( cheeses contains $person, status == " + status + " ) \n  Person(age < " + num + ") \n then \n \t\tlist.add( $person ); \n \t\t$person.setStatus(\"match Person ok\"); \n  end \n";
    }
}

