/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.integrationtests;

import java.util.Collection;
import org.drools.testcoverage.common.util.KieBaseTestConfiguration;
import org.drools.testcoverage.common.util.KieBaseUtil;
import org.drools.testcoverage.common.util.TestParametersUtil;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.KieBase;
import org.kie.api.definition.type.FactType;
import org.kie.api.runtime.KieSession;

@RunWith(value=Parameterized.class)
public class TypeDeclarationTest {
    private final KieBaseTestConfiguration kieBaseTestConfiguration;

    public TypeDeclarationTest(KieBaseTestConfiguration kieBaseTestConfiguration) {
        this.kieBaseTestConfiguration = kieBaseTestConfiguration;
    }

    @Parameterized.Parameters(name="KieBase type={0}")
    public static Collection<Object[]> getParameters() {
        return TestParametersUtil.getKieBaseCloudConfigurations((boolean)true);
    }

    @Test
    public void testRecursiveDeclaration() throws Exception {
        String rule = "package org.drools.compiler\ndeclare Node\n    value: String\n    parent: Node\nend\nrule R1 when\n   $parent: Node( value == \"parent\" )\n   $child: Node( $value : value, parent == $parent )\nthen\n   System.out.println( $value );\nend";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{rule});
        KieSession ksession = kbase.newKieSession();
        FactType nodeType = kbase.getFactType("org.drools.compiler", "Node");
        Object parent = nodeType.newInstance();
        nodeType.set(parent, "value", (Object)"parent");
        ksession.insert(parent);
        Object child = nodeType.newInstance();
        nodeType.set(child, "value", (Object)"child");
        nodeType.set(child, "parent", parent);
        ksession.insert(child);
        int rules = ksession.fireAllRules();
        Assert.assertEquals((long)1L, (long)rules);
    }

    @Test
    public void testCircularDeclaration() throws Exception {
        String rule = "package org.drools.mvel.compiler.test\ndeclare FactA\n    fieldB: FactB\nend\ndeclare FactB\n    fieldA: FactA\nend\nrule R1 when\n   $fieldA : FactA( $fieldB : fieldB )\n   FactB( this == $fieldB, fieldA == $fieldA )\nthen\nend";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{rule});
        KieSession ksession = kbase.newKieSession();
        FactType aType = kbase.getFactType("org.drools.mvel.compiler.test", "FactA");
        Object a = aType.newInstance();
        FactType bType = kbase.getFactType("org.drools.mvel.compiler.test", "FactB");
        Object b = bType.newInstance();
        aType.set(a, "fieldB", b);
        bType.set(b, "fieldA", a);
        ksession.insert(a);
        ksession.insert(b);
        int rules = ksession.fireAllRules();
        Assert.assertEquals((long)1L, (long)rules);
    }

    @Test
    public void testCircularDeclarationWithExtension() throws Exception {
        String drl = "package org.drools.mvel.compiler.test\ndeclare FactA\n    fieldB: FactB\nend\ndeclare FactB extends FactA end\nrule R1 when\n   $a : FactA( )\n   $b : FactB( this == $a.fieldB )\nthen\nend";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession ksession = kbase.newKieSession();
        FactType aType = kbase.getFactType("org.drools.mvel.compiler.test", "FactA");
        FactType bType = kbase.getFactType("org.drools.mvel.compiler.test", "FactB");
        Object a = aType.newInstance();
        Object b = bType.newInstance();
        aType.set(a, "fieldB", b);
        ksession.insert(a);
        ksession.insert(b);
        int rules = ksession.fireAllRules();
        Assert.assertEquals((long)1L, (long)rules);
    }
}

