/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.compiler.api;

import java.util.Collection;
import org.junit.Assert;
import org.junit.Test;
import org.kie.api.KieServices;
import org.kie.api.builder.KieFileSystem;
import org.kie.api.builder.Results;
import org.kie.api.definition.KiePackage;
import org.kie.api.definition.rule.Rule;
import org.kie.api.io.ResourceType;
import org.kie.internal.builder.KnowledgeBuilder;
import org.kie.internal.builder.KnowledgeBuilderFactory;
import org.kie.internal.io.ResourceFactory;

public class KnowledgeBuilderTest {
    @Test
    public void testKnowledgeProvider() {
        KnowledgeBuilder builder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        Assert.assertNotNull((Object)builder);
    }

    @Test
    public void testKnowledgeProviderWithRules() {
        KnowledgeBuilder builder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        String str = "";
        str = str + "package org.drools.mvel.compiler.test1\n";
        str = str + "rule rule1\n";
        str = str + "when\n";
        str = str + "then\n";
        str = str + "end\n\n";
        str = str + "rule rule2\n";
        str = str + "when\n";
        str = str + "then\n";
        str = str + "end\n";
        builder.add(ResourceFactory.newByteArrayResource((byte[])str.getBytes()), ResourceType.DRL);
        str = "package org.drools.mvel.compiler.test2\n";
        str = str + "rule rule3\n";
        str = str + "when\n";
        str = str + "then\n";
        str = str + "end\n\n";
        str = str + "rule rule4\n";
        str = str + "when\n";
        str = str + "then\n";
        str = str + "end\n";
        builder.add(ResourceFactory.newByteArrayResource((byte[])str.getBytes()), ResourceType.DRL);
        Collection pkgs = builder.getKnowledgePackages();
        Assert.assertNotNull((Object)pkgs);
        Assert.assertEquals((long)2L, (long)pkgs.size());
        KiePackage test1 = this.getKnowledgePackage(pkgs, "org.drools.mvel.compiler.test1");
        Collection rules = test1.getRules();
        Assert.assertEquals((long)2L, (long)rules.size());
        Rule rule = this.getRule(rules, "rule1");
        Assert.assertEquals((Object)"rule1", (Object)rule.getName());
        rule = this.getRule(rules, "rule2");
        Assert.assertEquals((Object)"rule2", (Object)rule.getName());
        KiePackage test2 = this.getKnowledgePackage(pkgs, "org.drools.mvel.compiler.test2");
        rules = test2.getRules();
        Assert.assertEquals((long)2L, (long)rules.size());
        rule = this.getRule(rules, "rule3");
        Assert.assertEquals((Object)"rule3", (Object)rule.getName());
        rule = this.getRule(rules, "rule4");
        Assert.assertEquals((Object)"rule4", (Object)rule.getName());
    }

    public Rule getRule(Collection<Rule> rules, String name) {
        for (Rule rule : rules) {
            if (!rule.getName().equals(name)) continue;
            return rule;
        }
        return null;
    }

    public KiePackage getKnowledgePackage(Collection<KiePackage> pkgs, String name) {
        for (KiePackage pkg : pkgs) {
            if (!pkg.getName().equals(name)) continue;
            return pkg;
        }
        return null;
    }

    @Test
    public void testMalformedDrl() throws Exception {
        KieFileSystem kfs;
        byte[] content = new byte[]{4, 68, 0, 0, 96, 0, 0, 0};
        KieServices ks = KieServices.Factory.get();
        Results results = ks.newKieBuilder(kfs = ks.newKieFileSystem().write("src/main/resources/r1.drl", new String(content))).buildAll().getResults();
        Assert.assertTrue((results.getMessages().size() > 0 ? 1 : 0) != 0);
    }
}

