/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.integrationtests;

import java.util.Collection;
import org.drools.mvel.compiler.Cheese;
import org.drools.testcoverage.common.util.KieBaseTestConfiguration;
import org.drools.testcoverage.common.util.KieBaseUtil;
import org.drools.testcoverage.common.util.TestParametersUtil;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.KieBase;
import org.kie.api.runtime.KieSession;

@RunWith(value=Parameterized.class)
public class TreeTest {
    private final KieBaseTestConfiguration kieBaseTestConfiguration;

    public TreeTest(KieBaseTestConfiguration kieBaseTestConfiguration) {
        this.kieBaseTestConfiguration = kieBaseTestConfiguration;
    }

    @Parameterized.Parameters(name="KieBase type={0}")
    public static Collection<Object[]> getParameters() {
        return TestParametersUtil.getKieBaseCloudConfigurations((boolean)true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUnbalancedTrees() throws Exception {
        KieBase kbase = KieBaseUtil.getKieBaseFromClasspathResources(this.getClass(), (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"test_UnbalancedTrees.drl"});
        KieSession wm = kbase.newKieSession();
        try {
            wm.insert((Object)new Cheese("a", 10));
            wm.insert((Object)new Cheese("b", 10));
            wm.insert((Object)new Cheese("c", 10));
            wm.insert((Object)new Cheese("d", 10));
            Cheese e = new Cheese("e", 10);
            wm.insert((Object)e);
            wm.fireAllRules();
            Assert.assertEquals((String)"Rule should have fired twice, seting the price to 30", (long)30L, (long)e.getPrice());
        }
        finally {
            wm.dispose();
        }
    }
}

