/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.integrationtests.phreak;

import java.util.ArrayList;
import java.util.List;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.common.PhreakPropagationContext;
import org.drools.core.reteoo.BetaMemory;
import org.drools.core.reteoo.BetaNode;
import org.drools.core.reteoo.LeftTuple;
import org.drools.core.reteoo.SegmentMemory;
import org.drools.core.reteoo.TupleMemory;
import org.drools.core.spi.PropagationContext;
import org.drools.mvel.integrationtests.phreak.RightMemory;
import org.drools.mvel.integrationtests.phreak.Scenario;
import org.drools.mvel.integrationtests.phreak.StagedBuilder;

public class LeftMemory {
    private Scenario scenario;

    public LeftMemory(Scenario scenario, Object ... objects) {
        this.scenario = scenario;
        scenario.getLeftMemory().addAll(this.getLeftTuples(objects));
    }

    public List<LeftTuple> getLeftTuples(Object ... objects) {
        BetaNode node = this.scenario.getBetaNode();
        BetaMemory bm = this.scenario.getBm();
        TupleMemory ltm = bm.getLeftTupleMemory();
        InternalWorkingMemory wm = this.scenario.getWorkingMemory();
        if (objects == null) {
            objects = new Object[]{};
        }
        ArrayList<LeftTuple> list = new ArrayList<LeftTuple>();
        for (Object object : objects) {
            InternalFactHandle fh = (InternalFactHandle)wm.insert(object);
            LeftTuple expectedLeftTuple = node.createLeftTuple(fh, true);
            expectedLeftTuple.setPropagationContext((PropagationContext)new PhreakPropagationContext());
            list.add(expectedLeftTuple);
        }
        this.scenario.setTestLeftMemory(true);
        return list;
    }

    public RightMemory right(Object ... objects) {
        return new RightMemory(this.scenario, objects);
    }

    public StagedBuilder preStaged(SegmentMemory sm) {
        StagedBuilder stagedBuilder = new StagedBuilder(this.scenario, sm);
        this.scenario.addPreStagedBuilder(stagedBuilder);
        return stagedBuilder;
    }

    public StagedBuilder postStaged(SegmentMemory sm) {
        StagedBuilder stagedBuilder = new StagedBuilder(this.scenario, sm);
        this.scenario.addPostStagedBuilder(stagedBuilder);
        return stagedBuilder;
    }

    public Scenario run() {
        return this.scenario.run();
    }
}

