/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.integrationtests;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.drools.compiler.integrationtests.ConstraintConcurrencyTest;
import org.drools.testcoverage.common.util.KieBaseTestConfiguration;
import org.drools.testcoverage.common.util.KieBaseUtil;
import org.drools.testcoverage.common.util.TestParametersUtil;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.KieBase;
import org.kie.api.runtime.KieSession;
import org.kie.test.testcategory.TurtleTestCategory;

@RunWith(value=Parameterized.class)
@Category(value={TurtleTestCategory.class})
public class MVELDateClassFieldReaderConcurrencyTest {
    private static int LOOP = 500;
    private static int THREADS = 32;
    private static int REQUESTS = 32;
    private final KieBaseTestConfiguration kieBaseTestConfiguration;

    public MVELDateClassFieldReaderConcurrencyTest(KieBaseTestConfiguration kieBaseTestConfiguration) {
        this.kieBaseTestConfiguration = kieBaseTestConfiguration;
    }

    @Parameterized.Parameters(name="KieBase type={0}")
    public static Collection<Object[]> getParameters() {
        return TestParametersUtil.getKieBaseCloudConfigurations((boolean)false);
    }

    @Test(timeout=300000L)
    public void testMVELDateClassFieldReaderConcurrency() {
        String drl = "package com.example.reproducer\nimport " + ConstraintConcurrencyTest.Bus.class.getCanonicalName() + ";\nimport java.util.Date;\ndialect \"mvel\"\nrule R1\n    when\n        $d : Date()\n        $bus1 : Bus( new Date(name.concat(karaoke.dvd[\"POWER PLANT\"].artist).length) == $d )\n    then\nend\n";
        final ArrayList exceptions = new ArrayList();
        KieBase kieBase = null;
        if (this.kieBaseTestConfiguration.isExecutableModel()) {
            kieBase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"accumulate-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        }
        for (int i = 0; i < LOOP; ++i) {
            if (!this.kieBaseTestConfiguration.isExecutableModel()) {
                kieBase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"accumulate-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
            }
            ExecutorService executor = Executors.newFixedThreadPool(THREADS);
            final CountDownLatch latch = new CountDownLatch(THREADS);
            for (int j = 0; j < REQUESTS; ++j) {
                final KieBase finalKieBase = kieBase;
                executor.execute(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        KieSession kSession = finalKieBase.newKieSession();
                        ConstraintConcurrencyTest.Bus bus1 = new ConstraintConcurrencyTest.Bus("red", 30);
                        bus1.getKaraoke().getDvd().put("POWER PLANT", new ConstraintConcurrencyTest.Album("POWER PLANT", "GAMMA RAY"));
                        bus1.getKaraoke().getDvd().put("Somewhere Out In Space", new ConstraintConcurrencyTest.Album("Somewhere Out In Space", "GAMMA RAY"));
                        kSession.insert((Object)bus1);
                        kSession.insert((Object)new Date());
                        try {
                            latch.countDown();
                            latch.await();
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        try {
                            kSession.fireAllRules();
                        }
                        catch (Exception e) {
                            if (exceptions.isEmpty()) {
                                e.printStackTrace();
                            }
                            exceptions.add(e);
                        }
                        finally {
                            kSession.dispose();
                        }
                    }
                });
            }
            executor.shutdown();
            try {
                executor.awaitTermination(10L, TimeUnit.SECONDS);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        Assert.assertEquals((long)0L, (long)exceptions.size());
    }
}

