/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.compiler.kie.builder.impl;

import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.drools.compiler.compiler.io.memory.MemoryFile;
import org.drools.compiler.compiler.io.memory.MemoryFileSystem;
import org.drools.compiler.compiler.io.memory.MemoryFolder;
import org.drools.compiler.kie.builder.impl.MemoryKieModule;
import org.drools.reflective.ResourceProvider;
import org.junit.Test;
import org.kie.api.builder.ReleaseId;
import org.kie.api.builder.model.KieModuleModel;
import org.mockito.Mock;

public class MemoryKieModuleResourceProviderTest {
    @Mock
    ReleaseId releaseId;
    @Mock
    KieModuleModel kieModuleModel;

    @Test
    public void testGetResourceForEmptyFolder() throws Exception {
        MemoryFileSystem mfs = new MemoryFileSystem();
        mfs.createFolder(new MemoryFolder(mfs, "src/main/java"));
        MemoryKieModule mkm = new MemoryKieModule(this.releaseId, this.kieModuleModel, mfs);
        ResourceProvider resourceProvider = mkm.createResourceProvider();
        String folderContents = IOUtils.toString((InputStream)resourceProvider.getResource("src/main/java").openStream());
        Assertions.assertThat((String)folderContents).isEmpty();
    }

    @Test
    public void testGetResourceForFolderWithOnlySubFolders() throws Exception {
        MemoryFileSystem mfs = new MemoryFileSystem();
        mfs.createFolder(new MemoryFolder(mfs, "src/main/java"));
        mfs.createFolder(new MemoryFolder(mfs, "src/main/java/org"));
        mfs.createFolder(new MemoryFolder(mfs, "src/main/java/com"));
        MemoryKieModule mkm = new MemoryKieModule(this.releaseId, this.kieModuleModel, mfs);
        ResourceProvider resourceProvider = mkm.createResourceProvider();
        String folderContents = IOUtils.toString((InputStream)resourceProvider.getResource("src/main/java").openStream());
        ((AbstractStringAssert)Assertions.assertThat((String)folderContents).hasLineCount(2)).contains(new CharSequence[]{"com", "org"});
    }

    @Test
    public void testGetResourceForFolderWithFilesAndSubFolders() throws Exception {
        MemoryFileSystem mfs = new MemoryFileSystem();
        mfs.createFolder(new MemoryFolder(mfs, "src/main/java"));
        mfs.createFolder(new MemoryFolder(mfs, "src/main/java/org"));
        mfs.createFolder(new MemoryFolder(mfs, "src/main/java/com"));
        mfs.setFileContents(new MemoryFile(mfs, "my-file1", mfs.getFolder("src/main/java")), new byte[10]);
        mfs.setFileContents(new MemoryFile(mfs, "my-file2", mfs.getFolder("src/main/java")), new byte[10]);
        MemoryKieModule mkm = new MemoryKieModule(this.releaseId, this.kieModuleModel, mfs);
        ResourceProvider resourceProvider = mkm.createResourceProvider();
        String folderContents = IOUtils.toString((InputStream)resourceProvider.getResource("src/main/java").openStream());
        ((AbstractStringAssert)Assertions.assertThat((String)folderContents).hasLineCount(4)).contains(new CharSequence[]{"com", "org", "my-file1", "my-file2"});
    }

    @Test
    public void testGetResourceAsStreamForFile() throws Exception {
        MemoryFileSystem mfs = new MemoryFileSystem();
        mfs.setFileContents(new MemoryFile(mfs, "my-file1", mfs.getFolder("src/main/resources")), new byte[]{65, 66});
        MemoryKieModule mkm = new MemoryKieModule(this.releaseId, this.kieModuleModel, mfs);
        ResourceProvider resourceProvider = mkm.createResourceProvider();
        String folderContents = IOUtils.toString((InputStream)resourceProvider.getResourceAsStream("src/main/resources/my-file1"));
        ((AbstractStringAssert)Assertions.assertThat((String)folderContents).hasLineCount(1)).contains(new CharSequence[]{"AB"});
    }

    @Test
    public void testGetResourceAsStreamFolderWithOnlySubFolders() throws Exception {
        MemoryFileSystem mfs = new MemoryFileSystem();
        mfs.createFolder(new MemoryFolder(mfs, "src/main/java"));
        mfs.createFolder(new MemoryFolder(mfs, "src/main/java/org"));
        mfs.createFolder(new MemoryFolder(mfs, "src/main/java/com"));
        MemoryKieModule mkm = new MemoryKieModule(this.releaseId, this.kieModuleModel, mfs);
        ResourceProvider resourceProvider = mkm.createResourceProvider();
        String folderContents = IOUtils.toString((InputStream)resourceProvider.getResourceAsStream("src/main/java"));
        ((AbstractStringAssert)Assertions.assertThat((String)folderContents).hasLineCount(2)).contains(new CharSequence[]{"com", "org"});
    }

    @Test
    public void testGetResourceTrailingSlashIgnored() throws Exception {
        MemoryFileSystem mfs = new MemoryFileSystem();
        mfs.setFileContents(new MemoryFile(mfs, "my-file1", mfs.getFolder("src/main/resources")), new byte[]{65, 66});
        MemoryKieModule mkm = new MemoryKieModule(this.releaseId, this.kieModuleModel, mfs);
        ResourceProvider resourceProvider = mkm.createResourceProvider();
        String noTrailingSlashContents = IOUtils.toString((InputStream)resourceProvider.getResourceAsStream("src/main/resources/my-file1"));
        ((AbstractStringAssert)Assertions.assertThat((String)noTrailingSlashContents).hasLineCount(1)).contains(new CharSequence[]{"AB"});
        String withTrailingSlashContents = IOUtils.toString((InputStream)resourceProvider.getResourceAsStream("src/main/resources/my-file1/"));
        ((AbstractStringAssert)Assertions.assertThat((String)withTrailingSlashContents).hasLineCount(1)).contains(new CharSequence[]{"AB"});
    }
}

